(ns com.vadelabs.turbo-ui.easy-edit.interface
  (:require
   ["react-icons/md" :as md]
   ["react-easy-edit" :refer [Types] :default EasyEdit]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-components.icon.interface :as icon]
   [com.vadelabs.utils-str.interface :as ustr]
   [com.vadelabs.utils-core.string :as str]
   [com.vadelabs.turbo-ui.button.styles :as button]))

(defmulti render
  :variant)

(defui edit-save-btn
  [_]
  ($ :div {:class (sx :bg-gray-200 :rounded-md :w-6 :h-6
                    :flex :items-center :justify-center [:hover :bg-gray-300]
                    [:focus :bg-gray-400])
           :role :button}
    ($ md/MdDone {})))

(defui edit-cancel-btn
  [_]
  ($ :div {:class (sx :bg-gray-200 :rounded-md :w-6 :h-6
                    :flex :items-center :justify-center [:hover :bg-gray-300]
                    [:focus :bg-gray-400])
           :role :button}
    ($ md/MdClose {})))

(def ui-edit-class [(tc/as-react edit-save-btn)
                    (tc/as-react edit-cancel-btn)])

(defui component "Easy-Edit"
  [props]
  (render props))

(defmethod render :default
  [{:keys [class value on-save type hide-button
           save-on-blur cancel-on-blur placeholder] :as props
    :or {hide-button false
         save-on-blur false
         cancel-on-blur false}}]
  ($ EasyEdit {:type (or type "text")
               :value (or value "Click here to edit...")
               :on-save on-save
               :save-button-label ($ edit-save-btn)
               :placeholder placeholder
               :css-class-prefix "default-"
               :save-on-blur save-on-blur
               :cancel-on-blur cancel-on-blur
               :hide-save-button hide-button
               :hide-cancel-button hide-button
               :cancel-button-label ($ edit-cancel-btn)}))

(defmethod render :input
  [{:keys [class value on-save type hide-button placeholder] :as props
    :or {hide-button false
         type "text"}}]
  ($ EasyEdit {:type type
               :value (or value "Click here to edit...")
               :on-save on-save
               :save-button-label ($ edit-save-btn)
               :placeholder placeholder
               :css-class-prefix "input-"
               :cancel-on-blue true
               :hide-save-button hide-button
               :hide-cancel-button hide-button
               :cancel-button-label ($ edit-cancel-btn)}))
