(ns com.vadelabs.turbo-ui.explorer.ui.viewer.html
  (:require [com.vadelabs.turbo-ui.explorer.colors :as c]
            [com.vadelabs.turbo-ui.explorer.ui.styled :as s]
            [com.vadelabs.turbo-ui.explorer.ui.theme :as theme]))

(defn inspect-html [value]
  (let [theme (theme/use-theme)]
    [s/iframe {:style {:width "100%"
                       :height "75vh"
                       :border-radius (:border-radius theme)
                       :border [1 :solid (::c/border theme)]}
               :src-doc value}]))

(def viewer
  {:predicate string?
   :component inspect-html
   :name :com.vadelabs.turbo-ui.explorer.viewer/html})
