(ns com.vadelabs.turbo-ui.context-menu.styles
  (:require
   [com.vadelabs.utils-core.interface :as uc]
   [com.vadelabs.turbo-ui.button.styles :as button]
   [com.vadelabs.turbo-css.interface :refer [sx]]))

(defn classes
  ([class props]
   ((uc/cva {:base class}) props)))

(defn trigger
  ([props]
   ((uc/cva button/variants) props)))

(defn portal
  ([props]
   (classes
     (sx :fixed :inset-0 :z-50 :flex
       :items-start :justify-center
       [:sm :items-center])
     props)))

(defn overlay
  ([props]
   (classes
     (sx :fixed :inset-0
       :z-50 :bg-black
       :backdrop-blur-sm
       :transition-all
       :duration-100)
     props)))

(defn close
  ([props]
   (classes
     (sx :absolute :top-4
       :right-4 :rounded-sm :opacity-70
       :transition-opacity
       [:hover :opacity-100]
       [:focus :outline-none
        :ring-2
        :ring-slate-400
        :ring-offset-2]
       [:disabled :pointer-events-none]
       #_["[data-state=\"open\"]" :bg-slate-100]
       #_[:dark [:focus
                 :ring-slate-400
                 :ring-offset-slate-900]
          #_["[data-state=\"open\"]" :bg-slate-800]])
     props)))

(defn content
  ([props]
   (classes
     (sx :fixed :z-50 :grid :w-full
       :gap-4 :rounded-b-lg :bg-white
       :p-6 :animate-in)
     props)))

(defn header
  ([props]
   (classes
     (sx :flex :flex-col :text-center
       [:space-y 2]
       [:sm :text-left])
     props)))

(defn footer
  ([props]
   (classes
     (sx :flex :flex-col-reverse
       [:sm :flex-row :justify-end])
     props)))

(defn title
  ([props]
   (classes
     (sx :text-lg :font-semibold :text-slate-900
       [:dark :text-slate-50])
     props)))

(defn description
  ([props]
   (classes
     (sx :text-s :text-slate-500
       [:dark :text-slate-400])
     props)))
