(ns com.vadelabs.turbo-ui.accordion.interface
  (:require
   ["@radix-ui/react-accordion" :refer [Root Item Trigger Content]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-icons.interface :as ti]))

(defui component
  [props]
  ($ Root props))

(defui item
  [props]
  (let [class (sx :border-b :border-b-slate-200
                [:dark :border-b-slate-700])
        fprops (cond-> props
                 class (assoc :class class))]
    ($ Item fprops)))

(defui trigger
  [{:keys [children] :as props}]
  (let [class (sx :flex :flex-1
                :items-center
                :justify-between :py-4 :font-medium :transition-all
                [:hover :underline]
                #_["[data-state=\"open\"]>svg" :rotate-18])
        children (conj (vec children)
                   ($ ti/chevron-down {:class (sx :h-4 :w-4 :transition-transform :duration-200)}))
        fprops (-> props
                 (assoc :class class :children children))]
    ($ Trigger fprops)))

(defui content
  [{:keys [children] :as props}]
  (let [class (sx :overflow-hidden :text-sm :transition-all
                ["[data-state=\"open\"]" :animate-accordion-down]
                ["[data-state=\"closed\"]" :animate-accordion-up])
        rprops (apply dissoc props [:children])
        fprops (cond-> rprops
                 class (assoc :class class))]
    ($ Content fprops
      ($ :div {:class (sx :pt-0 :pb-4)}
        children))))
