(ns com.vadelabs.turbo-css.tailwind.svg
  (:require
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
   [com.vadelabs.utils-core.interface :as uc]))

(def ^:private fill-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "fill-" (uc/namify k)))
        {:fill v}))
    {}
    tokens/color-tokens))

(def ^:private stroke-color
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "stroke-" (uc/namify k)))
        {:stroke v}))
    {}
    tokens/color-tokens))

(def ^:private stroke-width
  {:stroke-0	{:stroke-width 0}
   :stroke-1	{:stroke-width 1}
   :stroke-2	{:stroke-width 2}})

(def static-rules
  (uc/deep-merge
    fill-color
    stroke-color
    stroke-width))
