(ns com.vadelabs.turbo-css.tailwind.filter
  (:require
   [com.vadelabs.utils-core.interface :as uc]))

(def ^:private blur
  {:blur-none	{:filter  "blur(0)"}
   :blur-sm	{:filter  "blur(4px)"}
   :blur	{:filter  "blur(8px)"}
   :blur-md	{:filter  "blur(12px)"}
   :blur-lg	{:filter  "blur(16px)"}
   :blur-xl	{:filter  "blur(24px)"}
   :blur-2xl	{:filter  "blur(40px)"}
   :blur-3xl	{:filter  "blur(64px)"}})

(def ^:private brightness
  {:brightness-0	{:filter "brightness(0)"}
   :brightness-50	{:filter "brightness(.5)"}
   :brightness-75	{:filter "brightness(.75)"}
   :brightness-90	{:filter "brightness(.9)"}
   :brightness-95	{:filter "brightness(.95)"}
   :brightness-100	{:filter "brightness(1)"}
   :brightness-105	{:filter "brightness(1.05)"}
   :brightness-110	{:filter "brightness(1.1)"}
   :brightness-125	{:filter "brightness(1.25)"}
   :brightness-150	{:filter "brightness(1.5)"}
   :brightness-200	{:filter "brightness(2)"}})

(def ^:private contrast
  {:contrast-0	{:filter "contrast(0)"}
   :contrast-50	{:filter "contrast(.5)"}
   :contrast-75	{:filter "contrast(.75)"}
   :contrast-100	{:filter "contrast(1)"}
   :contrast-125	{:filter "contrast(1.25)"}
   :contrast-150	{:filter "contrast(1.5)"}
   :contrast-200	{:filter "contrast(2)"}})

(def ^:private drop-shadow
  {:drop-shadow-sm	{:filter "drop-shadow(0 1px 1px rgb(0 0 0 / 0.05))"}
   :drop-shadow	{:filter "drop-shadow(0 1px 2px rgb(0 0 0 / 0.1)) drop-shadow(0 1px 1px rgb(0 0 0 / 0.06))"}
   :drop-shadow-md	{:filter "drop-shadow(0 4px 3px rgb(0 0 0 / 0.07)) drop-shadow(0 2px 2px rgb(0 0 0 / 0.06))"}
   :drop-shadow-lg	{:filter "drop-shadow(0 10px 8px rgb(0 0 0 / 0.04)) drop-shadow(0 4px 3px rgb(0 0 0 / 0.1))"}
   :drop-shadow-xl	{:filter "drop-shadow(0 20px 13px rgb(0 0 0 / 0.03)) drop-shadow(0 8px 5px rgb(0 0 0 / 0.08))"}
   :drop-shadow-2xl	{:filter "drop-shadow(0 25px 25px rgb(0 0 0 / 0.15))"}
   :drop-shadow-none	{:filter "drop-shadow(0 0 #0000)"}})

(def ^:private grayscale
  {:grayscale-0 {:filter "grayscale(0)"}
   :grayscale {:filter "grayscale(100%)"}})

(def ^:private hue-rotate
  {:hue-rotate-0	{:filter "hue-rotate(0deg)"}
   :hue-rotate-15	{:filter "hue-rotate(15deg)"}
   :hue-rotate-30	{:filter "hue-rotate(30deg)"}
   :hue-rotate-60	{:filter "hue-rotate(60deg)"}
   :hue-rotate-90	{:filter "hue-rotate(90deg)"}
   :hue-rotate-180	{:filter "hue-rotate(180deg)"}})

(def ^:private invert
  {:invert-0 {:filter "invert(0)"}
   :invert {:filter "invert(100%)"}})

(def ^:private saturate
  {:saturate-0	{:filter "saturate(0)"}
   :saturate-50	{:filter "saturate(.5)"}
   :saturate-100	{:filter "saturate(1)"}
   :saturate-150	{:filter "saturate(1.5)"}
   :saturate-200	{:filter "saturate(2)"}})

(def ^:private sepia
  {:sepia-0 {:filter "sepia(0)"}
   :sepia {:filter "sepia(100%)"}})

(def ^:private backdrop-blur
  {:backdrop-blur-none	{:backdrop-filter "blur(0)"}
   :backdrop-blur-sm	{:backdrop-filter "blur(4px)"}
   :backdrop-blur	{:backdrop-filter "blur(8px)"}
   :backdrop-blur-md	{:backdrop-filter "blur(12px)"}
   :backdrop-blur-lg	{:backdrop-filter "blur(16px)"}
   :backdrop-blur-xl	{:backdrop-filter "blur(24px)"}
   :backdrop-blur-2xl	{:backdrop-filter "blur(40px)"}
   :backdrop-blur-3xl	{:backdrop-filter "blur(64px)"}})

(def ^:private backdrop-brightness
  {:backdrop-brightness-0	{:backdrop-filter "brightness(0)"}
   :backdrop-brightness-50	{:backdrop-filter "brightness(.5)"}
   :backdrop-brightness-75	{:backdrop-filter "brightness(.75)"}
   :backdrop-brightness-90	{:backdrop-filter "brightness(.9)"}
   :backdrop-brightness-95	{:backdrop-filter "brightness(.95)"}
   :backdrop-brightness-100	{:backdrop-filter "brightness(1)"}
   :backdrop-brightness-105	{:backdrop-filter "brightness(1.05)"}
   :backdrop-brightness-110	{:backdrop-filter "brightness(1.1)"}
   :backdrop-brightness-125	{:backdrop-filter "brightness(1.25)"}
   :backdrop-brightness-150	{:backdrop-filter "brightness(1.5)"}
   :backdrop-brightness-200	{:backdrop-filter "brightness(2)"}})

(def ^:private backdrop-contrast
  {:backdrop-contrast-0	{:backdrop-filter "contrast(0)"}
   :backdrop-contrast-50	{:backdrop-filter "contrast(.5)"}
   :backdrop-contrast-75	{:backdrop-filter "contrast(.75)"}
   :backdrop-contrast-100	{:backdrop-filter "contrast(1)"}
   :backdrop-contrast-125	{:backdrop-filter "contrast(1.25)"}
   :backdrop-contrast-150	{:backdrop-filter "contrast(1.5)"}
   :backdrop-contrast-200	{:backdrop-filter "contrast(2)"}})

(def ^:private backdrop-grayscale
  {:backdrop-grayscale-0	{:backdrop-filter "grayscale(0)"}
   :backdrop-grayscale	{:backdrop-filter "grayscale(100%)"}})

(def ^:private backdrop-hue-rotate
  {:backdrop-hue-rotate-0	{:backdrop-filter "hue-rotate(0deg)"}
   :backdrop-hue-rotate-15	{:backdrop-filter "hue-rotate(15deg)"}
   :backdrop-hue-rotate-30	{:backdrop-filter "hue-rotate(30deg)"}
   :backdrop-hue-rotate-60	{:backdrop-filter "hue-rotate(60deg)"}
   :backdrop-hue-rotate-90	{:backdrop-filter "hue-rotate(90deg)"}
   :backdrop-hue-rotate-180	{:backdrop-filter "hue-rotate(180deg)"}})

(def ^:private backdrop-invert
  {:backdrop-invert-0	{:backdrop-filter "invert(0)"}
   :backdrop-invert	{:backdrop-filter "invert(100%)"}})

(def ^:private backdrop-opacity
  {:backdrop-opacity-0	{:backdrop-filter "opacity(0)"}
   :backdrop-opacity-5	{:backdrop-filter "opacity(0.05)"}
   :backdrop-opacity-10	{:backdrop-filter "opacity(0.1)"}
   :backdrop-opacity-20	{:backdrop-filter "opacity(0.2)"}
   :backdrop-opacity-25	{:backdrop-filter "opacity(0.25)"}
   :backdrop-opacity-30	{:backdrop-filter "opacity(0.3)"}
   :backdrop-opacity-40	{:backdrop-filter "opacity(0.4)"}
   :backdrop-opacity-50	{:backdrop-filter "opacity(0.5)"}})

(def ^:private backdrop-saturate
  {:backdrop-saturate-0	{:backdrop-filter "saturate(0)"}
   :backdrop-saturate-50	{:backdrop-filter "saturate(.5)"}
   :backdrop-saturate-100	{:backdrop-filter "saturate(1)"}
   :backdrop-saturate-150	{:backdrop-filter "saturate(1.5)"}
   :backdrop-saturate-200	{:backdrop-filter "saturate(2)"}})

(def ^:private backdrop-sepia
  {:backdrop-sepia-0	{:backdrop-filter "sepia(0)"}
   :backdrop-sepia	{:backdrop-filter "sepia(100%)"}})

(def static-rules
  (merge
    blur
    brightness
    contrast
    drop-shadow
    grayscale
    hue-rotate
    invert
    saturate
    sepia
    backdrop-blur
    backdrop-brightness
    backdrop-contrast
    backdrop-grayscale
    backdrop-hue-rotate
    backdrop-invert
    backdrop-opacity
    backdrop-saturate
    backdrop-sepia))
