(ns com.vadelabs.turbo-ui.explorer.client.planck
  (:require [planck.http :as http]
            [com.vadelabs.turbo-ui.explorer.client.common :refer (->submit)]))

(def ^:private http-methods
  {"GET"   http/get
   "HEAD"  http/head
   "PATCH" http/patch
   "POST"  http/post
   "PUT"   http/put})

(defn- fetch [url options]
  (let [f (get http-methods (:method options))]
    (f url options)))

(def ^{:see-also ["com.vadelabs.turbo-ui.explorer.api/submit"]}
  submit (->submit fetch))

(comment
  (require '[com.vadelabs.turbo-ui.explorer.client.planck :as c] :reload)
  (c/submit {:port 7777} ::hello)
  (add-tap (partial c/submit {:port 7777}))
  (tap> ::hello))
