(ns com.vadelabs.turbo-css.tailwind.background
  (:refer-clojure :exclude [repeat])
  (:require
   [com.vadelabs.turbo-css.tailwind.tokens :as tokens]
   [com.vadelabs.turbo-css.rule :refer [rule]]
   [com.vadelabs.utils-core.interface :as uc]))

(def ^:private attachment
  "https://tailwindcss.com/docs/background-attachment"
  {:bg-fixed {:background-attachment "fixed"}
   :bg-local {:background-attachment "local"}
   :bg-scroll {:background-attachment "scroll"}})

(def ^:private clip
  "https://tailwindcss.com/docs/background-clip"
  {:bg-clip-border {:background-clip "border-box"}
   :bg-clip-padding	{:background-clip "padding-box"}
   :bg-clip-content {:background-clip "content-box"}
   :bg-clip-text {:background-clip "text"}})

(def ^:private color
  "https://tailwindcss.com/docs/background-color"
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "bg-" (uc/namify k)))
        {:background-color v}))
    {}
    tokens/color-tokens))

(def ^:private origin
  "https://tailwindcss.com/docs/background-origin"
  {:bg-origin-border	{:background-origin "border-box"}
   :bg-origin-padding	{:background-origin "padding-box"}
   :bg-origin-content	{:background-origin "content-box"}})

(def ^:private position
  "https://tailwindcss.com/docs/background-position"
  {:bg-bottom	{:background-position "bottom"}
   :bg-center	{:background-position "center"}
   :bg-left	{:background-position "left"}
   :bg-left-bottom	{:background-position "left bottom"}
   :bg-left-top	{:background-position "left top"}
   :bg-right	{:background-position "right"}
   :bg-right-bottom	{:background-position "right bottom"}
   :bg-right-top	{:background-position "right top"}
   :bg-top	{:background-position "top"}})

(def ^:private repeat
  "https://tailwindcss.com/docs/background-repeat"
  {:bg-repeat	{:background-repeat "repeat"}
   :bg-no-repeat	{:background-repeat "no-repeat"}
   :bg-repeat-x	{:background-repeat "repeat-x"}
   :bg-repeat-y	{:background-repeat "repeat-y"}
   :bg-repeat-round	{:background-repeat "round"}
   :bg-repeat-space	{:background-repeat "space"}})

(def ^:private size
  "https://tailwindcss.com/docs/background-size"
  {:bg-auto	{:background-size "auto"}
   :bg-cover	{:background-size "cover"}
   :bg-contain	{:background-size "contain"}})

(def ^:private image
  "https://tailwindcss.com/docs/background-image"
  {:bg-none	{:background-image "none"}
   :bg-gradient-to-t	{:background-image "linear-gradient(to top, var(--tw-gradient-stops))"}
   :bg-gradient-to-tr	{:background-image "linear-gradient(to top right, var(--tw-gradient-stops))"}
   :bg-gradient-to-r	{:background-image "linear-gradient(to right, var(--tw-gradient-stops))"}
   :bg-gradient-to-br	{:background-image "linear-gradient(to bottom right, var(--tw-gradient-stops))"}
   :bg-gradient-to-b	{:background-image "linear-gradient(to bottom, var(--tw-gradient-stops))"}
   :bg-gradient-to-bl	{:background-image "linear-gradient(to bottom left, var(--tw-gradient-stops))"}
   :bg-gradient-to-l	{:background-image "linear-gradient(to left, var(--tw-gradient-stops))"}
   :bg-gradient-to-tl	{:background-image "linear-gradient(to top left, var(--tw-gradient-stops))"}})

(def ^:private gradient-color-stops
  (reduce-kv
    (fn [acc k v]
      (assoc acc
        (uc/keywordize (uc/str "from-" (uc/namify k)))
        {:--tw-gradient-from v
         :--tw-gradient-to "rgb(255 255 255 / 0)"
         :--tw-gradient-stops "var(--tw-gradient-from), var(--tw-gradient-to)"}
        (uc/keywordize (uc/str "via-" (uc/namify k)))
        {:--tw-gradient-to "rgb(255 255 255 / 0)"
         :--tw-gradient-stops "var(--tw-gradient-from), #c026d3, var(--tw-gradient-to)"}
        (uc/keywordize (uc/str "to-" (uc/namify k)))
        {:--tw-gradient-to v}))
    {}
    tokens/color-tokens))

(defmethod rule :bg
  ([_ x]
   [[:& {:background-color (tokens/colors x)}]]))

(def static-rules
  (uc/deep-merge
    attachment
    clip
    color
    origin
    position
    repeat
    size
    image))
