(ns com.vadelabs.turbo-icons.interface
  (:require
   ["lucide-react" :as lr]
   ["react-icons/fi" :as fi]
   ["react-icons/io" :as io]
   ["react-icons/md" :as md]
   ["react-icons/si" :as si]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]))

(defui loader
  [props]
  ($ lr/Loader2 props))

(defui mail
  [props]
  ($ lr/Mail props))

(defui x
  [props]
  ($ lr/X props))

(defui check
  [props]
  ($ lr/Check props))

(defui google
  [props]
  ($ fi/FcGoogle props))

(defui chevron-down
  [props]
  ($ lr/ChevronDown props))

(defui chevron-right
  [props]
  ($ lr/ChevronRight props))

(defui chevrons-updown
  [props]
  ($ lr/ChevronsUpDown props))

(defui search
  [props]
  ($ lr/Search props))

(defui circle
  [props]
  ($ lr/Circle props))

(defui calendar
  [props]
  ($ lr/Calendar props))

(defui calendar-days
  [props]
  ($ lr/CalendarDays props))

(defui user
  [props]
  ($ lr/User props))

(defui credit-card
  [props]
  ($ lr/CreditCard props))

(defui settings
  [props]
  ($ lr/Settings props))

(defui keyboard
  [props]
  ($ lr/Keyboard props))

(defui users
  [props]
  ($ lr/Users props))

(defui user-plus
  [props]
  ($ lr/UserPlus props))

(defui message-square
  [props]
  ($ lr/MessageSquare props))

(defui plus-circle
  [props]
  ($ lr/PlusCircle props))

(defui github
  [props]
  ($ lr/Github props))

(defui logout
  [props]
  ($ lr/LogOut props))
(defui cloud
  [props]
  ($ lr/Cloud props))
(defui life-buoy
  [props]
  ($ lr/LifeBuoy props))
(defui left-arrow
  [props]
  ($ io/IoIosArrowBack props))
(defui right-arrow
  [props]
  ($ io/IoIosArrowForward props))

(defui render
  [{:keys [class width height icon] :as props}]
  (let [fprops (dissoc props :icon)]
    (case icon
      :search ($ :span fprops
                ($ md/MdOutlineSearch {}))
      :google-maps ($ :span fprops
                     ($ si/SiGooglemaps {}))
      :close ($ :span fprops
               ($ io/IoMdClose {}))
      :cloud ($ :span fprops
               ($ lr/Cloud {}))
      :outline-dashboard ($ md/MdOutlineSpaceDashboard fprops)
      :solid-dashboard ($ md/MdSpaceDashboard fprops)
      ($ :svg {:class class
               :width (or width "1em")
               :height (or height  "1em")
               :fill "currentColor"}
        ($ :use {:href (str "/sprites/icons.svg#" (name icon))})))))
