(ns com.vadelabs.turbo-ui.menubar.interface
  (:require
   ["@radix-ui/react-menubar" :refer [Menu Group Portal Sub
                                      RadioGroup Root Trigger
                                      SubTrigger SubContent
                                      Content Item CheckboxItem
                                      RadioItem Label Separator
                                      ItemIndicator]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-icons.interface :as ti]))

(defui menu
  [props]
  ($ Menu props))

(defui group
  [props]
  ($ Group props))

(defui portal
  [props]
  ($ Portal props))

(defui sub
  [props]
  ($ Sub props))

(defui radio-group
  [props]
  ($ RadioGroup props))

(defui container
  [{:keys [class] :as props}]
  (let [class [(sx :flex :h-10 :items-center :space-x-1 :rounded-md
                 :border :border-slate-300 :bg-white :p-1
                 [:dark :border-slate-700 :bg-slate-800])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ Root fprops)))

(defui trigger
  [{:keys [class] :as props}]
  (let [class [(sx :flex :cursor-default :select-none :items-center
                 [:rounded "0.2rem"] :py-1.5 :px-3 :text-sm :font-medium :outline-none
                 [:focus :bg-slate-100]
                 ["[data-state=\"open\"]" :bg-slate-100]
                 [:dark [:focus :bg-slate-700]
                  ["[data-state=\"open\"]" :bg-slate-700]])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ Trigger fprops)))

(defui sub-trigger
  [{:keys [inset children class] :as props}]
  (let [class [(sx :flex :cursor-default :select-none
                 :items-center :rounded-sm :py-1.5 :px-2
                 :text-sm :font-medium :outline-none
                 [:focus :bg-slate-100]
                 ["[data-state=\"open\"]" :bg-slate-100]
                 [:dark [:focus :bg-slate-700]
                  ["[data-state=\"open\"]" :bg-slate-700]])
               (when inset (sx :pl-8))
               class]
        fprops (-> props
                 (dissoc :inset :children)
                 (assoc :class class))]
    ($ SubTrigger fprops
      children
      ($ ti/chevron-right {:class (sx :ml-auto :h-4 :w-4)}))))

(defui sub-content
  [{:keys [class] :as props}]
  (let [class [(sx :z-50 [:min-w "8rem"] :overflow-hidden :rounded-md :border :border-slate-100 :bg-white :p-1 :shadow-md
                 :animate-in #_:slide-in-from-left-1
                 [:dark :border-slate-700 :bg-slate-800])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ SubContent fprops)))

(defui content
  [{:keys [align align-offset
           side-offset class]
    :or {align "start" align-offset -4 side-offset 8}
    :as props}]
  (let [class [(sx :z-50 [:min-w "12rem"] :overflow-hidden
                 :rounded-md :border :border-slate-100 :bg-white :p-1
                 :text-slate-700 :shadow-md
                 :animate-in :slide-in-from-top-1
                 [:dark:border-slate-800 :bg-slate-800 :text-slate-400])
               class]
        fprops (-> props
                 (dissoc :align :align-offset :side-offset)
                 (assoc :class class
                   :align align
                   :alignOffset align-offset
                   :sideOffset side-offset))]
    ($ Portal {}
      ($ Content fprops))))

(defui item
  [{:keys [inset class] :as props}]
  (let [class [(sx :relative :flex :cursor-default :select-none
                 :items-center :rounded-sm :py-1.5 :px-2 :text-sm
                 :font-medium :outline-none
                 [:focus :bg-slate-100]
                 ["[data-disabled]" :pointer-events-none :opacity-50]
                 [:dark [:focus :bg-slate-700]])
               (when inset (sx :pl-8))
               class]
        fprops (-> props
                 (dissoc :inset)
                 (assoc :class class))]
    ($ Item fprops)))

(defui checkbox-item
  [{:keys [children class] :as props}]
  (let [class [(sx :relative :flex :cursor-default :select-none
                 :items-center :rounded-sm :py-1.5 :pl-8 :pr-2
                 :text-sm :font-medium :outline-none
                 [:focus :bg-slate-100]
                 ["[data-disabled]" :pointer-events-none :opacity-50]
                 [:dark [:focus :bg-slate-700]])
               class]
        fprops (-> props
                 (dissoc :children)
                 (assoc :class class))]
    ($ CheckboxItem fprops
      ($ :span {:class (sx :absolute :left-2 :flex :h-3.5 :w-3.5 :items-center :justify-center)}
        ($ ItemIndicator {}
          ($ ti/check {:class (sx :h-4 :w-4)}))
        children))))

(defui radio-item
  [{:keys [children class] :as props}]
  (let [class [(sx :relative :flex :cursor-default
                 :select-none :items-center :rounded-sm
                 :py-1.5 :pl-8 :pr-2 :text-sm :font-medium :outline-none
                 :focus:bg-slate-100
                 ["[data-disabled]" :pointer-events-none :opacity-50]
                 [:dark [:focus :bg-slate-700]])
               class]
        fprops (-> props
                 (dissoc :children)
                 (assoc :class class))]
    ($ RadioItem fprops
      ($ :span {:class (sx :absolute :left-2 :flex :h-3.5 :w-3.5 :items-center :justify-center)}
        ($ ItemIndicator {}
          ($ ti/circle {:class (sx :h-2 :w-2 :fill-current)})))
      children)))

(defui label
  [{:keys [class inset] :as props}]
  (let [class [(sx :px-2 :py-1.5 :text-sm :font-semibold :text-slate-900
                 [:dark :text-slate-300])
               (when inset (sx :pl-8))
               class]
        fprops (-> props
                 (dissoc :inset)
                 (assoc :class class))]
    ($ Label fprops)))

(defui separator
  [{:keys [class] :as props}]
  (let [class [(sx :-mx-1 :my-1 :h-px :bg-slate-100
                 [:dark :bg-slate-700])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ Separator fprops)))

(defui shortcut
  [{:keys [class] :as props}]
  (let [class [(sx :ml-auto :text-xs :tracking-widest :text-slate-500)
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ :span fprops)))
