(ns com.vadelabs.turbo-ui.command.interface
  (:refer-clojure :exclude [list empty group])
  (:require
   ["cmdk" :refer [CommandEmpty
                   CommandGroup
                   CommandInput
                   CommandItem
                   CommandList
                   CommandRoot
                   CommandSeparator]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-icons.interface :as ti]
   [com.vadelabs.turbo-ui.dialog.interface :as dialog]))

(defui container
  [{:keys [ref] :as props}]
  (let [class (sx :flex :h-full :w-full :flex-col
                :overflow-hidden :rounded-lg :bg-white
                [:dark :bg-slate-800])
        fprops (cond-> props
                 class (assoc :class class :ref ref))]
    ($ CommandRoot fprops)))

(defui dialog
  [{:keys [children] :as props}]
  (let [fprops (apply dissoc props [:children])]
    ($ dialog/container fprops
      ($ dialog/content {:class (sx :overflow-hidden :p-0 :shadow-2xl)}
        ($ container {} children)))))

(defui input
  [props]
  ($ CommandInput props)
  #_(let [class (sx :flex :h-11 :w-full :rounded-md :bg-transparent :py-3 :text-sm :outline-none
                  [:placeholder :text-slate-400]
                  [:disabled :cursor-not-allowed :opacity-50]
                  [:dark :text-slate-50])
          fprops (cond-> props
                   class (assoc :class class))]
      ($ :div {:class (sx :flex :items-center :border-b :border-b-slate-100 :px-4
                        [:dark :border-b-slate-700])
               "cmdk-input-wrapper" ""}
        ($ ti/search {:class (sx :mr-2 :h-4 :w-4 :shrink-0 :opacity-50)})
        ($ CommandInput fprops))))

(defui list
  [props]
  ($ CommandList props))

(defui empty
  [{:keys [ref] :as props}]
  (let [class (sx :py-6 :text-center :text-sm)
        fprops (cond-> props
                 class (assoc :class class :ref ref))]
    ($ CommandEmpty fprops)))

(defui group
  [{:keys [ref] :as props}]
  (let [class (sx :overflow-hidden :py-3 :text-slate-700
                [:dark :text-slate-400])
        fprops (cond-> props
                 class (assoc :class class :ref ref))]
    ($ CommandGroup fprops)))

(defui separator
  [{:keys [ref] :as props}]
  (let [class (sx :-mx-1 :h-px :bg-slate-100
                [:dark :bg-slate-700])
        fprops (cond-> props
                 class (assoc :class class :ref ref))]
    ($ CommandSeparator fprops)))

;; "relative flex cursor-default select-none items-center rounded-md py-1.5 px-2 text-sm font-medium outline-none aria-selected:bg-slate-100 data-[disabled]:pointer-events-none data-[disabled]:opacity-50 dark:aria-selected:bg-slate-700",
(defui item
  [props]
  ($ CommandItem props))

;; "(sx :relative :flex :cursor-default :select-none :items-center :rounded-md :py-1.5 :px-2 :text-sm
;;     :font-medium :outline-none :opacity-50
;;     ["data-selected=true" :bg-slate-400]
;;     ["aria-selected=true" :bg-slate-400])"

(defui shortcut
  [{:keys [ref] :as props}]
  (let [class (sx :ml-auto :text-xs :tracking-widest :text-slate-500)
        fprops (cond-> props
                 class (assoc :class class :ref ref))]
    ($ :span fprops)))
