(ns com.vadelabs.turbo-ui.button.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :inline-flex :items-center :gap-2
           :rounded-lg)
   :defaults {:color :brand
              :size :default}
   :variants {:variant
              {:fluid (sx :font-semibold :w-full :justify-center)}

              :color
              {:white (sx :bg-white
                        :text-gray-900
                        [:focus :border-gray-200]
                        [:hover :shadow-sm :bg-gray-50]
                        [:active :bg-gray-100])
               :brand (sx :bg-brand-500
                        :text-white
                        [:focus :border-brand-700]
                        [:hover :shadow-md :bg-brand-600]
                        [:active :bg-brand-700])
               :gray (sx :bg-gray-100
                       :text-gray-900
                       [:focus :border-gray-300]
                       [:hover :shadow-md :bg-gray-200]
                       [:active :bg-gray-300])}
              :size {:default (sx :p-3 :px-4)
                     :xs (sx :px-3 :py-1 :text-xs)
                     :sm (sx :px-4 :py-1 :text-sm)}}})

(defn classes
  ([props]
   ((uc/cva variants) props)))

#_(classes {:class (sx :bg-red-600)

            :variant :primary})
  ;; => "sx589197266 sx-741534917 sx224401151 sx1172306414"

;; => "sx589197266 sx-741534917 sx224401151"
