(ns com.vadelabs.turbo-css.rule
  (:require
   [com.vadelabs.utils-str.interface :as ustr]))

(defmulti rule
  (fn [k & _] k))

(defmethod rule :default
  [k & types]
  [[:& {k (first types)}]])

(defn defrules
  ([rules]
   (doseq [[k v] rules]
     (if (associative? v)
       (defmethod rule k [_]
         [[:& v]])
       (defmethod rule k [_ x]
         (let [x (get rules x x)]
           [[:& (v x)]])))))
  ([rules pseudo-element-key]
   (doseq [[k v] rules]
     (if (associative? v)
       (defmethod rule k [_]
         [[(ustr/str ":&:" pseudo-element-key) v]])
       (defmethod rule k [_ x]
         (let [x (get rules x x)]
           [[(ustr/str ":&:" pseudo-element-key) (v x)]]))))))

(defn merge-by-selector
  [exps]
  (->> exps
    (group-by first)
    (mapv
      (fn [[selector exps]]
        (let [style (reduce merge (map second exps))
              children (reduce concat (map #(drop 2 %) exps))]
          (cond-> [selector]
            (seq style) (conj style)
            (seq children) (into children)))))))

(defn join-rules
  [rules]
  (->> rules
    (mapcat
      (fn [item]
        (cond
          (and (sequential? item) (every? sequential? item)) item
          (sequential? item) (apply rule item)
          (map? item) [[:& item]]
          :else (rule item))))
    (merge-by-selector)))
