(ns com.vadelabs.turbo-ui.section.interface
  (:require
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-ui.box.styles :as s]))

(def ^:private removable-keys
  (-> s/variants :variants keys))

(defui component
  [props]
  (let [class (s/classes props)
        fprops (cond-> props
                 true (apply dissoc removable-keys)
                 class (assoc :class class))]
    ($ :div fprops)))
