(ns com.vadelabs.turbo-ui.avatar.styles
  (:require
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.utils-core.interface :as uc]))

(def variants
  {:base (sx :flex :p-3 :rounded-lg :items-center :gap-2)
   :defaults {:variant :fluid
              :color :brand}
   :variants {:variant
              {:fluid (sx :font-semibold :w-full :justify-center)}

              :color
              {:white (sx :bg-white
                        :text-gray-900
                        [:hover :shadow-sm :bg-gray-50]
                        [:focus :border-gray-200])
               :brand (sx :bg-brand-500
                        :text-white
                        [:focus :border-brand-700]
                        [:hover :shadow-md :bg-brand-600])}}})

(defn classes
  ([props]
   ((uc/cva variants) props)))
