(ns com.vadelabs.utils-logging.mulog
  (:require
   [com.brunobonacci.mulog :as mu]
   [com.brunobonacci.mulog.buffer :as rb]
   [com.brunobonacci.mulog.core :as core]))

(deftype TapPublisher [buffer transform]
  com.brunobonacci.mulog.publisher.PPublisher
  (agent-buffer [_] buffer)

  (publish-delay [_] 200)

  (publish [_ buffer]
    (doseq [item (transform (map second (rb/items buffer)))]
      (tap> item))
    (rb/clear buffer)))

(defn tap-publisher
  [{:keys [transform] :as _config}]
  (TapPublisher. (rb/agent-buffer 10000) (or transform identity)))

(defn install!
  [config]
  (mu/start-publisher! config))

(defn log-expr
  [form level event-name pairs]
  `(core/log* core/*default-logger* ~event-name
     (list
       :mulog/namespace ~(str *ns*)
       :mulog/line ~(:line (meta form))
       :mulog/level ~level
       ~@pairs)))
