(ns com.vadelabs.turbo-ui.switch.interface
  (:require
   ["@radix-ui/react-switch" :refer [Root Thumb]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   #_[com.vadelabs.turbo-ui.switch.styles :as s]
   #_[com.vadelabs.turbo-icons.interface :as ti]))

(defui component
  "Switch"
  [{:keys [] :as props}]
  (let [class (sx :peer
                :inline-flex
                [:h "24px"]
                [:w "44px"]
                :shrink-0
                :cursor-pointer
                :items-center
                :rounded-full
                :border-2
                :border-transparent
                :transition-colors
                [:focus :outline-none  :ring-2  :ring-slate-400  :ring-offset-2]
                [:disabled :cursor-not-allowed  :opacity-50]

                ["[data-state=\"unchecked\"]" :bg-slate-200]
                ["[data-state=\"checked\"]" :bg-slate-900]
                [:dark:focus:ring-slate-400
                 :focus:ring-offset-slate-900
                 ["[data-state=\"unchecked\"]" :bg-slate-700]
                 ["[data-state=\"checked\"]" :bg-slate-400]])
        fprops (assoc props :class class)]
    ($ Root fprops
      ($ Thumb {:class (sx :pointer-events-none
                         :block
                         :h-5
                         :w-5
                         :rounded-full
                         :bg-white
                         :shadow-lg
                         :ring-0
                         :transition-transform
                         ["[data-state=\"unchecked\"]" :translate-x-0]
                         ["[data-state=\"checked\"]" :translate-x-5])}))))
