(ns com.vadelabs.utils-logging.interface
  (:require
   [lambdaisland.glogi :as glogi]
   #?@(:clj [[com.vadelabs.utils-logging.mulog :as mulog]]
       :cljs [[lambdaisland.glogi.console :as glogi-console]]))
  #?(:cljs (:require-macros [com.vadelabs.utils-logging.interface])))

(defn install!
  [config]
  #?(:clj (mulog/install! config)
     :cljs (glogi-console/install!)))

(defn set-levels
  [config]
  #?(:cljs (glogi/set-levels config)))

#?(:clj
   (do

     (defmacro target [& {:keys [cljs clj]}]
       `(if (:ns ~'&env) ~cljs ~clj))

     (defmacro trace [event-name & pairs]
       (target :clj  (#'mulog/log-expr &form :trace event-name pairs)
         :cljs (#'glogi/log-expr &form :trace pairs)))

     (defmacro debug [event-name & pairs]
       (target :clj  (#'mulog/log-expr &form :debug event-name pairs)
         :cljs (#'glogi/log-expr &form :debug pairs)))

     (defmacro info [event-name & pairs]
       (target :clj  (#'mulog/log-expr &form :info event-name pairs)
         :cljs (#'glogi/log-expr &form :info pairs)))

     (defmacro warn [event-name & pairs]
       (target :clj  (#'mulog/log-expr &form :warn event-name pairs)
         :cljs (#'glogi/log-expr &form :warn pairs)))

     (defmacro error [event-name & pairs]
       (target :clj  (#'mulog/log-expr &form :error event-name pairs)
         :cljs (#'glogi/log-expr &form :error pairs)))))
