(ns com.vadelabs.turbo-css.utils
  (:require
   [com.vadelabs.utils-core.interface :as uc]
   [garden.color :refer [hex->rgb]]
   [garden.units :as units]))

(defn with-alpha
  [color variable]
  (if-let [{:keys [red green blue]} (hex->rgb color)]
    (uc/str-format "rgba(%d,%d,%d,var(%s))"
      red green blue (name variable))
    color))

(defn str-ratio?
  [s]
  (and (string? s)
    (re-matches #"(-?\d+)/(\d+)" s)))

(defn parse-str-ratio
  [s]
  (let [[_ n d] (re-matches #"(-?\d+)/(\d+)" s)]
    #?(:clj (/ (Double/parseDouble n) (Double/parseDouble d))
       :cljs (/ (js/parseFloat n) (js/parseFloat d)))))

(defn as-unit
  ([v]
   (as-unit v :rem))
  ([v preferred-unit]
   (cond
     (units/unit? v) v
     (str-ratio? v) (units/percent (* 100 (parse-str-ratio v)))
     (string? v) v
     :else (case preferred-unit
             :ms (units/ms v)
             :px (units/px v)
             :deg (units/deg v)
             :rem (units/rem (* v 0.25))
             :percent (units/percent v)))))
