(ns com.vadelabs.turbo-ui.navigation.interface
  (:refer-clojure :exclude [list])
  (:require
   ["@radix-ui/react-navigation-menu" :refer [Root List Trigger
                                              Content Viewport
                                              Indicator Item Link]]
   [com.vadelabs.turbo-core.interface :as tc :refer [defui $]]
   [com.vadelabs.turbo-css.interface :refer [sx]]
   [com.vadelabs.turbo-icons.interface :as ti]))

(defui viewport
  [{:keys [class] :as props}]
  (let [class [(sx :origin-top-center :relative :mt-1.5
                 [:h "var(--radix-navigation-menu-viewport-height)"]
                 ["[data-state=\"open\"]" :animate-in
                  :zoom-in-90]
                 ["[data-state=\"closed\"]" :animate-out
                  :zoom-out-95]
                 :w-full :overflow-hidden :rounded-md
                 :border :border-slate-200 :bg-white :shadow-lg
                 [:dark :bg-slate-800]
                 [:md [:w "var(--radix-navigation-menu-viewport-width)"]])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ :div {:class (sx :absolute :left-0 :top-full :flex :justify-center)}
      ($ Viewport fprops))))

(defui container
  [{:keys [class children] :as props}]
  (let [class [(sx :relative :z-10 :flex :flex-1 :items-center :justify-center)
               class]
        fprops (-> props
                 (dissoc :children)
                 (assoc :class class))]
    ($ Root fprops
      children
      ($ viewport {}))))

(defui list
  [{:keys [class] :as props}]
  (let [class [(sx :group :flex :flex-1 :list-none
                 :items-center :justify-center)
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ List fprops)))

(defui trigger
  [{:keys [class children] :as props}]
  (let [class [(sx :inline-flex :items-center :justify-center
                 :rounded-md :text-sm :font-medium :transition-colors
                 :bg-transparent :h-10 :py-2 :px-4 :group :w-max
                 [:focus :outline-none :bg-slate-100]
                 [:disabled :opacity-50]
                 [:dark [:focus :bg-slate-800]]
                 [:disabled :pointer-events-none]
                 [:hover :bg-slate-100]
                 [:dark [:hover :bg-slate-800]
                  :text-slate-100 [:hover :text-slate-100]
                  "[data-state=\"open\"]" :bg-slate-800
                  "[data-active]" :bg-slate-800]
                 ["[data-state=\"open\"]" :bg-slate-50]
                 ["[data-active]" :bg-slate-50])
               class]
        fprops (-> props
                 (dissoc :children)
                 (assoc :class class))]
    ($ Trigger fprops
      children
      ($ ti/chevron-down
        {:class (sx :relative [:top "1px"] :ml-1 :h-3 :w-3 :transition :duration-200
                  ["group-data-state=open" :rotate-180])
         :aria-hidden "true"}))))

(defui content
  [{:keys [class] :as props}]
  (let [class [(sx :top-0 :left-0 :w-full
                 ["[data-motion=\"^from-\"]" :animate-in :fade-in]
                 ["[data-motion=\"^to-\"]" :animate-out :fade-out]
                 ["[data-motion=\"to-start\"]" :slide-out-to-left-52]
                 ["[data-motion=\"to-end\"]" :slide-out-to-right-52]
                 ["[data-motion=\"from-start\"]" :slide-in-from-left-52]
                 ["[data-motion=\"from-end\"]" :slide-in-from-right-52]
                 [:md :absolute :w-auto])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ Content fprops)))

(defui item
  [props]
  ($ Item props))

(defui link
  [props]
  ($ Link props))

(defui indicator
  [{:keys [class] :as props}]
  (let [class [(sx :top-full [:z 1] :flex :h-1.5 :items-end :justify-center
                 :overflow-hidden
                 ["[data-state=\"visible\"]" :animate-in :fade-in]
                 ["[data-state=\"hidden\"]" :animate-out :fade-out])
               class]
        fprops (-> props
                 (assoc :class class))]
    ($ Indicator fprops
      ($ :div {:class (sx :relative [:top "60%"]
                        :h-2 :w-2 :rotate-45 :rounded-tl-sm
                        :bg-slate-200 :shadow-md
                        [:dark :bg-slate-800])}))))
