(defproject com.vadelabs.fds "0.1.0-SNAPSHOT"
  :description "Foundation Design System. The foundation to build design system libraries"
  :url         "https://gitlab.com/vadelabs/ce/foundation-design-system"
  :license     {:name "MIT"}
  :dependencies [[org.clojure/clojure "1.10.1"]
                 [org.clojure/clojurescript "1.10.597"
                  :exclusions [com.google.javascript/closure-compiler-unshaded
                               org.clojure/google-closure-library]]
                 [thheller/shadow-cljs "2.8.71"]
                 [reagent "0.9.0-rc2"]
                 [re-frame "0.11.0-rc2"]
                 [com.stuartsierra/component "0.4.0"]
                 [stylefy "1.14.0"]
                 [bidi "2.1.6"]
                 [kibu/pushy "0.3.8"]]

  :deploy-repositories [["clojars"  {:url "https://clojars.org/repo"
                                     :creds :gpg}]]

  :plugins [[lein-shell "0.5.0"]]

  :min-lein-version "2.5.3"

  :source-paths ["src/clj" "src/cljs"]

  :test-paths   ["test/cljs"]

  :clean-targets ^{:protect false} ["resources/public/js/compiled" "target"
                                    "test/js"]


  :shell {:commands {"open" {:windows ["cmd" "/c" "start"]
                             :macosx  "open"
                             :linux   "xdg-open"}}}

  :aliases {"dev"          ["with-profile" "dev" "do"
                            ["clean"]
                            ["run" "-m" "shadow.cljs.devtools.cli" "watch" "app"]]
            "tdd"          ["with-profile" "dev" "do"
                            ["clean"]
                            ["run" "-m" "shadow.cljs.devtools.cli" "watch" "app" "browser-test"]]
            "prod"         ["with-profile" "prod" "do"
                            ["clean"]
                            ["run" "-m" "shadow.cljs.devtools.cli" "release" "app"]]
            "build-report" ["with-profile" "prod" "do"
                            ["clean"]
                            ["run" "-m" "shadow.cljs.devtools.cli" "run" "shadow.cljs.build-report" "app" "target/build-report.html"]
                            ["shell" "open" "target/build-report.html"]]
            "karma"        ["with-profile" "prod" "do"
                            ["clean"]
                            ["run" "-m" "shadow.cljs.devtools.cli" "--npm" "compile" "karma-test"]
                            ["shell" "./node_modules/.bin/karma" "start" "--single-run" "--reporters" "junit,dots"]]}

  :profiles
  {:dev
   {:dependencies [[binaryage/devtools "0.9.11"]
                   [day8.re-frame/re-frame-10x "0.4.5"]
                   [day8.re-frame/tracing "0.5.3"]]}

   :prod {:dependencies [[day8.re-frame/tracing-stubs "0.5.3"]]}})
