(ns com.vadelabs.datasource-xero.interface
  (:require
   [com.vadelabs.datasource-core.interface :as dc]
   [com.vadelabs.rest-core.interface :as rc]
   [com.vadelabs.utils-core.interface :as uc]
   [com.vadelabs.utils-core.string :as ustr]))

(def default-handlers
  [{:route-name :userinfo
    :summary "user info"
    :method :get
    :path-parts ["/api.xro/2.0/Organisation"]
    :produces ["application/json"]
    :consumes ["application/json"]}
   {:route-name :tenants
    :summary "list tenants"
    :method :get
    :path-parts ["/connections"]
    :produces ["application/json"]
    :consumes ["application/json"]}])

(defn add-auth-header
  [{:keys [token xero-tenant-id]}]
  {:name :xero/add-auth-header
   :enter (fn [ctx]
            (update-in ctx [:request :headers]
              (fn [headers]
                (cond-> headers
                  token (assoc "Authorization" (str "Bearer " token))
                  xero-tenant-id (assoc "Xero-Tenant-Id" xero-tenant-id)))))})

(defn make-http-instance
  [{:keys [identifier config] :as params}]
  (let [{:keys [base-url]} config
        ;; fname (ustr/format "datasource-xero/%s.yaml" (uc/namify identifier))
        ;; definition (uc/yaml-resource fname)
        ;; handlers (rc/openapi->handlers definition)
        ;; base-url (or base-url (rc/openapi-base-url definition))
        base-url #_(ustr/rtrim base-url "/") "https://api.xero.com"
        interceptors dc/perform-sync-request]
    (dc/bootstrap base-url default-handlers
      {:interceptors interceptors :use-defaults? true})))

(defmethod dc/http-instance :xero
  [aenv]
  (make-http-instance aenv))

(defn get-tenant-id
  [token]
  (let [add-auth-header (add-auth-header {:token token})
        interceptors (dc/inject dc/perform-sync-request add-auth-header :before :dci/encode-request-body)
        http-client (dc/bootstrap "https://api.xero.com" default-handlers {:interceptors interceptors :use-defaults? true})]
    (-> http-client
      (dc/response-for :tenants {})
      :body
      first
      :tenantId)))

(defmethod dc/oauth2-instance :xero
  [{:keys [http-instance identifier config]} {:keys [route-name access-tokens]}]
  (let [{:keys [base-url]} config
        fname (ustr/format "datasource-xero/%s.yaml" (uc/namify identifier))
        definition (uc/yaml-resource fname)
        handlers (rc/openapi->handlers definition)
        base-url (or base-url (rc/openapi-base-url definition))
        base-url #_(ustr/rtrim base-url "/") "https://api.xero.com"
        {:keys [token]} access-tokens
        xero-tenant-id (get-tenant-id token) #_"9f1f6d87-5051-45e6-9e26-b31ad869861c"
        add-auth-header (add-auth-header {:token token :xero-tenant-id xero-tenant-id})
        interceptors (dc/inject dc/perform-sync-request add-auth-header :before :dci/encode-request-body)]
    (try
      (println "TOKEN VAL" (get-tenant-id token))
      (catch Exception e
        (println "exception occured")))
    (dc/bootstrap base-url default-handlers
      {:interceptors interceptors :use-defaults? true})))

(defmethod dc/oauth2-config :xero
  [{:keys [client-id client-secret host-root-url landing-uri]
    :or {host-root-url "http://localhost:3000"
         client-id "652217A27D584682B6658F457B10C4CB"
         client-secret "A3qsIvyAkzwxjxZJRav-l8L8-BW0ZLoKZqYUIjitLk7YOSPt"
         landing-uri "/"}}]
  {:authorize-uri "https://login.xero.com/identity/connect/authorize"
   :access-token-uri "https://identity.xero.com/connect/token"
   :client-id client-id
   :client-secret client-secret
   :scopes ["email" "openid" "profile"]
   :launch-uri "/oauth2/xero/login"
   :redirect-uri (str host-root-url "/oauth2/xero/callback")
   :landing-uri landing-uri
   :label "Continue With Xero"})
