(ns com.vadelabs.datasource-xero.interface
  (:require
   [com.vadelabs.datasource-core.interface :as dc]
   [com.vadelabs.rest-core.interface :as rc]
   [com.vadelabs.utils-core.interface :as uc]
   [com.vadelabs.utils-core.string :as ustr]))

(defn make-http-instance
  [{:keys [identifier config]}]
  (let [{:keys [base-url]} config
        fname (ustr/format "datasource-xero/%s.yaml" (uc/namify identifier))
        definition (uc/yaml-resource fname)
        handlers (rc/openapi->handlers definition)
        base-url (or base-url (rc/openapi-base-url definition))
        base-url (ustr/rtrim base-url "/")
        interceptors (into [] dc/perform-sync-request)]
    (dc/bootstrap base-url handlers {:interceptors interceptors :use-defaults? true})))

(defmethod dc/http-instance :xero/authorization-url
  [{:keys [config]}]
  (let [{:keys [base-url]
         :or {base-url "https://login.xero.com/"}} config
        handlers [{:consumes #{}}]
        base-url (ustr/rtrim base-url "/")
        interceptors (into [] dc/perform-sync-request)]
    (dc/bootstrap base-url handlers {:interceptors interceptors :use-defaults? true})))

(defmethod dc/http-instance :xero/token-url
  [{:keys []}])

(defmethod dc/http-instance :xero/accounting
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/app-store
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/assets
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/bankfeeds
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/files
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/finance
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/identity
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/payroll-au
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/payroll-nz
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/payroll-uk
  [aenv]
  (make-http-instance aenv))

(defmethod dc/http-instance :xero/projects
  [aenv]
  (make-http-instance aenv))

(comment

  (def api-key "42umXc7YyY6eb6D4FCopI3LXcwmOQX4dDmQ0WuIltZlc5yt_")
  (def client-id "652217A27D584682B6658F457B10C4CB")

  (def accounting
    (dc/http-instance
      {:identifier :xero/accounting
       :config {:api-key api-key :client-id client-id}}))

  (rc/handler-for accounting :get-item)

  (rc/explore accounting)

  :rcf)
