(ns com.vadelabs.datasource-core.interface
  (:require
   [com.vadelabs.datasource-core.interceptors :as dci]
   [com.vadelabs.rest-core.interface :as rc]))

(def common-interceptors
  [dci/keywordize-params
   dci/set-method
   dci/set-url
   dci/set-query-params
   dci/set-body-params
   dci/set-form-params
   dci/set-header-params
   dci/enqueue-route-interceptors
   dci/encode-request-body
   dci/encode-response-body])

(def perform-sync-request
  (conj common-interceptors dci/perform-sync-request))

(def perform-sse-request
  (conj common-interceptors dci/perform-sse-request))

(def perform-async-request
  (conj common-interceptors dci/perform-async-request))

(defn bootstrap
  [& args]
  (apply rc/bootstrap args))

(defmulti http-instance
  "Multimethod to instantiate rest datasource"
  :identifier)

(defmethod http-instance :default
  [{:keys [identifier]}]
  (throw (ex-info (format "No http instance available for %s" identifier) {:identifier identifier})))
