(ns com.vadelabs.adapter-postgres.pathom
  (:require
   [com.vadelabs.adapter-core.interface :as ac]
   [com.vadelabs.sql-core.interface :as sc]
   [com.wsscode.pathom3.connect.planner :as pcp]
   :reload))

(defmethod ac/pathom-op [:postgres :save]
  [aenv action]
  (ac/mutation action (fn [_ pparams]
                        (let [results (sc/save! aenv pparams)]
                          {:tempids (->> results
                                      (mapcat identity)
                                      (reduce (fn [acc {:keys [id]}]
                                                (assoc acc id id))
                                        {}))}))))

(defmethod ac/pathom-op [:postgres :delete]
  [aenv action]
  (ac/mutation action (partial sc/delete! aenv action)))

#_(partial sc/query aenv action)

(defmethod ac/pathom-op [:postgres :fetch]
  [aenv {:action/keys [identifier] :as action}]
  (ac/fetch action (fn [penv _]
                     (tap> {:resp (->> penv ::pcp/graph ::pcp/source-ast (sc/query aenv))})
                     {identifier (->> penv ::pcp/graph ::pcp/source-ast (sc/query aenv))})))

(defmethod ac/pathom-op [:postgres :fetch-one]
  [aenv action]
  (ac/fetch-one action (fn [penv input]
                         (tap> {:penv penv
                                :input input})
                         (->> penv ::pcp/graph ::pcp/source-ast (sc/query aenv) first))))
