(ns com.vadelabs.adapter-core.utils
  (:require
   [com.vadelabs.utils-core.interface :as uc]))

(defn attributes->pathom-query
  ([attrs]
   (reduce
     (fn [acc {:attribute/keys [qualified-key qualified-target local-key target]}]
       (let [qualified-key (or qualified-key local-key)
             qualified-target (or qualified-target target)]
         (cond-> acc
           qualified-target (conj {qualified-key [qualified-target]})
           (not qualified-target) (conj qualified-key))))
     []
     attrs)))

(defn ->action
  ([nspace]
   (let [prefix-fn (partial uc/keywordize nspace)]
     [{:action/identifier (prefix-fn :delete!)
       :action/display-name "Delete records"
       :action/type :delete
       :action/params [:delta :data]
       :action/output [:tempids]}
      {:action/identifier (prefix-fn :save!)
       :action/display-name "Save records"
       :action/type :save
       :action/params [:delta :data]
       :action/output [:tempids]}]))
  ([nspace entity attributes]
   (let [prefix-fn (partial uc/keywordize nspace entity)]
     [{:action/identifier (uc/keywordize nspace (uc/plural entity))
       :action/display-name "Fetch records"
       :action/type :fetch
       :action/input []
       :action/params []
       :action/output (attributes->pathom-query attributes)}]))
  ([nspace entity attribute-key attributes]
   (let [prefix-fn (partial uc/keywordize nspace entity)]
     [{:action/identifier (prefix-fn attribute-key)
       :action/display-name "Fetch records"
       :action/type :fetch-one
       :action/input [(prefix-fn attribute-key)]
       :action/params []
       :action/output (attributes->pathom-query attributes)}])))

(defn adapter-actions
  [attrs]
  (->> attrs
    (uc/group-by :attribute/remote-ns)
    keys
    (reduce (fn [acc remote-ns]
              (into acc (->action remote-ns)))
      [])))

(defn entity-actions
  [attrs]
  (->> attrs
    (uc/group-by (juxt :attribute/remote-ns :attribute/remote-entity))
    (reduce-kv (fn [acc [remote-ns remote-entity] attributes]
                 (into acc (->action remote-ns remote-entity attributes)))
      [])))

(defn attribute-actions
  [attrs]
  (->> attrs
    (uc/group-by (juxt :attribute/remote-ns :attribute/remote-entity))
    (reduce-kv (fn [acc [remote-ns remote-entity] attributes]
                 (into acc (->action remote-ns remote-entity :id attributes)))
      [])))
