(ns com.vadelabs.sql-core.interface
  (:require
   [com.vadelabs.sql-core.database :as database]
   [com.vadelabs.sql-core.entity :as entity]
   [com.vadelabs.sql-core.migrate :as migrate]
   [honey.sql :as hsql]
   [next.jdbc :as jdbc]))

(def ^:private active-db-conn (atom nil))

(defn connect
  [{:keys [config]}]
  (if @active-db-conn @active-db-conn
    (reset! active-db-conn (database/connect config))))

(defn disconnect!
  [{:keys [db-conn]}]
  (database/disconnect! db-conn))

(defn save!
  [& args])

(defn delete!
  [& args])

(defn insert!
  [& args])

(defn insert-multi!
  [& args])

(defn update!
  [& args])

(defn query
  [& args])

(defn query-single
  [& args])

(defn create-db-schema!
  [{:keys [db-conn nspace]}]
  (->> {:create-schema [nspace :if-not-exists]}
    hsql/format
    (jdbc/execute! db-conn)))

(defn create-migrations-table!
  [{:keys [db-conn migrations-table]}])

(defn apply-migrations!
  [opts]
  (migrate/apply-migrations! opts))

(defn register-entities
  [entity-map]
  (entity/register-entities entity-map))
