(ns com.vadelabs.adapter-xtdb.interface
  (:require
   [com.vadelabs.adapter-core.interface :as ac]
   [com.vadelabs.adapter-xtdb.main :as xtdb]
   [com.vadelabs.adapter-xtdb.pathom]
   [com.vadelabs.adapter-xtdb.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]
   [xtdb.api :as xt]))

(defn ^:private transaction-functions->txs
  [t-fns]
  (reduce
    (fn [txs [fn-id fn-body]]
      (conj txs [::xt/put {:xt/id fn-id
                           :xt/fn fn-body}]))
    []
    t-fns))

(defmethod ac/initiate-aenv! :adapter.type/xtdb
  [genv {:adapter/keys [type id]}]
  (let [{:keys [config]} (get-in genv [type id])
        node (xt/start-node config)]
    (xt/submit-tx node (transaction-functions->txs xtdb/transaction-functions))
    (-> genv
      (assoc-in [type id :node] node))))

(defmethod ac/halt-aenv! :adapter.type/xtdb
  [genv {:adapter/keys [type id]}]
  (let [{:keys [node]} (get-in genv [type id])]
    (.close node)))

(defmethod ac/attributes :adapter.type/xtdb
  [genv {:adapter/keys [type nspace id attributes] :or {attributes []} :as adapter}]
  (let [attributes (mapv (fn [{:attribute/keys [remote-ns remote-entity remote-key
                                                remote-type local-key local-type] :as attribute}]
                           (ac/prepare-attribute adapter
                             (assoc attribute
                               :attribute/remote-ns (or remote-ns nspace)
                               :attribute/remote-entity (or remote-entity (-> local-key namespace keyword))
                               :attribute/remote-key (or remote-key local-key)
                               :attribute/remote-type (or remote-type (-> local-type name keyword)))))
                     attributes)
        attributes-map (ac/attributes-map attributes)]
    (-> genv
      (assoc-in [type id :attributes] attributes)
      (assoc-in [type id :attributes-map] attributes-map))))

(defmethod ac/default-actions :adapter.type/xtdb
  [adapter attributes]
  (let [adapter-actions (utils/adapter-actions attributes)
        entity-actions (utils/entity-actions adapter attributes)]
    (uc/concat-vec adapter-actions entity-actions)))

(defmethod ac/actions :adapter.type/xtdb
  [genv {:adapter/keys [type id] :as adapter}]
  (let [{:keys [attributes]} (get-in genv [type id])
        actions (ac/default-actions adapter attributes)]
    (-> genv
      (assoc-in [type id :actions] actions))))

(def ^:private adapter
  {:adapter/id (uc/uuid ::adapter)
   :adapter/nspace :xtdb
   :adapter/identifier :xtdb
   :adapter/type :adapter.type/xtdb
   :adapter/qualify-attributes false
   :adapter/config {}})

(def datasources
  [{:datasource/id (uc/uuid ::datasource)
    :datasource/display-name "XTDB"
    :datasource/description "XTDB is a general-purpose bitemporal database for SQL, Datalog & graph queries."
    :datasource/slug "xtdb"
    :datasource/icon "https://avatars.githubusercontent.com/u/80914002?s=200&v=4"
    :datasource/preview "https://xtdb.com/images/logo.svg"
    :datasource/adapter adapter
    :datasource/attributes []
    :datasource/actions []
    :datasource/categories []
    :datasource/collections []}])
