(ns com.vadelabs.adapter-postgres.pathom
  (:require
   [com.vadelabs.adapter-core.interface :as ac]
   [com.vadelabs.sql-core.interface :as sc]))

(defmethod ac/pathom-op [:postgres :insert]
  [aenv action]
  (ac/mutation action (partial sc/insert! aenv action)))

(defmethod ac/pathom-op [:postgres :insert-multi]
  [aenv action]
  (ac/mutation action (partial sc/insert-multi! aenv action)))

(defmethod ac/pathom-op [:postgres :update]
  [aenv action]
  (ac/mutation action (partial sc/update! aenv action)))

(defmethod ac/pathom-op [:postgres :save]
  [aenv action]
  (ac/mutation action (partial sc/save! aenv action)))

(defmethod ac/pathom-op [:postgres :delete]
  [aenv action]
  (ac/mutation action (partial sc/delete! aenv action)))

(defmethod ac/pathom-op [:postgres :query]
  [aenv action]
  (ac/query action (partial sc/query aenv action)))

(defmethod ac/pathom-op [:postgres :query-single]
  [aenv action]
  (ac/query-single action (partial sc/query-single aenv action)))
