(ns com.vadelabs.rest-core.encoding
  (:require
   [com.vadelabs.utils-core.interface :as uc]))

(defn choose-content-type [encoders options]
  (some (set options) (keys encoders)))

(def auto-encoder
  {:encode identity
   :decode identity
   :as :auto})

(defn find-encoder
  [encoders content-type]
  (if (uc/str-blank? content-type)
    auto-encoder
    (loop [encoders encoders]
      (let [[ct encoder] (first encoders)]
        (cond
          (not content-type) auto-encoder

          (not encoder) auto-encoder

          (uc/str-includes? content-type ct) encoder

          :else
          (recur (rest encoders)))))))
