(ns com.vadelabs.sql-core.nodes.select
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.sql-core.spec :as spec]
   [next.jdbc.sql.builder :as sql]))

(defmethod ast/compile [:postgres :select]
  [env [_ {:keys [props table where]}]]
  (sql/for-query table (or where :all)
    (merge spec/default-opts props)))

(comment

  (ast/format
    [:select {:offset 0 :limit 1
              :order-by [[:created-at :desc]]}
     :mstore])

  :rcf)
