(ns com.vadelabs.sql-core.nodes.drop-table
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defmethod ast/compile [:postgres :drop-table]
  [env [_ {:keys [op props table]}]]
  (let [{:keys [if-exists cascade restrict]} props]
    (uc/sql-join " "
      (cond-> [(uc/sql-literal op)]
        if-exists (into [(uc/sql-literal :if-exists)])
        table (into [(uc/sql-name env table)])
        cascade (into [(uc/sql-literal :cascade)])
        restrict (into [(uc/sql-literal :restrict)])))))

(comment

  (ast/format [:drop-table {:if-exists true :cascade true}
               :sone])
  ;; => ["DROP TABLE IF EXISTS sone CASCADE"]

  :rcf)
