(ns com.vadelabs.sql-core.nodes.primitive
  (:require
   [com.vadelabs.sql-core.ast :as ast]
   [com.vadelabs.utils-core.interface :as uc]))

(defmethod ast/compile [:postgres :primitive]
  [env [_ value]]
  [#_(cond
       (string? value) (uc/sql-name env value)
       (keyword? value) (uc/str-format "'%s'" (uc/namify value))
       :else value)
   (uc/sql-name env value)])

(comment

  (ast/format :eone)

  :rcf)
