(ns com.vadelabs.datasource-core.interface
  (:require
   [com.vadelabs.datasource-core.interceptors :as dci]
   [com.vadelabs.rest-core.interface :as rc]
   [com.vadelabs.utils-exception.interface :as uex]
   [com.vadelabs.utils-str.interface :as ustr]
   [martian.core :as mc]
   [martian.interceptors :as mi]))

(def common-interceptors
  [dci/keywordize-params
   dci/set-method
   dci/set-url
   dci/set-query-params
   dci/set-body-params
   dci/set-form-params
   dci/set-header-params
   dci/enqueue-route-interceptors
   dci/encode-request-body
   dci/encode-response-body])

(def perform-sync-request
  (conj common-interceptors dci/perform-sync-request))

(def perform-sse-request
  (conj common-interceptors dci/perform-sse-request))

(def perform-async-request
  (conj common-interceptors dci/perform-async-request))

(defn bootstrap
  [& args]
  (apply mc/bootstrap args))

(defmulti http-instance
  "Multimethod to instantiate rest datasource"
  (fn [{:keys [identifier]}]
    (-> identifier namespace keyword)))

(defmulti oauth2-instance
  (fn [{:keys [identifier]} & _args]
    (-> identifier namespace keyword)))

(defmulti oauth2-config
  (fn [{:keys [identifier]}]
    (-> identifier namespace keyword)))

(defmethod http-instance :default
  [{:keys [identifier] :as aenv}]
  (uex/raise :type :not-implemented
    :code :http-instance-not-implemented
    :aenv aenv
    :hint (ustr/format "No http instance available for %s" identifier)))

(defmethod oauth2-instance :default
  [{:keys [identifier] :as aenv} & _]
  (uex/raise :type :not-implemented
    :code :oauth2-instance-not-implemented
    :aenv aenv
    :hint (ustr/format "No oauth2 instance available for %s" identifier)))

(defmethod oauth2-config :default
  [{:keys [identifier] :as aenv}]
  (uex/raise :type :not-implemented
    :code :oauth2-config-not-implemented
    :aenv aenv
    :hint (ustr/format "No oauth2 config available for %s" identifier)))

(defn response-for
  [& args]
  (apply mc/response-for args))

(defn request-for
  [& args]
  (apply mc/request-for args))

(defn inject
  [& args]
  (apply mi/inject args))

(defn update-handler
  [& args]
  (apply mc/update-handler args))
