(ns com.vadelabs.adapter-xtdb.interface
  (:require
   [com.vadelabs.adapter-core.interface :as ac]
   [com.vadelabs.adapter-xtdb.main :as xtdb]
   [com.vadelabs.adapter-xtdb.pathom :as pathom]
   [com.vadelabs.adapter-xtdb.utils :as utils]
   [com.vadelabs.utils-core.interface :as uc]
   [com.wsscode.pathom3.connect.indexes :as pci]
   [xtdb.api :as xt]))

(defn ^:private transaction-functions->txs
  [t-fns]
  (reduce
    (fn [txs [fn-id fn-body]]
      (conj txs [::xt/put
                 {:xt/id fn-id
                  :xt/fn fn-body}]))
    []
    t-fns))

(defmethod ac/initiate-env! :adapter.type/xtdb
  [genv {:adapter/keys [type id]}]
  (let [{:keys [config]} (get-in genv [type id])
        node (xt/start-node config)]
    (xt/submit-tx node (transaction-functions->txs xtdb/transaction-functions))
    (-> genv
      (assoc-in [type id :node] node))))

(defmethod ac/halt-env! :adapter.type/xtdb
  [genv {:adapter/keys [type id]}]
  (let [{:keys [node]} (get-in genv [type id])]
    (.close node)))

(defmethod ac/sync-schema! :adapter.type/xtdb
  [genv _]
  genv)

(defmethod ac/pathom-env :adapter.type/xtdb
  [genv {:adapter/keys [type id]}]
  (let [aenv (get-in genv [type id])]
    (->> aenv
      pathom/operations
      (pci/register genv))))

(defmethod ac/enrich-attribute :adapter.type/xtdb
  [{:adapter/keys [nspace] :as adapter}
   {:attribute/keys [local-key local-type remote-ns
                     remote-entity remote-key remote-type]
    :as attribute}]
  (let [attribute (assoc attribute
                    :attribute/remote-ns (or remote-ns nspace)
                    :attribute/remote-entity (or remote-entity (-> local-key namespace keyword))
                    :attribute/remote-key (or remote-key local-key)
                    :attribute/remote-type (or remote-type (-> local-type name keyword)))]
    (ac/enrich-attribute (dissoc adapter :adapter/type) attribute)))

(defmethod ac/default-actions :adapter.type/xtdb
  [adapter attributes]
  (let [adapter-actions (utils/adapter-actions attributes)
        entity-actions (utils/entity-actions adapter attributes)]
    (uc/concat-vec
      adapter-actions
      entity-actions)))
