(ns com.vadelabs.adapter-core.spec
  (:require
   [com.vadelabs.utils-core.interface :as uc]
   [malli.core :as m]))

(def ^:private local-types
  [:enum
   :attribute.type/bigdec
   :attribute.type/bigint
   :attribute.type/boolean
   :attribute.type/double
   :attribute.type/enum
   :attribute.type/float
   :attribute.type/instant
   :attribute.type/keyword
   :attribute.type/long
   :attribute.type/map
   :attribute.type/ref
   :attribute.type/string
   :attribute.type/symbol
   :attribute.type/tuple
   :attribute.type/uuid
   :attribute.type/uri])

(def ^:private attribute
  (m/schema
    [:* [:map {}
         [:attribute/id :uuid]
         [:attribute/local-key :keyword]
         [:attribute/local-type local-types]

         [:attribute/remote-ns :keyword]
         [:attribute/remote-entity :keyword]
         [:attribute/remote-key :keyword]
         [:attribute/remote-type :keyword]

         [:attribute/primary-key {:optional true} :boolean]
         [:attribute/unique {:optional true} :boolean]
         [:attribute/cardinality {} [:enum :one :many]]
         [:attribute/doc {:optional true} :string]]]))

(def conform
  "Conforms the attribute spec"
  (partial uc/spec-conform attribute))
