/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.OutputStream;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.common.BrokerNotAvailableException;
import kafka.common.TopicAndPartition;
import kafka.consumer.SimpleConsumer;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsumerOffsetChecker$
implements Logging {
    public static final ConsumerOffsetChecker$ MODULE$;
    private final scala.collection.mutable.Map<Object, Option<SimpleConsumer>> consumerMap;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    static {
        new ConsumerOffsetChecker$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerOffsetChecker$ consumerOffsetChecker$ = this;
        synchronized (consumerOffsetChecker$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    private scala.collection.mutable.Map<Object, Option<SimpleConsumer>> consumerMap() {
        return this.consumerMap;
    }

    public final Option<SimpleConsumer> kafka$tools$ConsumerOffsetChecker$$getConsumer(ZkClient zkClient, int n) {
        None$ none$ = null;
        try {
            Object object;
            Option<Object> option;
            Option option2 = (Option)ZkUtils$.MODULE$.readDataMaybeNull(zkClient, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)BoxesRunTime.boxToInteger((int)n)).toString())._1();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String string = (String)some.x();
                String string2 = string;
                option = Json$.MODULE$.parseFull(string2);
                if (!(option instanceof Some)) {
                    None$ none$2 = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (!(none$2 != null ? !none$2.equals(option3) : option3 != null)) {
                        throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                    }
                    throw new MatchError(option);
                }
            } else {
                None$ none$3 = None$.MODULE$;
                Option option4 = option2;
                if (!(none$3 != null ? !none$3.equals(option4) : option4 != null)) {
                    throw new BrokerNotAvailableException(Predef$.MODULE$.augmentString("Broker id %d does not exist").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n)})));
                }
                throw new MatchError((Object)option2);
            }
            Some some = (Some)option;
            Object object2 = object = some.x();
            Map map = (Map)object2;
            String string = (String)map.get((Object)"host").get();
            int n2 = BoxesRunTime.unboxToInt((Object)map.get((Object)"port").get());
            none$ = new Some((Object)new SimpleConsumer(string, n2, 10000, 100000, "ConsumerOffsetChecker"));
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Could not parse broker info";
                }
            }, (Function0<Throwable>)new Serializable(throwable){
                public static final long serialVersionUID;
                private final Throwable t$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = throwable;
                }
            });
            none$ = None$.MODULE$;
        }
        return none$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void kafka$tools$ConsumerOffsetChecker$$processPartition(ZkClient zkClient, String string, String string2, int n) {
        long l = Predef$.MODULE$.augmentString((String)ZkUtils$.MODULE$.readData(zkClient, Predef$.MODULE$.augmentString("/consumers/%s/offsets/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, string2, BoxesRunTime.boxToInteger((int)n)})))._1()).toLong();
        Option option = (Option)ZkUtils$.MODULE$.readDataMaybeNull(zkClient, Predef$.MODULE$.augmentString("/consumers/%s/owners/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, string2, BoxesRunTime.boxToInteger((int)n)})))._1();
        Option<Object> option2 = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, string2, n);
        if (option2 instanceof Some) {
            int n2;
            Some some = (Some)option2;
            int n3 = n2 = BoxesRunTime.unboxToInt((Object)some.x());
            Option option3 = (Option)this.consumerMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)n3), (Function0)new Serializable(zkClient, n3){
                public static final long serialVersionUID;
                private final ZkClient zkClient$1;
                private final int bid$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Option<SimpleConsumer> apply() {
                    return ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$getConsumer(this.zkClient$1, this.bid$1);
                }
                {
                    this.zkClient$1 = zkClient;
                    this.bid$1 = n;
                }
            });
            Option option4 = option3;
            if (option4 instanceof Some) {
                Object object;
                SimpleConsumer simpleConsumer;
                Some some2 = (Some)option4;
                SimpleConsumer simpleConsumer2 = simpleConsumer = (SimpleConsumer)some2.x();
                TopicAndPartition topicAndPartition = new TopicAndPartition(string2, n);
                OffsetRequest offsetRequest = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition).$minus$greater((Object)new PartitionOffsetRequestInfo(OffsetRequest$.MODULE$.LatestTime(), 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                long l2 = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)simpleConsumer2.getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                long l3 = l2 - l;
                StringOps stringOps = Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s");
                Object[] objectArray = new Object[7];
                objectArray[0] = string;
                objectArray[1] = string2;
                objectArray[2] = BoxesRunTime.boxToInteger((int)n);
                objectArray[3] = BoxesRunTime.boxToLong((long)l);
                objectArray[4] = BoxesRunTime.boxToLong((long)l2);
                objectArray[5] = BoxesRunTime.boxToLong((long)l3);
                Option option5 = option;
                if (option5 instanceof Some) {
                    object = ((Some)option5).x();
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option6 = option5;
                    if (none$ == null) {
                        if (option6 != null) {
                            throw new MatchError((Object)option5);
                        }
                    } else if (!none$.equals(option6)) throw new MatchError((Object)option5);
                    object = "none";
                }
                objectArray[6] = object;
                Predef$.MODULE$.println((Object)stringOps.format((Seq)Predef$.MODULE$.genericWrapArray((Object)objectArray)));
                simpleConsumer2.close();
                return;
            }
            None$ none$ = None$.MODULE$;
            Option option7 = option4;
            if (none$ == null) {
                if (option7 == null) return;
                throw new MatchError((Object)option4);
            }
            if (none$.equals(option7)) return;
            throw new MatchError((Object)option4);
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option8 = option2;
        if (none$ == null) {
            if (option8 != null) {
                throw new MatchError(option2);
            }
        } else if (!none$.equals(option8)) throw new MatchError(option2);
        this.error((Function0<String>)new Serializable(string2, n){
            public static final long serialVersionUID;
            private final String topic$1;
            private final int pid$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("No broker for partition %s - %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.pid$1)}));
            }
            {
                this.topic$1 = string;
                this.pid$1 = n;
            }
        });
    }

    public final void kafka$tools$ConsumerOffsetChecker$$processTopic(ZkClient zkClient, String string, String string2) {
        Option option;
        block4: {
            block3: {
                block2: {
                    scala.collection.mutable.Map<String, Seq<Object>> map = ZkUtils$.MODULE$.getPartitionsForTopics(zkClient, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string2}))));
                    option = map.get((Object)string2);
                    if (!(option instanceof Some)) break block2;
                    ((IterableLike)((SeqLike)((Some)option).x()).sorted((Ordering)Ordering.Int$.MODULE$)).foreach((Function1)new Serializable(zkClient, string, string2){
                        public static final long serialVersionUID;
                        private final ZkClient zkClient$2;
                        private final String group$1;
                        private final String topic$2;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(int n) {
                            this.apply$mcVI$sp(n);
                        }

                        public void apply$mcVI$sp(int n) {
                            ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processPartition(this.zkClient$2, this.group$1, this.topic$2, n);
                        }
                        {
                            this.zkClient$2 = zkClient;
                            this.group$1 = string;
                            this.topic$2 = string2;
                        }
                    });
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private void printBrokerInfo() {
        Predef$.MODULE$.println((Object)"BROKER INFO");
        ((IterableLike)this.consumerMap().filter((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<Object, Option<SimpleConsumer>> tuple2) {
                Tuple2<Object, Option<SimpleConsumer>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Object, Option<SimpleConsumer>> tuple2) {
                Tuple2<Object, Option<SimpleConsumer>> tuple22;
                block2: {
                    Option option;
                    block5: {
                        block4: {
                            block3: {
                                SimpleConsumer simpleConsumer;
                                tuple22 = tuple2;
                                if (tuple22 == null) break block2;
                                Option option2 = (Option)tuple22._2();
                                Option option3 = option2;
                                option = option3;
                                if (!(option instanceof Some)) break block3;
                                Some some = (Some)option;
                                SimpleConsumer simpleConsumer2 = simpleConsumer = (SimpleConsumer)some.x();
                                Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%s -> %s:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tuple22._1(), simpleConsumer2.host(), BoxesRunTime.boxToInteger((int)simpleConsumer2.port())})));
                                break block4;
                            }
                            None$ none$ = None$.MODULE$;
                            Option option4 = option;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                        }
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple22);
            }
        });
    }

    public void main(String[] stringArray) {
        None$ none$;
        block8: {
            ObjectRef objectRef;
            block9: {
                OptionParser optionParser = new OptionParser();
                ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec = optionParser.accepts("zkconnect", "ZooKeeper connect string.").withRequiredArg().defaultsTo((Object)"localhost:2181", (Object[])new String[0]).ofType(String.class);
                ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec2 = optionParser.accepts("topic", "Comma-separated list of consumer topics (all topics if absent).").withRequiredArg().ofType(String.class);
                ArgumentAcceptingOptionSpec argumentAcceptingOptionSpec3 = optionParser.accepts("group", "Consumer group.").withRequiredArg().ofType(String.class);
                optionParser.accepts("broker-info", "Print broker info");
                optionParser.accepts("help", "Print this message.");
                OptionSet optionSet = optionParser.parse(stringArray);
                if (optionSet.has("help")) {
                    optionParser.printHelpOn((OutputStream)System.out);
                    System.exit(0);
                }
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{argumentAcceptingOptionSpec3})).foreach((Function1)new Serializable(optionParser, optionSet){
                    public static final long serialVersionUID;
                    private final OptionParser parser$1;
                    private final OptionSet options$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(ArgumentAcceptingOptionSpec<String> argumentAcceptingOptionSpec) {
                        if (!this.options$1.has(argumentAcceptingOptionSpec)) {
                            System.err.println(Predef$.MODULE$.augmentString("Missing required argument: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{argumentAcceptingOptionSpec})));
                            this.parser$1.printHelpOn((OutputStream)System.err);
                            System.exit(1);
                        }
                    }
                    {
                        this.parser$1 = optionParser;
                        this.options$1 = optionSet;
                    }
                });
                String string = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec);
                String string2 = (String)optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec3);
                None$ none$2 = optionSet.has((OptionSpec)argumentAcceptingOptionSpec2) ? new Some(optionSet.valueOf((OptionSpec)argumentAcceptingOptionSpec2)) : None$.MODULE$;
                objectRef = new ObjectRef(null);
                try {
                    List list;
                    objectRef.elem = new ZkClient(string, 30000, 30000, (ZkSerializer)ZKStringSerializer$.MODULE$);
                    none$ = none$2;
                    if (none$ instanceof Some) {
                        list = Predef$.MODULE$.refArrayOps((Object[])((String)((Some)none$).x()).split(",")).view().toList();
                    } else {
                        None$ none$3 = None$.MODULE$;
                        None$ none$4 = none$;
                        if (none$3 != null ? !none$3.equals(none$4) : none$4 != null) break block8;
                        list = ZkUtils$.MODULE$.getChildren((ZkClient)objectRef.elem, Predef$.MODULE$.augmentString("/consumers/%s/offsets").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string2}))).toList();
                    }
                    List list2 = list;
                    this.debug((Function0<String>)new Serializable(string, string2, list2){
                        public static final long serialVersionUID;
                        private final String zkConnect$1;
                        private final String group$2;
                        private final List topicList$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("zkConnect = %s; topics = %s; group = %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.zkConnect$1, this.topicList$1.toString(), this.group$2}));
                        }
                        {
                            this.zkConnect$1 = string;
                            this.group$2 = string2;
                            this.topicList$1 = list;
                        }
                    });
                    Predef$.MODULE$.println((Object)Predef$.MODULE$.augmentString("%-15s %-30s %-3s %-15s %-15s %-15s %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"Group", "Topic", "Pid", "Offset", "logSize", "Lag", "Owner"})));
                    ((LinearSeqOptimized)list2.sorted((Ordering)Ordering.String$.MODULE$)).foreach((Function1)new Serializable(string2, objectRef){
                        public static final long serialVersionUID;
                        private final String group$2;
                        private final ObjectRef zkClient$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(String string) {
                            ConsumerOffsetChecker$.MODULE$.kafka$tools$ConsumerOffsetChecker$$processTopic((ZkClient)this.zkClient$3.elem, this.group$2, string);
                        }
                        {
                            this.group$2 = string;
                            this.zkClient$3 = objectRef;
                        }
                    });
                    if (!optionSet.has("broker-info")) break block9;
                    this.printBrokerInfo();
                }
                catch (Throwable throwable) {
                    this.consumerMap().values().foreach((Function1)new Serializable(){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Option<SimpleConsumer> option) {
                            Option<SimpleConsumer> option2;
                            block4: {
                                block3: {
                                    block2: {
                                        option2 = option;
                                        if (!(option2 instanceof Some)) break block2;
                                        ((SimpleConsumer)((Some)option2).x()).close();
                                        break block3;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    Option<SimpleConsumer> option3 = option2;
                                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                                }
                                return;
                            }
                            throw new MatchError(option2);
                        }
                    });
                    if ((ZkClient)objectRef.elem != null) {
                        ((ZkClient)objectRef.elem).close();
                    }
                    throw throwable;
                }
            }
            this.consumerMap().values().foreach((Function1)new /* invalid duplicate definition of identical inner class */);
            if ((ZkClient)objectRef.elem != null) {
                ((ZkClient)objectRef.elem).close();
            }
            return;
        }
        throw new MatchError((Object)none$);
    }

    private ConsumerOffsetChecker$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.consumerMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

