/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.api.FetchRequest;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponse;
import kafka.api.FetchResponsePartitionData;
import kafka.api.PartitionFetchInfo;
import kafka.cluster.Broker;
import kafka.common.ClientIdAndBroker;
import kafka.common.ErrorMapping$;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.consumer.PartitionTopicInfo$;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.server.AbstractFetcherThread$;
import kafka.server.FetcherLagStats;
import kafka.server.FetcherStats;
import kafka.utils.ShutdownableThread;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.Growable;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015b!B\u0001\u0003\u0003\u00039!!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\r\u001a\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011!B;uS2\u001c\u0018BA\u0007\u000b\u0005I\u0019\u0006.\u001e;e_^t\u0017M\u00197f)\"\u0014X-\u00193\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\n+\u0001\u0011\t\u0011)A\u0005-u\tAA\\1nKB\u0011qC\u0007\b\u0003\u001faI!!\u0007\t\u0002\rA\u0013X\rZ3g\u0013\tYBD\u0001\u0004TiJLgn\u001a\u0006\u00033AI!!\u0006\u0007\t\u0011}\u0001!\u0011!Q\u0001\nY\t\u0001b\u00197jK:$\u0018\n\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1o\\;sG\u0016\u0014%o\\6feB\u00111EJ\u0007\u0002I)\u0011Q\u0005B\u0001\bG2,8\u000f^3s\u0013\t9CE\u0001\u0004Ce>\\WM\u001d\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005i1o\\2lKR$\u0016.\\3pkR\u0004\"aD\u0016\n\u00051\u0002\"aA%oi\"Aa\u0006\u0001B\u0001B\u0003%!&\u0001\tt_\u000e\\W\r\u001e\"vM\u001a,'oU5{K\"A\u0001\u0007\u0001B\u0001B\u0003%!&A\u0005gKR\u001c\u0007nU5{K\"A!\u0007\u0001B\u0001B\u0003%!&A\bgKR\u001c\u0007.\u001a:Ce>\\WM]%e\u0011!!\u0004A!A!\u0002\u0013Q\u0013aB7bq^\u000b\u0017\u000e\u001e\u0005\tm\u0001\u0011\t\u0011)A\u0005U\u0005AQ.\u001b8CsR,7\u000fC\u00059\u0001\t\u0005\t\u0015!\u0003:y\u0005y\u0011n]%oi\u0016\u0014(/\u001e9uS\ndW\r\u0005\u0002\u0010u%\u00111\b\u0005\u0002\b\u0005>|G.Z1o\u0013\tAD\u0002C\u0003?\u0001\u0011\u0005q(\u0001\u0004=S:LGO\u0010\u000b\f\u0001\n\u001bE)\u0012$H\u0011&S5\n\u0005\u0002B\u00015\t!\u0001C\u0003\u0016{\u0001\u0007a\u0003C\u0003 {\u0001\u0007a\u0003C\u0003\"{\u0001\u0007!\u0005C\u0003*{\u0001\u0007!\u0006C\u0003/{\u0001\u0007!\u0006C\u00031{\u0001\u0007!\u0006C\u00043{A\u0005\t\u0019\u0001\u0016\t\u000fQj\u0004\u0013!a\u0001U!9a'\u0010I\u0001\u0002\u0004Q\u0003b\u0002\u001d>!\u0003\u0005\r!\u000f\u0005\b\u001b\u0002\u0011\r\u0011\"\u0003O\u00031\u0001\u0018M\u001d;ji&|g.T1q+\u0005y\u0005\u0003\u0002)V/vk\u0011!\u0015\u0006\u0003%N\u000bq!\\;uC\ndWM\u0003\u0002U!\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005Y\u000b&a\u0002%bg\"l\u0015\r\u001d\t\u00031nk\u0011!\u0017\u0006\u00035\u0012\taaY8n[>t\u0017B\u0001/Z\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\t\u0003\u001fyK!a\u0018\t\u0003\t1{gn\u001a\u0005\u0007C\u0002\u0001\u000b\u0011B(\u0002\u001bA\f'\u000f^5uS>tW*\u00199!\u0011\u001d\u0019\u0007A1A\u0005\n\u0011\f\u0001\u0003]1si&$\u0018n\u001c8NCBdunY6\u0016\u0003\u0015\u0004\"AZ8\u000e\u0003\u001dT!\u0001[5\u0002\u000b1|7m[:\u000b\u0005)\\\u0017AC2p]\u000e,(O]3oi*\u0011A.\\\u0001\u0005kRLGNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A<'!\u0004*fK:$(/\u00198u\u0019>\u001c7\u000e\u0003\u0004s\u0001\u0001\u0006I!Z\u0001\u0012a\u0006\u0014H/\u001b;j_:l\u0015\r\u001d'pG.\u0004\u0003b\u0002;\u0001\u0005\u0004%I!^\u0001\u0011a\u0006\u0014H/\u001b;j_:l\u0015\r]\"p]\u0012,\u0012A\u001e\t\u0003M^L!\u0001_4\u0003\u0013\r{g\u000eZ5uS>t\u0007B\u0002>\u0001A\u0003%a/A\tqCJ$\u0018\u000e^5p]6\u000b\u0007oQ8oI\u0002Bq\u0001 \u0001C\u0002\u0013\u0005Q0\u0001\btS6\u0004H.Z\"p]N,X.\u001a:\u0016\u0003y\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0011\t\u0001bY8ogVlWM]\u0005\u0005\u0003\u000f\t\tA\u0001\bTS6\u0004H.Z\"p]N,X.\u001a:\t\u000f\u0005-\u0001\u0001)A\u0005}\u0006y1/[7qY\u0016\u001cuN\\:v[\u0016\u0014\b\u0005C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012\u0005Q!M]8lKJLeNZ8\u0016\u0003YAq!!\u0006\u0001A\u0003%a#A\u0006ce>\\WM]%oM>\u0004\u0003\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0003!iW\r\u001e:jG&#WCAA\u000f!\rA\u0016qD\u0005\u0004\u0003CI&!E\"mS\u0016tG/\u00133B]\u0012\u0014%o\\6fe\"A\u0011Q\u0005\u0001!\u0002\u0013\ti\"A\u0005nKR\u0014\u0018nY%eA!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u00111F\u0001\rM\u0016$8\r[3s'R\fGo]\u000b\u0003\u0003[\u00012!QA\u0018\u0013\r\t\tD\u0001\u0002\r\r\u0016$8\r[3s'R\fGo\u001d\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002.\u0005ia-\u001a;dQ\u0016\u00148\u000b^1ug\u0002B\u0011\"!\u000f\u0001\u0005\u0004%\t!a\u000f\u0002\u001f\u0019,Go\u00195fe2\u000bwm\u0015;biN,\"!!\u0010\u0011\u0007\u0005\u000by$C\u0002\u0002B\t\u0011qBR3uG\",'\u000fT1h'R\fGo\u001d\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002>\u0005\u0001b-\u001a;dQ\u0016\u0014H*Y4Ti\u0006$8\u000f\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0001\u0003\u0017\n1CZ3uG\"\u0014V-];fgR\u0014U/\u001b7eKJ,\"!!\u0014\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u0005\u0003\r\t\u0007/[\u0005\u0005\u0003/\n\tFA\nGKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA'\u0003Q1W\r^2i%\u0016\fX/Z:u\u0005VLG\u000eZ3sA!9\u0011q\f\u0001\u0007\u0002\u0005\u0005\u0014\u0001\u00069s_\u000e,7o\u001d)beRLG/[8o\t\u0006$\u0018\r\u0006\u0005\u0002d\u0005%\u0014QNA9!\ry\u0011QM\u0005\u0004\u0003O\u0002\"\u0001B+oSRDq!a\u001b\u0002^\u0001\u0007q+A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!a\u001c\u0002^\u0001\u0007Q,A\u0006gKR\u001c\u0007n\u00144gg\u0016$\b\u0002CA:\u0003;\u0002\r!!\u001e\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\ty%a\u001e\n\t\u0005e\u0014\u0011\u000b\u0002\u001b\r\u0016$8\r\u001b*fgB|gn]3QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\b\u0003{\u0002a\u0011AA@\u0003YA\u0017M\u001c3mK>3gm]3u\u001fV$xJ\u001a*b]\u001e,GcA/\u0002\u0002\"9\u00111NA>\u0001\u00049\u0006bBAC\u0001\u0019\u0005\u0011qQ\u0001\u001bQ\u0006tG\r\\3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'o\u001d\u000b\u0005\u0003G\nI\t\u0003\u0005\u0002\f\u0006\r\u0005\u0019AAG\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003\u001f\u000byj\u0016\b\u0005\u0003#\u000bYJ\u0004\u0003\u0002\u0014\u0006eUBAAK\u0015\r\t9JB\u0001\u0007yI|w\u000e\u001e \n\u0003EI1!!(\u0011\u0003\u001d\u0001\u0018mY6bO\u0016LA!!)\u0002$\nA\u0011\n^3sC\ndWMC\u0002\u0002\u001eBAq!a*\u0001\t\u0003\nI+\u0001\u0005tQV$Hm\\<o)\t\t\u0019\u0007C\u0004\u0002.\u0002!\t%!+\u0002\r\u0011|wk\u001c:l\u0011\u001d\t\t\f\u0001C\u0005\u0003g\u000b1\u0003\u001d:pG\u0016\u001c8OR3uG\"\u0014V-];fgR$B!a\u0019\u00026\"A\u0011qWAX\u0001\u0004\tI,\u0001\u0007gKR\u001c\u0007NU3rk\u0016\u001cH\u000f\u0005\u0003\u0002P\u0005m\u0016\u0002BA_\u0003#\u0012ABR3uG\"\u0014V-];fgRDq!!1\u0001\t\u0003\t\u0019-\u0001\u0007bI\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u0002d\u0005\u0015\u0017\u0011ZAg\u0011\u001d\t9-a0A\u0002Y\tQ\u0001^8qS\u000eDq!a3\u0002@\u0002\u0007!&A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBAh\u0003\u007f\u0003\r!X\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\t\u000f\u0005M\u0007\u0001\"\u0001\u0002V\u0006y!/Z7pm\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0004\u0002d\u0005]\u0017\u0011\u001c\u0005\b\u0003\u000f\f\t\u000e1\u0001\u0017\u0011\u001d\tY-!5A\u0002)Bq!!8\u0001\t\u0003\ty.\u0001\bqCJ$\u0018\u000e^5p]\u000e{WO\u001c;\u0015\u0003):\u0011\"a9\u0003\u0003\u0003E)!!:\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bIB\u0019\u0011)a:\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u0003S\u001cR!a:\u0002l:\u0001B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0004\u0003cl\u0017\u0001\u00027b]\u001eLA!!>\u0002p\n1qJ\u00196fGRDqAPAt\t\u0003\tI\u0010\u0006\u0002\u0002f\"Q\u0011Q`At#\u0003%\t!a@\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!\u0011\u0001\u0016\u0004U\t\r1F\u0001B\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=\u0001#\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\t]\u0011q]I\u0001\n\u0003\ty0\u0001\bj]&$H\u0005Z3gCVdG\u000f\n\u001d\t\u0015\tm\u0011q]I\u0001\n\u0003\ty0\u0001\bj]&$H\u0005Z3gCVdG\u000fJ\u001d\t\u0015\t}\u0011q]I\u0001\n\u0003\u0011\t#A\bj]&$H\u0005Z3gCVdG\u000fJ\u00191+\t\u0011\u0019CK\u0002:\u0005\u0007\u0001")
public abstract class AbstractFetcherThread
extends ShutdownableThread
implements ScalaObject {
    public final Broker kafka$server$AbstractFetcherThread$$sourceBroker;
    public final int kafka$server$AbstractFetcherThread$$fetchSize;
    private final HashMap<TopicAndPartition, Object> kafka$server$AbstractFetcherThread$$partitionMap;
    private final ReentrantLock partitionMapLock;
    private final Condition partitionMapCond;
    private final SimpleConsumer simpleConsumer;
    private final String brokerInfo;
    private final ClientIdAndBroker metricId;
    private final FetcherStats fetcherStats;
    private final FetcherLagStats fetcherLagStats;
    private final FetchRequestBuilder fetchRequestBuilder;

    public static final boolean init$default$10() {
        return AbstractFetcherThread$.MODULE$.init$default$10();
    }

    public static final int init$default$9() {
        return AbstractFetcherThread$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return AbstractFetcherThread$.MODULE$.init$default$8();
    }

    public static final int init$default$7() {
        return AbstractFetcherThread$.MODULE$.init$default$7();
    }

    public final HashMap<TopicAndPartition, Object> kafka$server$AbstractFetcherThread$$partitionMap() {
        return this.kafka$server$AbstractFetcherThread$$partitionMap;
    }

    private ReentrantLock partitionMapLock() {
        return this.partitionMapLock;
    }

    private Condition partitionMapCond() {
        return this.partitionMapCond;
    }

    public SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    private String brokerInfo() {
        return this.brokerInfo;
    }

    private ClientIdAndBroker metricId() {
        return this.metricId;
    }

    public FetcherStats fetcherStats() {
        return this.fetcherStats;
    }

    public FetcherLagStats fetcherLagStats() {
        return this.fetcherLagStats;
    }

    public FetchRequestBuilder fetchRequestBuilder() {
        return this.fetchRequestBuilder;
    }

    public abstract void processPartitionData(TopicAndPartition var1, long var2, FetchResponsePartitionData var4);

    public abstract long handleOffsetOutOfRange(TopicAndPartition var1);

    public abstract void handlePartitionsWithErrors(Iterable<TopicAndPartition> var1);

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    @Override
    public void doWork() {
        this.partitionMapLock().lock();
        Object object = this.kafka$server$AbstractFetcherThread$$partitionMap().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)this.partitionMapCond().await(200L, TimeUnit.MILLISECONDS)) : BoxedUnit.UNIT;
        this.kafka$server$AbstractFetcherThread$$partitionMap().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final AbstractFetcherThread $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final FetchRequestBuilder apply(Tuple2<TopicAndPartition, Object> tuple2) {
                Tuple2<TopicAndPartition, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    TopicAndPartition topicAndPartition;
                    TopicAndPartition topicAndPartition2 = topicAndPartition = (TopicAndPartition)tuple22._1();
                    return this.$outer.fetchRequestBuilder().addFetch(topicAndPartition2.topic(), topicAndPartition2.partition(), BoxesRunTime.unboxToLong((Object)tuple22._2()), this.$outer.kafka$server$AbstractFetcherThread$$fetchSize);
                }
                throw new MatchError(tuple22);
            }
            {
                if (abstractFetcherThread == null) {
                    throw new NullPointerException();
                }
                this.$outer = abstractFetcherThread;
            }
        });
        FetchRequest fetchRequest = this.fetchRequestBuilder().build();
        if (!fetchRequest.requestInfo().isEmpty()) {
            this.processFetchRequest(fetchRequest);
        }
        return;
        finally {
            this.partitionMapLock().unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFetchRequest(FetchRequest fetchRequest) {
        HashSet hashSet = new HashSet();
        FetchResponse fetchResponse = null;
        BoxedUnit boxedUnit = null;
        try {
            this.trace((Function0<String>)new Serializable(this, fetchRequest){
                public static final long serialVersionUID;
                private final AbstractFetcherThread $outer;
                private final FetchRequest fetchRequest$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("issuing to broker %d of fetch request %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$AbstractFetcherThread$$sourceBroker.id()), this.fetchRequest$1}));
                }
                {
                    if (abstractFetcherThread == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = abstractFetcherThread;
                    this.fetchRequest$1 = fetchRequest;
                }
            });
            fetchResponse = this.simpleConsumer().fetch(fetchRequest);
            boxedUnit = BoxedUnit.UNIT;
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit2;
            this.warn((Function0<String>)new Serializable(this, fetchRequest){
                public static final long serialVersionUID;
                private final FetchRequest fetchRequest$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Error in fetch %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fetchRequest$1}));
                }
                {
                    this.fetchRequest$1 = fetchRequest;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable t$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = throwable;
                }
            });
            if (this.isRunning().get()) {
                ReentrantLock reentrantLock = this.partitionMapLock();
                synchronized (reentrantLock) {
                    Growable growable = hashSet.$plus$plus$eq((TraversableOnce)this.kafka$server$AbstractFetcherThread$$partitionMap().keys());
                    // MONITOREXIT @DISABLED, blocks:[1, 3, 4, 11] lbl17 : MonitorExitStatement: MONITOREXIT : var6_6
                    boxedUnit2 = growable;
                }
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            boxedUnit = boxedUnit2;
        }
        this.fetcherStats().requestRate().mark();
        if (fetchResponse != null) {
            this.partitionMapLock().lock();
            fetchResponse.data().foreach((Function1)new Serializable(this, fetchRequest, hashSet){
                public static final long serialVersionUID;
                private final AbstractFetcherThread $outer;
                private final FetchRequest fetchRequest$1;
                private final HashSet partitionsWithError$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Loose catch block
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2) {
                    BoxedUnit boxedUnit;
                    HashSet hashSet;
                    BoxedUnit boxedUnit2;
                    Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple22 = tuple2;
                    if (tuple22 == null) throw new MatchError(tuple22);
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                    FetchResponsePartitionData fetchResponsePartitionData = (FetchResponsePartitionData)tuple22._2();
                    TopicAndPartition topicAndPartition2 = topicAndPartition;
                    FetchResponsePartitionData fetchResponsePartitionData2 = fetchResponsePartitionData;
                    Tuple2<String, Object> tuple23 = topicAndPartition2.asTuple();
                    if (tuple23 == null) throw new MatchError(tuple23);
                    Tuple2 tuple24 = new Tuple2(tuple23._1(), tuple23._2());
                    String string = (String)tuple24._1();
                    int n = tuple24._2$mcI$sp();
                    Option option = this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().get((Object)topicAndPartition2);
                    if (option.isDefined() && ((PartitionFetchInfo)this.fetchRequest$1.requestInfo().apply((Object)topicAndPartition2)).offset() == BoxesRunTime.unboxToLong((Object)option.get())) {
                        short s = fetchResponsePartitionData2.error();
                        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()), (Object)BoxesRunTime.boxToShort((short)s))) {
                            long l;
                            boxedUnit2 = null;
                            ByteBufferMessageSet byteBufferMessageSet = (ByteBufferMessageSet)fetchResponsePartitionData2.messages();
                            int n2 = byteBufferMessageSet.validBytes();
                            Option option2 = byteBufferMessageSet.shallowIterator().toSeq().lastOption();
                            if (option2 instanceof Some) {
                                Some some = (Some)option2;
                                MessageAndOffset messageAndOffset = (MessageAndOffset)some.x();
                                if (messageAndOffset == null) throw new MatchError((Object)option2);
                                l = messageAndOffset.nextOffset();
                            } else {
                                None$ none$ = None$.MODULE$;
                                Option option3 = option2;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) throw new MatchError((Object)option2);
                                l = BoxesRunTime.unboxToLong((Object)option.get());
                            }
                            long l2 = l;
                            this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().put((Object)topicAndPartition2, (Object)BoxesRunTime.boxToLong((long)l2));
                            this.$outer.fetcherLagStats().getFetcherLagStats(string, n).lag_$eq(fetchResponsePartitionData2.hw() - l2);
                            this.$outer.fetcherStats().byteRate().mark((long)n2);
                            this.$outer.processPartitionData(topicAndPartition2, BoxesRunTime.unboxToLong((Object)option.get()), fetchResponsePartitionData2);
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.OffsetOutOfRangeCode()), (Object)BoxesRunTime.boxToShort((short)s))) {
                            hashSet = null;
                            long l = this.$outer.handleOffsetOutOfRange(topicAndPartition2);
                            this.$outer.kafka$server$AbstractFetcherThread$$partitionMap().put((Object)topicAndPartition2, (Object)BoxesRunTime.boxToLong((long)l));
                            this.$outer.warn((Function0<String>)new Serializable(this, string, n, option, l){
                                public static final long serialVersionUID;
                                private final String topic$2;
                                private final int partitionId$2;
                                private final Option currentOffset$1;
                                private final long newOffset$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("current offset %d for partition [%s,%d] out of range; reset offset to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentOffset$1.get(), this.topic$2, BoxesRunTime.boxToInteger((int)this.partitionId$2), BoxesRunTime.boxToLong((long)this.newOffset$1)}));
                                }
                                {
                                    this.topic$2 = string;
                                    this.partitionId$2 = n;
                                    this.currentOffset$1 = option;
                                    this.newOffset$1 = l;
                                }
                            });
                            hashSet = BoxedUnit.UNIT;
                        }
                        if (this.$outer.isRunning().get()) {
                            this.$outer.warn((Function0<String>)new Serializable(this, string, n){
                                public static final long serialVersionUID;
                                private final $anonfun$processFetchRequest$4 $outer;
                                private final String topic$2;
                                private final int partitionId$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("error for partition [%s,%d] to broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, BoxesRunTime.boxToInteger((int)this.partitionId$2), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$sourceBroker.id())}));
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.topic$2 = string;
                                    this.partitionId$2 = n;
                                }
                            }, (Function0<Throwable>)new Serializable(this, fetchResponsePartitionData2){
                                public static final long serialVersionUID;
                                private final FetchResponsePartitionData partitionData$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return ErrorMapping$.MODULE$.exceptionFor(this.partitionData$1.error());
                                }
                                {
                                    this.partitionData$1 = fetchResponsePartitionData;
                                }
                            });
                            boxedUnit = this.partitionsWithError$1.$plus$eq((Object)topicAndPartition2);
                            return boxedUnit;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                    catch (Throwable throwable) {
                        throw new KafkaException(Predef$.MODULE$.augmentString("error processing data for partition [%s,%d] offset %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), option.get()})), throwable);
                    }
                    catch (InvalidMessageException invalidMessageException) {
                        this.$outer.logger().warn((Object)new StringBuilder().append((Object)"Found invalid messages during fetch for partition [").append((Object)string).append((Object)",").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)"] offset ").append(option.get()).append((Object)" error ").append((Object)invalidMessageException.getMessage()).toString());
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    return boxedUnit;
                    catch (Throwable throwable) {
                        this.$outer.warn((Function0<String>)new Serializable(this, string, n){
                            public static final long serialVersionUID;
                            private final $anonfun$processFetchRequest$4 $outer;
                            private final String topic$2;
                            private final int partitionId$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("error getting offset for partition [%s,%d] to broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2, BoxesRunTime.boxToInteger((int)this.partitionId$2), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$AbstractFetcherThread$$anonfun$$$outer().kafka$server$AbstractFetcherThread$$sourceBroker.id())}));
                            }
                            {
                                if (var1_1 == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = var1_1;
                                this.topic$2 = string;
                                this.partitionId$2 = n;
                            }
                        }, (Function0<Throwable>)new Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.e$1;
                            }
                            {
                                this.e$1 = throwable;
                            }
                        });
                        hashSet = this.partitionsWithError$1.$plus$eq((Object)topicAndPartition2);
                    }
                    boxedUnit = hashSet;
                    return boxedUnit;
                }

                public AbstractFetcherThread kafka$server$AbstractFetcherThread$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if (abstractFetcherThread == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = abstractFetcherThread;
                    this.fetchRequest$1 = fetchRequest;
                    this.partitionsWithError$1 = hashSet;
                }
            });
        }
        if (hashSet.size() > 0) {
            this.debug((Function0<String>)new Serializable(this, hashSet){
                public static final long serialVersionUID;
                private final HashSet partitionsWithError$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("handling partitions with error for %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionsWithError$1}));
                }
                {
                    this.partitionsWithError$1 = hashSet;
                }
            });
            this.handlePartitionsWithErrors((Iterable<TopicAndPartition>)hashSet);
        }
        return;
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void addPartition(String string, int n, long l) {
        this.partitionMapLock().lockInterruptibly();
        try {
            TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
            this.kafka$server$AbstractFetcherThread$$partitionMap().put((Object)topicAndPartition, (Object)(PartitionTopicInfo$.MODULE$.isOffsetInvalid(l) ? BoxesRunTime.boxToLong((long)this.handleOffsetOutOfRange(topicAndPartition)) : BoxesRunTime.boxToLong((long)l)));
            this.partitionMapCond().signalAll();
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public void removePartition(String string, int n) {
        this.partitionMapLock().lockInterruptibly();
        try {
            this.kafka$server$AbstractFetcherThread$$partitionMap().remove((Object)new TopicAndPartition(string, n));
            return;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public int partitionCount() {
        this.partitionMapLock().lockInterruptibly();
        int n = 0;
        try {
            n = this.kafka$server$AbstractFetcherThread$$partitionMap().size();
            return n;
        }
        finally {
            this.partitionMapLock().unlock();
        }
    }

    public AbstractFetcherThread(String string, String string2, Broker broker, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.kafka$server$AbstractFetcherThread$$sourceBroker = broker;
        this.kafka$server$AbstractFetcherThread$$fetchSize = n3;
        super(string, bl);
        this.kafka$server$AbstractFetcherThread$$partitionMap = new HashMap();
        this.partitionMapLock = new ReentrantLock();
        this.partitionMapCond = this.partitionMapLock().newCondition();
        this.simpleConsumer = new SimpleConsumer(broker.host(), broker.port(), n, n2, string2);
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{broker.host(), BoxesRunTime.boxToInteger((int)broker.port())}));
        this.metricId = new ClientIdAndBroker(string2, this.brokerInfo());
        this.fetcherStats = new FetcherStats(this.metricId());
        this.fetcherLagStats = new FetcherLagStats(this.metricId());
        this.fetchRequestBuilder = new FetchRequestBuilder().clientId(string2).replicaId(n4).maxWait(n5).minBytes(n6);
    }
}

