/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer.async;

import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.api.TopicMetadata;
import kafka.common.ErrorMapping$;
import kafka.common.FailedToSendMessageException;
import kafka.common.KafkaException;
import kafka.common.LeaderNotAvailableException;
import kafka.common.NoBrokersForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.common.UnknownTopicOrPartitionException;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.BrokerPartitionInfo;
import kafka.producer.KeyedMessage;
import kafka.producer.PartitionAndLeader;
import kafka.producer.Partitioner;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.ProducerStats;
import kafka.producer.ProducerStatsRegistry$;
import kafka.producer.ProducerTopicStats;
import kafka.producer.ProducerTopicStatsRegistry$;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler$;
import kafka.producer.async.DefaultEventHandler$$anonfun$dispatchSerializedData$2$;
import kafka.producer.async.DefaultEventHandler$$anonfun$kafka$producer$async$DefaultEventHandler$;
import kafka.producer.async.EventHandler;
import kafka.serializer.Encoder;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0005e\u0001B\u0001\u0003\u0001%\u00111\u0003R3gCVdG/\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000b\u0005\u001c\u0018P\\2\u000b\u0005\u00151\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001!F\u0002\u000b3\u0019\u001aR\u0001A\u0006\u0014Q9\u0002\"\u0001D\t\u000e\u00035Q!AD\b\u0002\t1\fgn\u001a\u0006\u0002!\u0005!!.\u0019<b\u0013\t\u0011RB\u0001\u0004PE*,7\r\u001e\t\u0005)U9R%D\u0001\u0003\u0013\t1\"A\u0001\u0007Fm\u0016tG\u000fS1oI2,'\u000f\u0005\u0002\u001931\u0001A!\u0002\u000e\u0001\u0005\u0004Y\"!A&\u0012\u0005q\u0011\u0003CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002(pi\"Lgn\u001a\t\u0003;\rJ!\u0001\n\u0010\u0003\u0007\u0005s\u0017\u0010\u0005\u0002\u0019M\u0011)q\u0005\u0001b\u00017\t\ta\u000b\u0005\u0002*Y5\t!F\u0003\u0002,\r\u0005)Q\u000f^5mg&\u0011QF\u000b\u0002\b\u0019><w-\u001b8h!\tir&\u0003\u00021=\tY1kY1mC>\u0013'.Z2u\u0011!\u0011\u0004A!A!\u0002\u0013\u0019\u0014AB2p]\u001aLw\r\u0005\u00025k5\tA!\u0003\u00027\t\tq\u0001K]8ek\u000e,'oQ8oM&<\u0007\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011B\u001d\u0002\u0017A\f'\u000f^5uS>tWM]\u000b\u0002uA\u0019AgO\f\n\u0005q\"!a\u0003)beRLG/[8oKJD\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IAO\u0001\ra\u0006\u0014H/\u001b;j_:,'\u000f\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0005\u0003\u00069QM\\2pI\u0016\u0014X#\u0001\"\u0011\u0007\r3U%D\u0001E\u0015\t)e!\u0001\u0006tKJL\u0017\r\\5{KJL!a\u0012#\u0003\u000f\u0015s7m\u001c3fe\"A\u0011\n\u0001B\u0001B\u0003%!)\u0001\u0005f]\u000e|G-\u001a:!\u0011!Y\u0005A!b\u0001\n\u0013a\u0015AC6fs\u0016s7m\u001c3feV\tQ\nE\u0002D\r^A\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I!T\u0001\fW\u0016LXI\\2pI\u0016\u0014\b\u0005\u0003\u0005R\u0001\t\u0015\r\u0011\"\u0003S\u00031\u0001(o\u001c3vG\u0016\u0014\bk\\8m+\u0005\u0019\u0006C\u0001\u001bU\u0013\t)FA\u0001\u0007Qe>$WoY3s!>|G\u000e\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003T\u00035\u0001(o\u001c3vG\u0016\u0014\bk\\8mA!A\u0011\f\u0001BC\u0002\u0013%!,A\nu_BL7\rU1si&$\u0018n\u001c8J]\u001a|7/F\u0001\\!\u0011a\u0016m\u00196\u000e\u0003uS!AX0\u0002\u000f5,H/\u00192mK*\u0011\u0001MH\u0001\u000bG>dG.Z2uS>t\u0017B\u00012^\u0005\u001dA\u0015m\u001d5NCB\u0004\"\u0001Z4\u000f\u0005u)\u0017B\u00014\u001f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001.\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019t\u0002CA6o\u001b\u0005a'BA7\u0007\u0003\r\t\u0007/[\u0005\u0003_2\u0014Q\u0002V8qS\u000elU\r^1eCR\f\u0007\u0002C9\u0001\u0005\u0003\u0005\u000b\u0011B.\u0002)Q|\u0007/[2QCJ$\u0018\u000e^5p]&sgm\\:!\u0011\u0015\u0019\b\u0001\"\u0001u\u0003\u0019a\u0014N\\5u}Q9QO^<ysj\\\b\u0003\u0002\u000b\u0001/\u0015BQA\r:A\u0002MBQ\u0001\u000f:A\u0002iBQ\u0001\u0011:A\u0002\tCQa\u0013:A\u00025CQ!\u0015:A\u0002MCq!\u0017:\u0011\u0002\u0003\u00071\fC\u0004~\u0001\t\u0007I\u0011\u0001@\u0002\r%\u001c8+\u001f8d+\u0005y\bcA\u000f\u0002\u0002%\u0019\u00111\u0001\u0010\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0001\u0001!\u0002\u0013y\u0018aB5t'ft7\r\t\u0005\n\u0003\u0017\u0001!\u0019!C\u0001\u0003\u001b\t\u0001\u0003]1si&$\u0018n\u001c8D_VtG/\u001a:\u0016\u0005\u0005=\u0001\u0003BA\t\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007CR|W.[2\u000b\t\u0005e\u00111D\u0001\u000bG>t7-\u001e:sK:$(bAA\u000f\u001f\u0005!Q\u000f^5m\u0013\u0011\t\t#a\u0005\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0011!\t)\u0003\u0001Q\u0001\n\u0005=\u0011!\u00059beRLG/[8o\u0007>,h\u000e^3sA!I\u0011\u0011\u0006\u0001C\u0002\u0013\u0005\u0011QB\u0001\u000eG>\u0014(/\u001a7bi&|g.\u00133\t\u0011\u00055\u0002\u0001)A\u0005\u0003\u001f\tabY8se\u0016d\u0017\r^5p]&#\u0007\u0005C\u0005\u00022\u0001\u0011\r\u0011\"\u0001\u00024\u0005\u0019\"M]8lKJ\u0004\u0016M\u001d;ji&|g.\u00138g_V\u0011\u0011Q\u0007\t\u0004i\u0005]\u0012bAA\u001d\t\t\u0019\"I]8lKJ\u0004\u0016M\u001d;ji&|g.\u00138g_\"A\u0011Q\b\u0001!\u0002\u0013\t)$\u0001\u000bce>\\WM\u001d)beRLG/[8o\u0013:4w\u000e\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007\nA\u0001\\8dWV\t1\u0002C\u0004\u0002H\u0001\u0001\u000b\u0011B\u0006\u0002\u000b1|7m\u001b\u0011\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0013\u0001\b;pa&\u001cW*\u001a;bI\u0006$\u0018MU3ge\u0016\u001c\b.\u00138uKJ4\u0018\r\\\u000b\u0003\u0003\u001f\u00022!HA)\u0013\r\t\u0019F\b\u0002\u0004\u0013:$\b\u0002CA,\u0001\u0001\u0006I!a\u0014\u0002;Q|\u0007/[2NKR\fG-\u0019;b%\u00164'/Z:i\u0013:$XM\u001d<bY\u0002B\u0011\"a\u0017\u0001\u0001\u0004%I!!\u0018\u000291\f7\u000f\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018MU3ge\u0016\u001c\b\u000eV5nKV\u0011\u0011q\f\t\u0004;\u0005\u0005\u0014bAA2=\t!Aj\u001c8h\u0011%\t9\u0007\u0001a\u0001\n\u0013\tI'\u0001\u0011mCN$Hk\u001c9jG6+G/\u00193bi\u0006\u0014VM\u001a:fg\"$\u0016.\\3`I\u0015\fH\u0003BA6\u0003c\u00022!HA7\u0013\r\tyG\b\u0002\u0005+:LG\u000f\u0003\u0006\u0002t\u0005\u0015\u0014\u0011!a\u0001\u0003?\n1\u0001\u001f\u00132\u0011!\t9\b\u0001Q!\n\u0005}\u0013!\b7bgR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+gM]3tQRKW.\u001a\u0011\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0014A\u0006;pa&\u001cW*\u001a;bI\u0006$\u0018\rV8SK\u001a\u0014Xm\u001d5\u0016\u0005\u0005}\u0004\u0003\u0002/\u0002\u0002\u000eL1!a!^\u0005\r\u0019V\r\u001e\u0005\t\u0003\u000f\u0003\u0001\u0015!\u0003\u0002\u0000\u00059Bo\u001c9jG6+G/\u00193bi\u0006$vNU3ge\u0016\u001c\b\u000e\t\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u001b\u000bQ\u0002\u001d:pIV\u001cWM]*uCR\u001cXCAAH!\r!\u0014\u0011S\u0005\u0004\u0003'#!!\u0004)s_\u0012,8-\u001a:Ti\u0006$8\u000f\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BAH\u00039\u0001(o\u001c3vG\u0016\u00148\u000b^1ug\u0002B\u0011\"a'\u0001\u0005\u0004%I!!(\u0002%A\u0014x\u000eZ;dKJ$v\u000e]5d'R\fGo]\u000b\u0003\u0003?\u00032\u0001NAQ\u0013\r\t\u0019\u000b\u0002\u0002\u0013!J|G-^2feR{\u0007/[2Ti\u0006$8\u000f\u0003\u0005\u0002(\u0002\u0001\u000b\u0011BAP\u0003M\u0001(o\u001c3vG\u0016\u0014Hk\u001c9jGN#\u0018\r^:!\u0011\u001d\tY\u000b\u0001C\u0001\u0003[\u000ba\u0001[1oI2,G\u0003BA6\u0003_C\u0001\"!-\u0002*\u0002\u0007\u00111W\u0001\u0007KZ,g\u000e^:\u0011\r\u0005U\u0016qWA^\u001b\u0005y\u0016bAA]?\n\u00191+Z9\u0011\u000bQ\nilF\u0013\n\u0007\u0005}FA\u0001\u0007LKf,G-T3tg\u0006<W\rC\u0004\u0002D\u0002!I!!2\u0002-\u0011L7\u000f]1uG\"\u001cVM]5bY&TX\r\u001a#bi\u0006$B!a2\u0002XB1\u0011QWA\\\u0003\u0013\u0004b\u0001NA_/\u0005-\u0007\u0003BAg\u0003'l!!a4\u000b\u0007\u0005Eg!A\u0004nKN\u001c\u0018mZ3\n\t\u0005U\u0017q\u001a\u0002\b\u001b\u0016\u001c8/Y4f\u0011!\tI.!1A\u0002\u0005\u001d\u0017\u0001C7fgN\fw-Z:\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006I1/\u001a:jC2L'0\u001a\u000b\u0005\u0003\u000f\f\t\u000f\u0003\u0005\u00022\u0006m\u0007\u0019AAZ\u0011\u001d\t)\u000f\u0001C\u0001\u0003O\f1\u0003]1si&$\u0018n\u001c8B]\u0012\u001cu\u000e\u001c7bi\u0016$B!!;\u0003\u0006A)Q$a;\u0002p&\u0019\u0011Q\u001e\u0010\u0003\r=\u0003H/[8o!!\t),!=\u0002P\u0005U\u0018bAAz?\n\u0019Q*\u00199\u0011\u000fq\u000b90!?\u0002H&\u0019\u00111_/\u0011\t\u0005m(\u0011A\u0007\u0003\u0003{T1!a@\u0007\u0003\u0019\u0019w.\\7p]&!!1AA\u007f\u0005E!v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\t\u00033\f\u0019\u000f1\u0001\u0002H\"9!\u0011\u0002\u0001\u0005\n\t-\u0011\u0001G4fiB\u000b'\u000f^5uS>tG*[:u\r>\u0014Hk\u001c9jGR!!Q\u0002B\u000b!\u0019\t),a.\u0003\u0010A\u0019AG!\u0005\n\u0007\tMAA\u0001\nQCJ$\u0018\u000e^5p]\u0006sG\rT3bI\u0016\u0014\b\u0002\u0003B\f\u0005\u000f\u0001\r!!3\u0002\u00035DqAa\u0007\u0001\t\u0013\u0011i\"\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0005\u0002P\t}!1\u0005B\u0014\u0011\u001d\u0011\tC!\u0007A\u0002\r\fQ\u0001^8qS\u000eDqA!\n\u0003\u001a\u0001\u0007q#A\u0002lKfD\u0001B!\u000b\u0003\u001a\u0001\u0007!QB\u0001\u0013i>\u0004\u0018n\u0019)beRLG/[8o\u0019&\u001cH\u000fC\u0004\u0003.\u0001!IAa\f\u0002\tM,g\u000e\u001a\u000b\u0007\u0005c\u0011\u0019Da\u000e\u0011\r\u0005U\u0016qWA}\u0011!\u0011)Da\u000bA\u0002\u0005=\u0013\u0001\u00032s_.,'/\u00133\t\u0011\te\"1\u0006a\u0001\u0005w\t\u0001#\\3tg\u0006<Wm\u001d)feR{\u0007/[2\u0011\u000fq\u000b90!?\u0003>A!\u0011Q\u001aB \u0013\u0011\u0011\t%a4\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000f\n!c\u001a:pkBlUm]:bO\u0016\u001cHk\\*fiR!!1\bB%\u0011!\u0011YEa\u0011A\u0002\u0005U\u0018\u0001H7fgN\fw-Z:QKJ$v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\u001c\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0003\u0015\u0019Gn\\:f)\t\tYgB\u0005\u0003V\t\t\t\u0011#\u0002\u0003X\u0005\u0019B)\u001a4bk2$XI^3oi\"\u000bg\u000e\u001a7feB\u0019AC!\u0017\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u00057\u001aBA!\u0017\f]!91O!\u0017\u0005\u0002\t}CC\u0001B,\u0011)\u0011\u0019G!\u0017\u0012\u0002\u0013\u0005!QM\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0019\u00119G! \u0003\u0000U\u0011!\u0011\u000e\u0016\u00047\n-4F\u0001B7!\u0011\u0011yG!\u001f\u000e\u0005\tE$\u0002\u0002B:\u0005k\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t]d$\u0001\u0006b]:|G/\u0019;j_:LAAa\u001f\u0003r\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\ri\u0011\tG1\u0001\u001c\t\u00199#\u0011\rb\u00017\u0001")
public class DefaultEventHandler<K, V>
implements EventHandler<K, V>,
Logging,
ScalaObject {
    public final ProducerConfig kafka$producer$async$DefaultEventHandler$$config;
    private final Partitioner<K> partitioner;
    private final Encoder<V> kafka$producer$async$DefaultEventHandler$$encoder;
    private final Encoder<K> kafka$producer$async$DefaultEventHandler$$keyEncoder;
    private final ProducerPool producerPool;
    private final HashMap<String, TopicMetadata> topicPartitionInfos;
    private final boolean isSync;
    private final AtomicInteger partitionCounter;
    private final AtomicInteger correlationId;
    private final BrokerPartitionInfo brokerPartitionInfo;
    private final Object lock;
    private final int topicMetadataRefreshInterval;
    private long lastTopicMetadataRefreshTime;
    private final Set<String> kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh;
    private final ProducerStats kafka$producer$async$DefaultEventHandler$$producerStats;
    private final ProducerTopicStats kafka$producer$async$DefaultEventHandler$$producerTopicStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final HashMap init$default$6() {
        return DefaultEventHandler$.MODULE$.init$default$6();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        DefaultEventHandler defaultEventHandler = this;
        synchronized (defaultEventHandler) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    private Partitioner<K> partitioner() {
        return this.partitioner;
    }

    public final Encoder<V> kafka$producer$async$DefaultEventHandler$$encoder() {
        return this.kafka$producer$async$DefaultEventHandler$$encoder;
    }

    public final Encoder<K> kafka$producer$async$DefaultEventHandler$$keyEncoder() {
        return this.kafka$producer$async$DefaultEventHandler$$keyEncoder;
    }

    private ProducerPool producerPool() {
        return this.producerPool;
    }

    private HashMap<String, TopicMetadata> topicPartitionInfos() {
        return this.topicPartitionInfos;
    }

    public boolean isSync() {
        return this.isSync;
    }

    public AtomicInteger partitionCounter() {
        return this.partitionCounter;
    }

    public AtomicInteger correlationId() {
        return this.correlationId;
    }

    public BrokerPartitionInfo brokerPartitionInfo() {
        return this.brokerPartitionInfo;
    }

    private Object lock() {
        return this.lock;
    }

    private int topicMetadataRefreshInterval() {
        return this.topicMetadataRefreshInterval;
    }

    private long lastTopicMetadataRefreshTime() {
        return this.lastTopicMetadataRefreshTime;
    }

    private void lastTopicMetadataRefreshTime_$eq(long l) {
        this.lastTopicMetadataRefreshTime = l;
    }

    public final Set<String> kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh() {
        return this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh;
    }

    public final ProducerStats kafka$producer$async$DefaultEventHandler$$producerStats() {
        return this.kafka$producer$async$DefaultEventHandler$$producerStats;
    }

    public final ProducerTopicStats kafka$producer$async$DefaultEventHandler$$producerTopicStats() {
        return this.kafka$producer$async$DefaultEventHandler$$producerTopicStats;
    }

    @Override
    public void handle(Seq<KeyedMessage<K, V>> seq) {
        Object object = this.lock();
        synchronized (object) {
            Seq<KeyedMessage<K, Message>> seq2 = this.serialize(seq);
            seq2.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final DefaultEventHandler $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(KeyedMessage<K, Message> keyedMessage) {
                    int n = keyedMessage.message().payloadSize();
                    this.$outer.kafka$producer$async$DefaultEventHandler$$producerTopicStats().getProducerTopicStats(keyedMessage.topic()).byteRate().mark((long)n);
                    this.$outer.kafka$producer$async$DefaultEventHandler$$producerTopicStats().getProducerAllTopicsStats().byteRate().mark((long)n);
                }
                {
                    if (defaultEventHandler == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = defaultEventHandler;
                }
            });
            ObjectRef objectRef = new ObjectRef(seq2);
            IntRef intRef = new IntRef(this.kafka$producer$async$DefaultEventHandler$$config.messageSendMaxRetries() + 1);
            int n = this.correlationId().get();
            this.debug((Function0<String>)new Serializable(this, seq){
                public static final long serialVersionUID;
                private final Seq events$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Handling %d events").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.events$1.size())}));
                }
                {
                    this.events$1 = defaultEventHandler;
                }
            });
            while (intRef.elem > 0 && ((Seq)objectRef.elem).size() > 0) {
                this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().$plus$plus$eq((TraversableOnce)((Seq)objectRef.elem).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply(KeyedMessage<K, Message> keyedMessage) {
                        return keyedMessage.topic();
                    }
                }, Seq$.MODULE$.canBuildFrom()));
                if (this.topicMetadataRefreshInterval() >= 0 && SystemTime$.MODULE$.milliseconds() - this.lastTopicMetadataRefreshTime() > (long)this.topicMetadataRefreshInterval()) {
                    Utils$.MODULE$.swallowError((Function0<BoxedUnit>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final DefaultEventHandler $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.$outer.brokerPartitionInfo().updateInfo((scala.collection.immutable.Set<String>)this.$outer.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().toSet(), this.$outer.correlationId().getAndIncrement());
                        }
                        {
                            if (defaultEventHandler == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = defaultEventHandler;
                        }
                    });
                    this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh().clear();
                    this.lastTopicMetadataRefreshTime_$eq(SystemTime$.MODULE$.milliseconds());
                }
                objectRef.elem = this.dispatchSerializedData((Seq)objectRef.elem);
                if (((Seq)objectRef.elem).size() <= 0) continue;
                this.info((Function0<String>)new Serializable(this, intRef){
                    public static final long serialVersionUID;
                    private final DefaultEventHandler $outer;
                    private final IntRef remainingRetries$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Back off for %d ms before retrying send. Remaining retries = %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$producer$async$DefaultEventHandler$$config.retryBackoffMs()), BoxesRunTime.boxToInteger((int)(this.remainingRetries$1.elem - 1))}));
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.remainingRetries$1 = defaultEventHandler;
                    }
                });
                Thread.sleep(this.kafka$producer$async$DefaultEventHandler$$config.retryBackoffMs());
                Utils$.MODULE$.swallowError((Function0<BoxedUnit>)new Serializable(this, objectRef){
                    public static final long serialVersionUID;
                    private final DefaultEventHandler $outer;
                    private final ObjectRef outstandingProduceRequests$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.brokerPartitionInfo().updateInfo((scala.collection.immutable.Set<String>)((TraversableOnce)((Seq)this.outstandingProduceRequests$1.elem).map((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply(KeyedMessage<K, Message> keyedMessage) {
                                return keyedMessage.topic();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toSet(), this.$outer.correlationId().getAndIncrement());
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.outstandingProduceRequests$1 = defaultEventHandler;
                    }
                });
                --intRef.elem;
                this.kafka$producer$async$DefaultEventHandler$$producerStats().resendRate().mark();
            }
            if (((Seq)objectRef.elem).size() > 0) {
                this.kafka$producer$async$DefaultEventHandler$$producerStats().failedSendRate().mark();
                int n2 = this.correlationId().get();
                this.error((Function0<String>)new Serializable(this, objectRef, n, n2){
                    public static final long serialVersionUID;
                    private final ObjectRef outstandingProduceRequests$1;
                    private final int correlationIdStart$1;
                    private final int correlationIdEnd$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Failed to send requests for topics %s with correlation ids in [%d,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((Seq)this.outstandingProduceRequests$1.elem).map((Function1)new Serializable(this){
                            public static final long serialVersionUID;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply(KeyedMessage<K, Message> keyedMessage) {
                                return keyedMessage.topic();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toSet().mkString(","), BoxesRunTime.boxToInteger((int)this.correlationIdStart$1), BoxesRunTime.boxToInteger((int)(this.correlationIdEnd$1 - 1))}));
                    }
                    {
                        this.outstandingProduceRequests$1 = defaultEventHandler;
                        this.correlationIdStart$1 = n;
                        this.correlationIdEnd$1 = n2;
                    }
                });
                throw new FailedToSendMessageException(new StringBuilder().append((Object)"Failed to send messages after ").append((Object)BoxesRunTime.boxToInteger((int)this.kafka$producer$async$DefaultEventHandler$$config.messageSendMaxRetries())).append((Object)" tries.").toString(), null);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Seq<KeyedMessage<K, Message>> dispatchSerializedData(Seq<KeyedMessage<K, Message>> arrayBuffer) {
        ArrayBuffer arrayBuffer2;
        ArrayBuffer arrayBuffer3;
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option = this.partitionAndCollate((Seq<KeyedMessage<K, Message>>)arrayBuffer);
        Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option2 = option;
        if (option2 instanceof Some) {
            arrayBuffer3 = new ArrayBuffer();
            try {
                ((IterableLike)((TraversableLike)((Some)option2).x()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> tuple2) {
                        Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> tuple22 = tuple2;
                        return tuple22 != null;
                    }
                })).foreach((Function1)new Serializable(this, arrayBuffer3){
                    public static final long serialVersionUID;
                    private final DefaultEventHandler $outer;
                    public final ArrayBuffer failedProduceRequests$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> tuple2) {
                        Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>> tuple22 = tuple2;
                        if (tuple22 != null) {
                            int n = BoxesRunTime.unboxToInt((Object)tuple22._1());
                            scala.collection.mutable.Map map = (scala.collection.mutable.Map)tuple22._2();
                            int n2 = n;
                            scala.collection.mutable.Map map2 = map;
                            if (this.$outer.logger().isTraceEnabled()) {
                                map2.foreach((Function1)new Serializable(this, n2){
                                    public static final long serialVersionUID;
                                    private final $anonfun$dispatchSerializedData$2 $outer;
                                    public final int brokerid$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final void apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<K, Message>>> tuple2) {
                                        this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().trace((Function0<String>)new Serializable(this, tuple2){
                                            public static final long serialVersionUID;
                                            private final $anonfun$dispatchSerializedData$2$$anonfun$apply$2 $outer;
                                            private final Tuple2 partitionAndEvent$1;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final String apply() {
                                                return Predef$.MODULE$.augmentString("Handling event for Topic: %s, Broker: %d, Partitions: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionAndEvent$1._1(), BoxesRunTime.boxToInteger((int)this.$outer.brokerid$1), this.partitionAndEvent$1._2()}));
                                            }
                                            {
                                                if (var1_1 == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = var1_1;
                                                this.partitionAndEvent$1 = var2_2;
                                            }
                                        });
                                    }
                                    {
                                        if (var1_1 == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = var1_1;
                                        this.brokerid$1 = n;
                                    }
                                });
                            }
                            scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> map3 = this.$outer.kafka$producer$async$DefaultEventHandler$$groupMessagesToSet(map2);
                            Seq<TopicAndPartition> seq = this.$outer.kafka$producer$async$DefaultEventHandler$$send(n2, map3);
                            seq.foreach((Function1)new Serializable(this, map2){
                                public static final long serialVersionUID;
                                private final $anonfun$dispatchSerializedData$2 $outer;
                                private final scala.collection.mutable.Map messagesPerBrokerMap$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(TopicAndPartition topicAndPartition) {
                                    Option option;
                                    block4: {
                                        block3: {
                                            block2: {
                                                option = this.messagesPerBrokerMap$1.get((Object)topicAndPartition);
                                                if (!(option instanceof Some)) break block2;
                                                this.$outer.failedProduceRequests$1.appendAll((TraversableOnce)((Some)option).x());
                                                break block3;
                                            }
                                            None$ none$ = None$.MODULE$;
                                            Option option2 = option;
                                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                                        }
                                        return;
                                    }
                                    throw new MatchError((Object)option);
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.messagesPerBrokerMap$1 = var2_2;
                                }
                            });
                            return;
                        }
                        throw new MatchError(tuple22);
                    }

                    public DefaultEventHandler kafka$producer$async$DefaultEventHandler$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.failedProduceRequests$1 = defaultEventHandler;
                    }
                });
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Failed to send messages";
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID;
                    private final Throwable t$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.t$2;
                    }
                    {
                        this.t$2 = defaultEventHandler;
                    }
                });
            }
        } else {
            None$ none$ = None$.MODULE$;
            Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> option3 = option2;
            if (none$ == null) {
                if (option3 != null) {
                    throw new MatchError(option2);
                }
            } else if (!none$.equals(option3)) throw new MatchError(option2);
            arrayBuffer2 = arrayBuffer;
            return arrayBuffer2;
        }
        arrayBuffer2 = arrayBuffer3;
        return arrayBuffer2;
    }

    public Seq<KeyedMessage<K, Message>> serialize(Seq<KeyedMessage<K, V>> seq) {
        ArrayBuffer arrayBuffer = new ArrayBuffer(seq.size());
        seq.map((Function1)new Serializable(this, arrayBuffer){
            public static final long serialVersionUID;
            private final DefaultEventHandler $outer;
            private final ArrayBuffer serializedMessages$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(KeyedMessage<K, V> keyedMessage) {
                ArrayBuffer arrayBuffer = null;
                try {
                    ArrayBuffer arrayBuffer2;
                    if (keyedMessage.hasKey()) {
                        byte[] byArray = this.$outer.kafka$producer$async$DefaultEventHandler$$keyEncoder().toBytes(keyedMessage.key());
                        byte[] byArray2 = this.$outer.kafka$producer$async$DefaultEventHandler$$encoder().toBytes(keyedMessage.message());
                        arrayBuffer2 = this.serializedMessages$1.$plus$eq(new KeyedMessage<K, Message>(keyedMessage.topic(), keyedMessage.key(), new Message(byArray2, byArray)));
                    } else {
                        arrayBuffer2 = this.serializedMessages$1.$plus$eq(new KeyedMessage<Object, Message>(keyedMessage.topic(), null, new Message(this.$outer.kafka$producer$async$DefaultEventHandler$$encoder().toBytes(keyedMessage.message()))));
                    }
                    arrayBuffer = arrayBuffer2;
                }
                catch (Throwable throwable) {
                    this.$outer.kafka$producer$async$DefaultEventHandler$$producerStats().serializationErrorRate().mark();
                    if (this.$outer.isSync()) {
                        throw throwable;
                    }
                    this.$outer.error((Function0<String>)new Serializable(this, keyedMessage){
                        public static final long serialVersionUID;
                        private final KeyedMessage e$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Error serializing message for topic %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.topic()}));
                        }
                        {
                            this.e$1 = var2_2;
                        }
                    }, (Function0<Throwable>)new Serializable(this, throwable){
                        public static final long serialVersionUID;
                        private final Throwable t$3;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Throwable apply() {
                            return this.t$3;
                        }
                        {
                            this.t$3 = var2_2;
                        }
                    });
                    arrayBuffer = BoxedUnit.UNIT;
                }
                return arrayBuffer;
            }
            {
                if (var1_1 == null) {
                    throw new NullPointerException();
                }
                this.$outer = var1_1;
                this.serializedMessages$1 = defaultEventHandler;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return arrayBuffer;
    }

    public Option<Map<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>>>> partitionAndCollate(Seq<KeyedMessage<K, Message>> seq) {
        HashMap hashMap = new HashMap();
        None$ none$ = null;
        try {
            seq.foreach((Function1)new Serializable(this, hashMap){
                public static final long serialVersionUID;
                private final DefaultEventHandler $outer;
                private final HashMap ret$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(KeyedMessage<K, Message> keyedMessage) {
                    Option option;
                    block4: {
                        Option option2;
                        block7: {
                            ArrayBuffer arrayBuffer;
                            block6: {
                                BoxedUnit boxedUnit;
                                TopicAndPartition topicAndPartition;
                                HashMap hashMap;
                                block5: {
                                    PartitionAndLeader partitionAndLeader;
                                    block3: {
                                        BoxedUnit boxedUnit2;
                                        int n;
                                        block2: {
                                            Seq<PartitionAndLeader> seq = this.$outer.kafka$producer$async$DefaultEventHandler$$getPartitionListForTopic(keyedMessage);
                                            int n2 = this.$outer.kafka$producer$async$DefaultEventHandler$$getPartition(keyedMessage.topic(), keyedMessage.key(), seq);
                                            partitionAndLeader = (PartitionAndLeader)seq.apply(n2);
                                            n = BoxesRunTime.unboxToInt((Object)partitionAndLeader.leaderBrokerIdOpt().getOrElse((Function0)new Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final int apply() {
                                                    return this.apply$mcI$sp();
                                                }

                                                public int apply$mcI$sp() {
                                                    return -1;
                                                }
                                            }));
                                            hashMap = null;
                                            option = this.ret$1.get((Object)BoxesRunTime.boxToInteger((int)n));
                                            if (!(option instanceof Some)) break block2;
                                            hashMap = (HashMap)((Some)option).x();
                                            boxedUnit2 = BoxedUnit.UNIT;
                                            break block3;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option option3 = option;
                                        if (none$ != null ? !none$.equals(option3) : option3 != null) break block4;
                                        hashMap = new HashMap();
                                        boxedUnit2 = this.ret$1.put((Object)BoxesRunTime.boxToInteger((int)n), (Object)hashMap);
                                    }
                                    topicAndPartition = new TopicAndPartition(keyedMessage.topic(), partitionAndLeader.partitionId());
                                    arrayBuffer = null;
                                    option2 = hashMap.get((Object)topicAndPartition);
                                    if (!(option2 instanceof Some)) break block5;
                                    arrayBuffer = (ArrayBuffer)((Some)option2).x();
                                    boxedUnit = BoxedUnit.UNIT;
                                    break block6;
                                }
                                None$ none$ = None$.MODULE$;
                                Option option4 = option2;
                                if (none$ != null ? !none$.equals(option4) : option4 != null) break block7;
                                arrayBuffer = new ArrayBuffer();
                                boxedUnit = hashMap.put((Object)topicAndPartition, (Object)arrayBuffer);
                            }
                            arrayBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{keyedMessage}));
                            return;
                        }
                        throw new MatchError((Object)option2);
                    }
                    throw new MatchError((Object)option);
                }
                {
                    if (var1_1 == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = var1_1;
                    this.ret$1 = defaultEventHandler;
                }
            });
            none$ = new Some((Object)hashMap);
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable oe$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to collate messages by topic, partition due to: ").append((Object)this.oe$1.getMessage()).toString();
                }
                {
                    this.oe$1 = defaultEventHandler;
                }
            });
            none$ = None$.MODULE$;
        }
        catch (LeaderNotAvailableException leaderNotAvailableException) {
            this.warn((Function0<String>)new Serializable(this, leaderNotAvailableException){
                public static final long serialVersionUID;
                private final LeaderNotAvailableException lnae$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to collate messages by topic,partition due to: ").append((Object)this.lnae$1.getMessage()).toString();
                }
                {
                    this.lnae$1 = defaultEventHandler;
                }
            });
            none$ = None$.MODULE$;
        }
        catch (UnknownTopicOrPartitionException unknownTopicOrPartitionException) {
            this.warn((Function0<String>)new Serializable(this, unknownTopicOrPartitionException){
                public static final long serialVersionUID;
                private final UnknownTopicOrPartitionException ute$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Failed to collate messages by topic,partition due to: ").append((Object)this.ute$1.getMessage()).toString();
                }
                {
                    this.ute$1 = defaultEventHandler;
                }
            });
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public final Seq<PartitionAndLeader> kafka$producer$async$DefaultEventHandler$$getPartitionListForTopic(KeyedMessage<K, Message> keyedMessage) {
        Seq<PartitionAndLeader> seq = this.brokerPartitionInfo().getBrokerPartitionInfo(keyedMessage.topic(), this.correlationId().getAndIncrement());
        this.debug((Function0<String>)new Serializable(this, keyedMessage, seq){
            public static final long serialVersionUID;
            private final KeyedMessage m$1;
            private final Seq topicPartitionsList$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Broker partitions registered for topic: %s are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.m$1.topic(), ((TraversableOnce)this.topicPartitionsList$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final int apply(PartitionAndLeader partitionAndLeader) {
                        return partitionAndLeader.partitionId();
                    }
                }, Seq$.MODULE$.canBuildFrom())).mkString(",")}));
            }
            {
                this.m$1 = defaultEventHandler;
                this.topicPartitionsList$1 = var3_3;
            }
        });
        int n = seq.length();
        if (n == 0) {
            throw new NoBrokersForPartitionException(new StringBuilder().append((Object)"Partition key = ").append(keyedMessage.key()).toString());
        }
        return seq;
    }

    public final int kafka$producer$async$DefaultEventHandler$$getPartition(String string, K k, Seq<PartitionAndLeader> seq) {
        int n;
        int n2;
        int n3 = seq.size();
        if (n3 <= 0) {
            throw new UnknownTopicOrPartitionException(new StringBuilder().append((Object)"Topic ").append((Object)string).append((Object)" doesn't exist").toString());
        }
        if (k == null) {
            Seq seq2 = (Seq)seq.filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(PartitionAndLeader partitionAndLeader) {
                    return partitionAndLeader.leaderBrokerIdOpt().isDefined();
                }
            });
            if (seq2.isEmpty()) {
                throw new LeaderNotAvailableException(new StringBuilder().append((Object)"No leader for any partition in topic ").append((Object)string).toString());
            }
            int n4 = Utils$.MODULE$.abs(this.partitionCounter().getAndIncrement()) % seq2.size();
            n2 = ((PartitionAndLeader)seq2.apply(n4)).partitionId();
        } else {
            n2 = n = this.partitioner().partition(k, n3);
        }
        if (n < 0 || n >= n3) {
            throw new UnknownTopicOrPartitionException(new StringBuilder().append((Object)"Invalid partition id: ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" for topic ").append((Object)string).append((Object)"; Valid values are in the inclusive range of [0, ").append((Object)BoxesRunTime.boxToInteger((int)(n3 - 1))).append((Object)"]").toString());
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Seq<TopicAndPartition> kafka$producer$async$DefaultEventHandler$$send(int n, scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> map) {
        List list;
        if (n < 0) {
            this.warn((Function0<String>)new Serializable(this, map){
                public static final long serialVersionUID;
                private final scala.collection.mutable.Map messagesPerTopic$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Failed to send data since partitions %s don't have a leader").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.messagesPerTopic$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final TopicAndPartition apply(Tuple2<TopicAndPartition, ByteBufferMessageSet> tuple2) {
                            return (TopicAndPartition)tuple2._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    this.messagesPerTopic$1 = defaultEventHandler;
                }
            });
            list = map.keys().toSeq();
            return list;
        }
        if (map.size() <= 0) {
            list = List$.MODULE$.empty();
            return list;
        }
        int n2 = this.correlationId().getAndIncrement();
        ProducerRequest producerRequest = new ProducerRequest(n2, this.kafka$producer$async$DefaultEventHandler$$config.clientId(), this.kafka$producer$async$DefaultEventHandler$$config.requestRequiredAcks(), this.kafka$producer$async$DefaultEventHandler$$config.requestTimeoutMs(), map);
        Seq seq3 = (Seq)Seq$.MODULE$.empty();
        Seq seq = null;
        try {
            Seq seq2;
            SyncProducer syncProducer = this.producerPool().getProducer(n);
            this.debug((Function0<String>)new Serializable(this, n, map, n2, syncProducer){
                public static final long serialVersionUID;
                private final int brokerId$1;
                private final scala.collection.mutable.Map messagesPerTopic$1;
                private final int currentCorrelationId$1;
                private final SyncProducer syncProducer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Producer sending messages with correlation id %d for topics %s to broker %d on %s:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentCorrelationId$1), this.messagesPerTopic$1.keySet().mkString(","), BoxesRunTime.boxToInteger((int)this.brokerId$1), this.syncProducer$1.config().host(), BoxesRunTime.boxToInteger((int)this.syncProducer$1.config().port())}));
                }
                {
                    this.brokerId$1 = n;
                    this.messagesPerTopic$1 = var3_3;
                    this.currentCorrelationId$1 = n2;
                    this.syncProducer$1 = var5_5;
                }
            });
            ProducerResponse producerResponse = syncProducer.send(producerRequest);
            this.debug((Function0<String>)new Serializable(this, n, map, n2, syncProducer){
                public static final long serialVersionUID;
                private final int brokerId$1;
                private final scala.collection.mutable.Map messagesPerTopic$1;
                private final int currentCorrelationId$1;
                private final SyncProducer syncProducer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Producer sent messages with correlation id %d for topics %s to broker %d on %s:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentCorrelationId$1), this.messagesPerTopic$1.keySet().mkString(","), BoxesRunTime.boxToInteger((int)this.brokerId$1), this.syncProducer$1.config().host(), BoxesRunTime.boxToInteger((int)this.syncProducer$1.config().port())}));
                }
                {
                    this.brokerId$1 = n;
                    this.messagesPerTopic$1 = var3_3;
                    this.currentCorrelationId$1 = n2;
                    this.syncProducer$1 = var5_5;
                }
            });
            if (producerResponse == null) {
                seq2 = (Seq)Seq$.MODULE$.empty();
            } else {
                Seq seq4;
                if (producerResponse.status().size() != producerRequest.data().size()) {
                    throw new KafkaException(Predef$.MODULE$.augmentString("Incomplete response (%s) for producer request (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{producerResponse, producerRequest})));
                }
                if (this.logger().isTraceEnabled()) {
                    Map map2 = (Map)producerResponse.status().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2) {
                            return ((ProducerResponseStatus)tuple2._2()).error() == ErrorMapping$.MODULE$.NoError();
                        }
                    });
                    map2.foreach((Function1)new Serializable(this, map){
                        public static final long serialVersionUID;
                        private final DefaultEventHandler $outer;
                        private final scala.collection.mutable.Map messagesPerTopic$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2) {
                            ((IterableLike)this.messagesPerTopic$1.apply(tuple2._1())).foreach((Function1)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$kafka$producer$async$DefaultEventHandler$$send$4 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final void apply(MessageAndOffset messageAndOffset) {
                                    this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().trace((Function0<String>)new Serializable(this, messageAndOffset){
                                        public static final long serialVersionUID;
                                        private final MessageAndOffset message$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Successfully sent message: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Utils$.MODULE$.readString(this.message$1.message().payload(), Utils$.MODULE$.readString$default$2())}));
                                        }
                                        {
                                            this.message$1 = var2_2;
                                        }
                                    });
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                }
                            });
                        }

                        public DefaultEventHandler kafka$producer$async$DefaultEventHandler$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if (var1_1 == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = var1_1;
                            this.messagesPerTopic$1 = defaultEventHandler;
                        }
                    });
                }
                if ((seq3 = (Seq)(seq4 = ((MapLike)producerResponse.status().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2) {
                        return ((ProducerResponseStatus)tuple2._2()).error() != ErrorMapping$.MODULE$.NoError();
                    }
                })).toSeq()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2) {
                        return (TopicAndPartition)tuple2._1();
                    }
                }, Seq$.MODULE$.canBuildFrom())).size() > 0) {
                    String string = ((TraversableOnce)((TraversableLike)seq4.sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2, Tuple2<TopicAndPartition, ProducerResponseStatus> tuple22) {
                            return ((TopicAndPartition)tuple2._1()).topic().compareTo(((TopicAndPartition)tuple22._1()).topic()) < 0 || ((TopicAndPartition)tuple2._1()).topic().compareTo(((TopicAndPartition)tuple22._1()).topic()) == 0 && ((TopicAndPartition)tuple2._1()).partition() < ((TopicAndPartition)tuple22._1()).partition();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply(Tuple2<TopicAndPartition, ProducerResponseStatus> tuple2) {
                            Tuple2<TopicAndPartition, ProducerResponseStatus> tuple22 = tuple2;
                            if (tuple22 != null) {
                                return new StringBuilder().append((Object)((TopicAndPartition)tuple22._1()).toString()).append((Object)": ").append((Object)ErrorMapping$.MODULE$.exceptionFor(((ProducerResponseStatus)tuple22._2()).error()).getClass().getName()).toString();
                            }
                            throw new MatchError(tuple22);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(",");
                    this.warn((Function0<String>)new Serializable(this, n2, string){
                        public static final long serialVersionUID;
                        private final int currentCorrelationId$1;
                        private final String errorString$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Produce request with correlation id %d failed due to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentCorrelationId$1), this.errorString$1}));
                        }
                        {
                            this.currentCorrelationId$1 = n;
                            this.errorString$1 = var3_3;
                        }
                    });
                }
                seq2 = seq3;
            }
            seq = seq2;
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this, n, map, n2){
                public static final long serialVersionUID;
                private final int brokerId$1;
                private final scala.collection.mutable.Map messagesPerTopic$1;
                private final int currentCorrelationId$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Failed to send producer request with correlation id %d to broker %d with data for partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.currentCorrelationId$1), BoxesRunTime.boxToInteger((int)this.brokerId$1), ((TraversableOnce)this.messagesPerTopic$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final TopicAndPartition apply(Tuple2<TopicAndPartition, ByteBufferMessageSet> tuple2) {
                            return (TopicAndPartition)tuple2._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    this.brokerId$1 = n;
                    this.messagesPerTopic$1 = var3_3;
                    this.currentCorrelationId$1 = n2;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable t$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = defaultEventHandler;
                }
            });
            seq = map.keys().toSeq();
        }
        list = seq;
        return list;
    }

    public final scala.collection.mutable.Map<TopicAndPartition, ByteBufferMessageSet> kafka$producer$async$DefaultEventHandler$$groupMessagesToSet(scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<K, Message>>> map) {
        scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)map.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final DefaultEventHandler $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<TopicAndPartition, ByteBufferMessageSet> apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<K, Message>>> tuple2) {
                Tuple2<TopicAndPartition, Seq<KeyedMessage<K, Message>>> tuple22 = tuple2;
                if (tuple22 != null) {
                    ByteBufferMessageSet byteBufferMessageSet;
                    TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                    Seq seq = (Seq)tuple22._2();
                    TopicAndPartition topicAndPartition2 = topicAndPartition;
                    Seq seq2 = seq;
                    Seq seq3 = (Seq)seq2.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Message apply(KeyedMessage<K, Message> keyedMessage) {
                            return keyedMessage.message();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    CompressionCodec compressionCodec = this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                        this.$outer.debug((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID;
                            private final TopicAndPartition topicAndPartition$1;
                            private final Seq messages$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Sending %d messages with no compression to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.size()), this.topicAndPartition$1}));
                            }
                            {
                                this.topicAndPartition$1 = topicAndPartition;
                                this.messages$1 = seq;
                            }
                        });
                        byteBufferMessageSet = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, (Seq<Message>)seq3);
                    } else {
                        int n = this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressedTopics().size();
                        if (n == 0) {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$7 $outer;
                                private final TopicAndPartition topicAndPartition$1;
                                private final Seq messages$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().kafka$producer$async$DefaultEventHandler$$config.compressionCodec().codec()), this.topicAndPartition$1}));
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.topicAndPartition$1 = topicAndPartition;
                                    this.messages$1 = seq;
                                }
                            });
                            byteBufferMessageSet = new ByteBufferMessageSet(this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressionCodec(), (Seq<Message>)seq3);
                        } else if (this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressedTopics().contains((Object)topicAndPartition2.topic())) {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$7 $outer;
                                private final TopicAndPartition topicAndPartition$1;
                                private final Seq messages$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Sending %d messages with compression codec %d to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().kafka$producer$async$DefaultEventHandler$$config.compressionCodec().codec()), this.topicAndPartition$1}));
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.topicAndPartition$1 = topicAndPartition;
                                    this.messages$1 = seq;
                                }
                            });
                            byteBufferMessageSet = new ByteBufferMessageSet(this.$outer.kafka$producer$async$DefaultEventHandler$$config.compressionCodec(), (Seq<Message>)seq3);
                        } else {
                            this.$outer.debug((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anonfun$7 $outer;
                                private final TopicAndPartition topicAndPartition$1;
                                private final Seq messages$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Sending %d messages to %s with no compression as it is not in compressed.topics - %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.messages$1.size()), this.topicAndPartition$1, this.$outer.kafka$producer$async$DefaultEventHandler$$anonfun$$$outer().kafka$producer$async$DefaultEventHandler$$config.compressedTopics().toString()}));
                                }
                                {
                                    if (var1_1 == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = var1_1;
                                    this.topicAndPartition$1 = topicAndPartition;
                                    this.messages$1 = seq;
                                }
                            });
                            byteBufferMessageSet = new ByteBufferMessageSet(NoCompressionCodec$.MODULE$, (Seq<Message>)seq3);
                        }
                    }
                    return new Tuple2((Object)topicAndPartition2, (Object)byteBufferMessageSet);
                }
                throw new MatchError(tuple22);
            }

            public DefaultEventHandler kafka$producer$async$DefaultEventHandler$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (defaultEventHandler == null) {
                    throw new NullPointerException();
                }
                this.$outer = defaultEventHandler;
            }
        }, Map$.MODULE$.canBuildFrom());
        return map2;
    }

    @Override
    public void close() {
        if (this.producerPool() != null) {
            this.producerPool().close();
        }
    }

    public DefaultEventHandler(ProducerConfig producerConfig, Partitioner<K> partitioner, Encoder<V> encoder, Encoder<K> encoder2, ProducerPool producerPool, HashMap<String, TopicMetadata> hashMap) {
        this.kafka$producer$async$DefaultEventHandler$$config = producerConfig;
        this.partitioner = partitioner;
        this.kafka$producer$async$DefaultEventHandler$$encoder = encoder;
        this.kafka$producer$async$DefaultEventHandler$$keyEncoder = encoder2;
        this.producerPool = producerPool;
        this.topicPartitionInfos = hashMap;
        Logging$class.$init$(this);
        String string = producerConfig.producerType();
        this.isSync = !("sync" != null ? !"sync".equals(string) : string != null);
        this.partitionCounter = new AtomicInteger(0);
        this.correlationId = new AtomicInteger(0);
        this.brokerPartitionInfo = new BrokerPartitionInfo(producerConfig, producerPool, hashMap);
        this.lock = new Object();
        this.topicMetadataRefreshInterval = producerConfig.topicMetadataRefreshIntervalMs();
        this.lastTopicMetadataRefreshTime = 0L;
        this.kafka$producer$async$DefaultEventHandler$$topicMetadataToRefresh = Set$.MODULE$.empty();
        this.kafka$producer$async$DefaultEventHandler$$producerStats = ProducerStatsRegistry$.MODULE$.getProducerStats(producerConfig.clientId());
        this.kafka$producer$async$DefaultEventHandler$$producerTopicStats = ProducerTopicStatsRegistry$.MODULE$.getProducerTopicStats(producerConfig.clientId());
    }
}

