/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.InvalidMessageException;
import kafka.message.Message$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.Utils$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055v!B\u0001\u0003\u0011\u000b9\u0011aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tq!\\3tg\u0006<WMC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0006-\u0011q!T3tg\u0006<WmE\u0002\n\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001c\u0013\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u000f!9a$\u0003b\u0001\n\u0003y\u0012!C\"sG>3gm]3u+\u0005\u0001\u0003CA\u000b\"\u0013\t\u0011cCA\u0002J]RDa\u0001J\u0005!\u0002\u0013\u0001\u0013AC\"sG>3gm]3uA!9a%\u0003b\u0001\n\u0003y\u0012!C\"sG2+gn\u001a;i\u0011\u0019A\u0013\u0002)A\u0005A\u0005Q1I]2MK:<G\u000f\u001b\u0011\t\u000f)J!\u0019!C\u0001?\u0005YQ*Y4jG>3gm]3u\u0011\u0019a\u0013\u0002)A\u0005A\u0005aQ*Y4jG>3gm]3uA!9a&\u0003b\u0001\n\u0003y\u0012aC'bO&\u001cG*\u001a8hi\"Da\u0001M\u0005!\u0002\u0013\u0001\u0013\u0001D'bO&\u001cG*\u001a8hi\"\u0004\u0003b\u0002\u001a\n\u0005\u0004%\taH\u0001\u0011\u0003R$(/\u001b2vi\u0016\u001cxJ\u001a4tKRDa\u0001N\u0005!\u0002\u0013\u0001\u0013!E!uiJL'-\u001e;fg>3gm]3uA!9a'\u0003b\u0001\n\u0003y\u0012\u0001E!uiJL'-\u001e;fg2+gn\u001a;i\u0011\u0019A\u0014\u0002)A\u0005A\u0005\t\u0012\t\u001e;sS\n,H/Z:MK:<G\u000f\u001b\u0011\t\u000fiJ!\u0019!C\u0001?\u0005i1*Z=TSj,wJ\u001a4tKRDa\u0001P\u0005!\u0002\u0013\u0001\u0013AD&fsNK'0Z(gMN,G\u000f\t\u0005\b}%\u0011\r\u0011\"\u0001 \u00035YU-_*ju\u0016dUM\\4uQ\"1\u0001)\u0003Q\u0001\n\u0001\nabS3z'&TX\rT3oORD\u0007\u0005C\u0004C\u0013\t\u0007I\u0011A\u0010\u0002\u0013-+\u0017p\u00144gg\u0016$\bB\u0002#\nA\u0003%\u0001%\u0001\u0006LKf|eMZ:fi\u0002BqAR\u0005C\u0002\u0013\u0005q$A\bWC2,XmU5{K2+gn\u001a;i\u0011\u0019A\u0015\u0002)A\u0005A\u0005\u0001b+\u00197vKNK'0\u001a'f]\u001e$\b\u000e\t\u0005\b\u0015&\u0011\r\u0011\"\u0001 \u0003=iUm]:bO\u0016|e/\u001a:iK\u0006$\u0007B\u0002'\nA\u0003%\u0001%\u0001\tNKN\u001c\u0018mZ3Pm\u0016\u0014\b.Z1eA!9a*\u0003b\u0001\n\u0003y\u0012!D'j]\"+\u0017\rZ3s'&TX\r\u0003\u0004Q\u0013\u0001\u0006I\u0001I\u0001\u000f\u001b&t\u0007*Z1eKJ\u001c\u0016N_3!\u0011\u001d\u0011\u0016B1A\u0005\u0002M\u000b\u0011cQ;se\u0016tG/T1hS\u000e4\u0016\r\\;f+\u0005!\u0006CA\u000bV\u0013\t1fC\u0001\u0003CsR,\u0007B\u0002-\nA\u0003%A+\u0001\nDkJ\u0014XM\u001c;NC\u001eL7MV1mk\u0016\u0004\u0003b\u0002.\n\u0005\u0004%\taH\u0001\u0014\u0007>l\u0007O]3tg&|gnQ8eK6\u000b7o\u001b\u0005\u00079&\u0001\u000b\u0011\u0002\u0011\u0002)\r{W\u000e\u001d:fgNLwN\\\"pI\u0016l\u0015m]6!\u0011\u001dq\u0016B1A\u0005\u0002}\tQBT8D_6\u0004(/Z:tS>t\u0007B\u00021\nA\u0003%\u0001%\u0001\bO_\u000e{W\u000e\u001d:fgNLwN\u001c\u0011\u0007\t)\u0011\u0001AY\n\u0004C2!\u0002\u0002\u00033b\u0005\u000b\u0007I\u0011A3\u0002\r\t,hMZ3s+\u00051\u0007CA4k\u001b\u0005A'BA5\u0011\u0003\rq\u0017n\\\u0005\u0003W\"\u0014!BQ=uK\n+hMZ3s\u0011!i\u0017M!A!\u0002\u00131\u0017a\u00022vM\u001a,'\u000f\t\u0005\u00067\u0005$\ta\u001c\u000b\u0003aF\u0004\"\u0001C1\t\u000b\u0011t\u0007\u0019\u00014\t\u000bm\tG\u0011A:\u0015\u0011A$\u0018p_A\u0001\u0003\u000bAQ!\u001e:A\u0002Y\fQAY=uKN\u00042!F<U\u0013\tAhCA\u0003BeJ\f\u0017\u0010C\u0003{e\u0002\u0007a/A\u0002lKfDQ\u0001 :A\u0002u\fQaY8eK\u000e\u0004\"\u0001\u0003@\n\u0005}\u0014!\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011\u0019\t\u0019A\u001da\u0001A\u0005i\u0001/Y=m_\u0006$wJ\u001a4tKRDa!a\u0002s\u0001\u0004\u0001\u0013a\u00039bs2|\u0017\rZ*ju\u0016DaaG1\u0005\u0002\u0005-Ac\u00029\u0002\u000e\u0005=\u0011\u0011\u0003\u0005\u0007k\u0006%\u0001\u0019\u0001<\t\ri\fI\u00011\u0001w\u0011\u0019a\u0018\u0011\u0002a\u0001{\"11$\u0019C\u0001\u0003+!R\u0001]A\f\u00033Aa!^A\n\u0001\u00041\bB\u0002?\u0002\u0014\u0001\u0007Q\u0010\u0003\u0004\u001cC\u0012\u0005\u0011Q\u0004\u000b\u0006a\u0006}\u0011\u0011\u0005\u0005\u0007k\u0006m\u0001\u0019\u0001<\t\ri\fY\u00021\u0001w\u0011\u0019Y\u0012\r\"\u0001\u0002&Q\u0019\u0001/a\n\t\rU\f\u0019\u00031\u0001w\u0011\u001d\tY#\u0019C\u0001\u0003[\tqbY8naV$Xm\u00115fG.\u001cX/\u001c\u000b\u0003\u0003_\u00012!FA\u0019\u0013\r\t\u0019D\u0006\u0002\u0005\u0019>tw\rC\u0004\u00028\u0005$\t!!\u000f\u0002\u0011\rDWmY6tk6,\"!a\f\t\u000f\u0005u\u0012\r\"\u0001\u0002@\u00059\u0011n\u001d,bY&$WCAA!!\r)\u00121I\u0005\u0004\u0003\u000b2\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0013\nG\u0011AA&\u0003-)gn];sKZ\u000bG.\u001b3\u0015\u0005\u00055\u0003cA\u000b\u0002P%\u0019\u0011\u0011\u000b\f\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003+\nG\u0011A\u0010\u0002\tML'0\u001a\u0005\u0007\u00033\nG\u0011A\u0010\u0002\u000f-,\u0017pU5{K\"9\u0011QL1\u0005\u0002\u0005}\u0012A\u00025bg.+\u0017\u0010\u0003\u0004\u0002b\u0005$IaH\u0001\u0012a\u0006LHn\\1e'&TXm\u00144gg\u0016$\bBBA\u0004C\u0012\u0005q\u0004\u0003\u0004\u0002h\u0005$\taU\u0001\u0006[\u0006<\u0017n\u0019\u0005\u0007\u0003W\nG\u0011A*\u0002\u0015\u0005$HO]5ckR,7\u000fC\u0004\u0002p\u0005$\t!!\u001d\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cW#A?\t\r\u0005U\u0014\r\"\u0001f\u0003\u001d\u0001\u0018-\u001f7pC\u0012DQA_1\u0005\u0002\u0015Dq!a\u001fb\t\u0013\ti(\u0001\btY&\u001cW\rR3mS6LG/\u001a3\u0015\u0007\u0019\fy\bC\u0004\u0002\u0002\u0006e\u0004\u0019\u0001\u0011\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005\u0015\u0015\r\"\u0011\u0002\b\u0006AAo\\*ue&tw\r\u0006\u0002\u0002\nB!\u00111RAI\u001d\r)\u0012QR\u0005\u0004\u0003\u001f3\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0014\u0006U%AB*ue&twMC\u0002\u0002\u0010ZAq!!'b\t\u0003\nY*\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0003\ni\n\u0003\u0005\u0002 \u0006]\u0005\u0019AAQ\u0003\r\tg.\u001f\t\u0004+\u0005\r\u0016bAAS-\t\u0019\u0011I\\=\t\u000f\u0005%\u0016\r\"\u0011\u0002,\u0006A\u0001.Y:i\u0007>$W\rF\u0001!\u0001")
public class Message
implements ScalaObject {
    private final ByteBuffer buffer;

    public static final int NoCompression() {
        return Message$.MODULE$.NoCompression();
    }

    public static final int CompressionCodeMask() {
        return Message$.MODULE$.CompressionCodeMask();
    }

    public static final byte CurrentMagicValue() {
        return Message$.MODULE$.CurrentMagicValue();
    }

    public static final int MinHeaderSize() {
        return Message$.MODULE$.MinHeaderSize();
    }

    public static final int MessageOverhead() {
        return Message$.MODULE$.MessageOverhead();
    }

    public static final int ValueSizeLength() {
        return Message$.MODULE$.ValueSizeLength();
    }

    public static final int KeyOffset() {
        return Message$.MODULE$.KeyOffset();
    }

    public static final int KeySizeLength() {
        return Message$.MODULE$.KeySizeLength();
    }

    public static final int KeySizeOffset() {
        return Message$.MODULE$.KeySizeOffset();
    }

    public static final int AttributesLength() {
        return Message$.MODULE$.AttributesLength();
    }

    public static final int AttributesOffset() {
        return Message$.MODULE$.AttributesOffset();
    }

    public static final int MagicLength() {
        return Message$.MODULE$.MagicLength();
    }

    public static final int MagicOffset() {
        return Message$.MODULE$.MagicOffset();
    }

    public static final int CrcLength() {
        return Message$.MODULE$.CrcLength();
    }

    public static final int CrcOffset() {
        return Message$.MODULE$.CrcOffset();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public long computeChecksum() {
        return Utils$.MODULE$.crc32(this.buffer().array(), this.buffer().arrayOffset() + Message$.MODULE$.MagicOffset(), this.buffer().limit() - Message$.MODULE$.MagicOffset());
    }

    public long checksum() {
        return Utils$.MODULE$.readUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset());
    }

    public boolean isValid() {
        return this.checksum() == this.computeChecksum();
    }

    public void ensureValid() {
        if (this.isValid()) {
            return;
        }
        throw new InvalidMessageException(new StringBuilder().append((Object)"Message is corrupt (stored crc = ").append((Object)BoxesRunTime.boxToLong((long)this.checksum())).append((Object)", computed crc = ").append((Object)BoxesRunTime.boxToLong((long)this.computeChecksum())).append((Object)")").toString());
    }

    public int size() {
        return this.buffer().limit();
    }

    public int keySize() {
        return this.buffer().getInt(Message$.MODULE$.KeySizeOffset());
    }

    public boolean hasKey() {
        return this.keySize() >= 0;
    }

    private int payloadSizeOffset() {
        return Message$.MODULE$.KeyOffset() + package$.MODULE$.max(0, this.keySize());
    }

    public int payloadSize() {
        return this.buffer().getInt(this.payloadSizeOffset());
    }

    public byte magic() {
        return this.buffer().get(Message$.MODULE$.MagicOffset());
    }

    public byte attributes() {
        return this.buffer().get(Message$.MODULE$.AttributesOffset());
    }

    public CompressionCodec compressionCodec() {
        return CompressionCodec$.MODULE$.getCompressionCodec(this.buffer().get(Message$.MODULE$.AttributesOffset()) & Message$.MODULE$.CompressionCodeMask());
    }

    public ByteBuffer payload() {
        return this.sliceDelimited(this.payloadSizeOffset());
    }

    public ByteBuffer key() {
        return this.sliceDelimited(Message$.MODULE$.KeySizeOffset());
    }

    private ByteBuffer sliceDelimited(int n) {
        ByteBuffer byteBuffer;
        int n2 = this.buffer().getInt(n);
        if (n2 < 0) {
            byteBuffer = null;
        } else {
            ByteBuffer byteBuffer2 = this.buffer().duplicate();
            byteBuffer2.position(n + 4);
            byteBuffer2 = byteBuffer2.slice();
            byteBuffer2.limit(n2);
            byteBuffer2.rewind();
            byteBuffer = byteBuffer2;
        }
        return byteBuffer;
    }

    public String toString() {
        return Predef$.MODULE$.augmentString("Message(magic = %d, attributes = %d, crc = %d, key = %s, payload = %s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)this.magic()), BoxesRunTime.boxToByte((byte)this.attributes()), BoxesRunTime.boxToLong((long)this.checksum()), this.key(), this.payload()}));
    }

    public boolean equals(Object object) {
        Object object2 = object;
        return object2 instanceof Message ? this.buffer().equals(((Message)object2).buffer()) : false;
    }

    public int hashCode() {
        return this.buffer().hashCode();
    }

    public Message(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    public Message(byte[] byArray, byte[] byArray2, CompressionCodec compressionCodec, int n, int n2) {
        this(ByteBuffer.allocate(Message$.MODULE$.CrcLength() + Message$.MODULE$.MagicLength() + Message$.MODULE$.AttributesLength() + Message$.MODULE$.KeySizeLength() + (byArray2 == null ? 0 : byArray2.length) + Message$.MODULE$.ValueSizeLength() + (n2 >= 0 ? n2 : byArray.length - n)));
        ByteBuffer byteBuffer;
        this.buffer().position(Message$.MODULE$.MagicOffset());
        this.buffer().put(Message$.MODULE$.CurrentMagicValue());
        byte by = 0;
        if (compressionCodec.codec() > 0) {
            by = (byte)(by | Message$.MODULE$.CompressionCodeMask() & compressionCodec.codec());
        }
        this.buffer().put(by);
        if (byArray2 == null) {
            byteBuffer = this.buffer().putInt(-1);
        } else {
            this.buffer().putInt(byArray2.length);
            byteBuffer = this.buffer().put(byArray2, 0, byArray2.length);
        }
        int n3 = n2 >= 0 ? n2 : byArray.length - n;
        this.buffer().putInt(n3);
        this.buffer().put(byArray, n, n3);
        this.buffer().rewind();
        Utils$.MODULE$.writeUnsignedInt(this.buffer(), Message$.MODULE$.CrcOffset(), this.computeChecksum());
    }

    public Message(byte[] byArray, byte[] byArray2, CompressionCodec compressionCodec) {
        this(byArray, byArray2, compressionCodec, 0, -1);
    }

    public Message(byte[] byArray, CompressionCodec compressionCodec) {
        this(byArray, null, compressionCodec);
    }

    public Message(byte[] byArray, byte[] byArray2) {
        this(byArray, byArray2, NoCompressionCodec$.MODULE$);
    }

    public Message(byte[] byArray) {
        this(byArray, null, NoCompressionCodec$.MODULE$);
    }
}

