/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.InvalidOffsetException;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.common.MessageSizeTooLargeException;
import kafka.common.OffsetOutOfRangeException;
import kafka.log.Log$;
import kafka.log.Log$MessageSetAppendInfo$;
import kafka.log.LogSegment;
import kafka.log.SegmentList;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerTopicStats$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassManifest;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0011Eq!B\u0001\u0003\u0011\u000b9\u0011a\u0001'pO*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0003\u0017\t\u0019Aj\\4\u0014\u0007%aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002$D\u0001\u0017\u0015\u00059\u0012!B:dC2\f\u0017BA\r\u0017\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000bmIA\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\u0010\n\u0005\u0004%\taH\u0001\u000e\u0019><g)\u001b7f'V4g-\u001b=\u0016\u0003\u0001\u0002\"!D\u0011\n\u0005\tr!AB*ue&tw\r\u0003\u0004%\u0013\u0001\u0006I\u0001I\u0001\u000f\u0019><g)\u001b7f'V4g-\u001b=!\u0011\u001d1\u0013B1A\u0005\u0002}\tq\"\u00138eKb4\u0015\u000e\\3Tk\u001a4\u0017\u000e\u001f\u0005\u0007Q%\u0001\u000b\u0011\u0002\u0011\u0002!%sG-\u001a=GS2,7+\u001e4gSb\u0004\u0003\"\u0002\u0016\n\t\u0003Y\u0013!\u00034j]\u0012\u0014\u0016M\\4f+\ta#\u0007\u0006\u0003.}\rC\u0005cA\u000b/a%\u0011qF\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005E\u0012D\u0002\u0001\u0003\u0006g%\u0012\r\u0001\u000e\u0002\u0002)F\u0011Q\u0007\u000f\t\u0003+YJ!a\u000e\f\u0003\u000f9{G\u000f[5oOB\u0011\u0011\bP\u0007\u0002u)\u00111\bB\u0001\u0006kRLGn]\u0005\u0003{i\u0012QAU1oO\u0016DQaP\u0015A\u0002\u0001\u000baA]1oO\u0016\u001c\bcA\u000bBa%\u0011!I\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006\t&\u0002\r!R\u0001\u0006m\u0006dW/\u001a\t\u0003+\u0019K!a\u0012\f\u0003\t1{gn\u001a\u0005\u0006\u0013&\u0002\rAS\u0001\nCJ\u0014\u0018-_*ju\u0016\u0004\"!F&\n\u000513\"aA%oi\")!&\u0003C\u0001\u001dV\u0011qJ\u0015\u000b\u0004!N+\u0006cA\u000b/#B\u0011\u0011G\u0015\u0003\u0006g5\u0013\r\u0001\u000e\u0005\u0006\u007f5\u0003\r\u0001\u0016\t\u0004+\u0005\u000b\u0006\"\u0002#N\u0001\u0004)\u0005\"B,\n\t\u0003A\u0016\u0001\u00074jY\u0016t\u0017-\\3Qe\u00164\u0017\u000e\u001f$s_6|eMZ:fiR\u0011\u0011l\u0018\t\u00035vs!!F.\n\u0005q3\u0012A\u0002)sK\u0012,g-\u0003\u0002#=*\u0011AL\u0006\u0005\u0006AZ\u0003\r!R\u0001\u0007_\u001a47/\u001a;\t\u000b\tLA\u0011A2\u0002\u00171|wMR5mK:\fW.\u001a\u000b\u0004I*d\u0007CA3i\u001b\u00051'BA4\u0011\u0003\tIw.\u0003\u0002jM\n!a)\u001b7f\u0011\u0015Y\u0017\r1\u0001e\u0003\r!\u0017N\u001d\u0005\u0006A\u0006\u0004\r!\u0012\u0005\u0006]&!\ta\\\u0001\u000eS:$W\r\u001f$jY\u0016t\u0017-\\3\u0015\u0007\u0011\u0004\u0018\u000fC\u0003l[\u0002\u0007A\rC\u0003a[\u0002\u0007Q\tC\u0003t\u0013\u0011\u0005A/A\bhKR,U\u000e\u001d;z\u001f\u001a47/\u001a;t)\r)\u00181\u0001\t\u0004mz,eBA<}\u001d\tA80D\u0001z\u0015\tQh!\u0001\u0004=e>|GOP\u0005\u0002/%\u0011QPF\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?\u0017\u0011\u0019\t)A\u001da\u0001\u000b\u0006IA/[7fgR\fW\u000e\u001d\u0005\n\u0003\u0013I\u0011\u0013!C\u0001\u0003\u0017\ta\"\u001b8ji\u0012\"WMZ1vYR$C'\u0006\u0002\u0002\u000e)\u001a!*a\u0004,\u0005\u0005E\u0001\u0003BA\n\u0003;i!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0007\u0017\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\t)BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\t\n#\u0003%\t!!\n\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%kU\u0011\u0011q\u0005\u0016\u0004\u000b\u0006=\u0001\"CA\u0016\u0013E\u0005I\u0011AA\u0006\u00039Ig.\u001b;%I\u00164\u0017-\u001e7uI]B\u0011\"a\f\n#\u0003%\t!a\u0003\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%q!I\u00111G\u0005\u0012\u0002\u0013\u0005\u0011QG\u0001\u000fS:LG\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\t9D\u000b\u0003\u0002:\u0005=\u0001cA\u001d\u0002<%\u0019\u0011Q\b\u001e\u0003\tQKW.\u001a\u0005\n\u0003\u0003J\u0011\u0013!C\u0001\u0003\u0017\tq\"\u001b8ji\u0012\"WMZ1vYR$\u0013\u0007\r\u0004\u0007\u0015\t\u0001A!!\u0012\u0014\u0011\u0005\rC\"a\u0012\u0002NQ\u00012!OA%\u0013\r\tYE\u000f\u0002\b\u0019><w-\u001b8h!\u0011\ty%!\u0016\u000e\u0005\u0005E#bAA*\t\u00059Q.\u001a;sS\u000e\u001c\u0018\u0002BA,\u0003#\u0012\u0011cS1gW\u0006lU\r\u001e:jGN<%o\\;q\u0011)Y\u00171\tBC\u0002\u0013\u0005\u00111L\u000b\u0002I\"Q\u0011qLA\"\u0005\u0003\u0005\u000b\u0011\u00023\u0002\t\u0011L'\u000f\t\u0005\f\u0003G\n\u0019E!b\u0001\n\u0003\t)'\u0001\bnCbdun\u001a$jY\u0016\u001c\u0016N_3\u0016\u0003)C!\"!\u001b\u0002D\t\u0005\t\u0015!\u0003K\u0003=i\u0017\r\u001f'pO\u001aKG.Z*ju\u0016\u0004\u0003bCA7\u0003\u0007\u0012)\u0019!C\u0001\u0003K\na\"\\1y\u001b\u0016\u001c8/Y4f'&TX\r\u0003\u0006\u0002r\u0005\r#\u0011!Q\u0001\n)\u000bq\"\\1y\u001b\u0016\u001c8/Y4f'&TX\r\t\u0005\f\u0003k\n\u0019E!b\u0001\n\u0003\t)'A\u0007gYV\u001c\b.\u00138uKJ4\u0018\r\u001c\u0005\u000b\u0003s\n\u0019E!A!\u0002\u0013Q\u0015A\u00044mkND\u0017J\u001c;feZ\fG\u000e\t\u0005\f\u0003{\n\u0019E!b\u0001\n\u0003\ty(\u0001\bs_2d\u0017J\u001c;feZ\fG.T:\u0016\u0003\u0015C!\"a!\u0002D\t\u0005\t\u0015!\u0003F\u0003=\u0011x\u000e\u001c7J]R,'O^1m\u001bN\u0004\u0003bCAD\u0003\u0007\u0012)\u0019!C\u0001\u0003\u0013\u000bQB\\3fIN\u0014VmY8wKJLXCAAF!\r)\u0012QR\u0005\u0004\u0003\u001f3\"a\u0002\"p_2,\u0017M\u001c\u0005\f\u0003'\u000b\u0019E!A!\u0002\u0013\tY)\u0001\boK\u0016$7OU3d_Z,'/\u001f\u0011\t\u0017\u0005]\u00151\tBC\u0002\u0013\u0005\u0011QM\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\u000b\u00037\u000b\u0019E!A!\u0002\u0013Q\u0015!D7bq&sG-\u001a=TSj,\u0007\u0005C\u0006\u0002 \u0006\r#Q1A\u0005\u0002\u0005\u0015\u0014AE5oI\u0016D\u0018J\u001c;feZ\fGNQ=uKND!\"a)\u0002D\t\u0005\t\u0015!\u0003K\u0003MIg\u000eZ3y\u0013:$XM\u001d<bY\nKH/Z:!\u0011-\t9+a\u0011\u0003\u0002\u0003\u0006I!!\u000f\u0002\tQLW.\u001a\u0005\u000b\u0003W\u000b\u0019E!A!\u0002\u0013Q\u0015\u0001\u00032s_.,'/\u00133\t\u000fm\t\u0019\u0005\"\u0001\u00020R1\u0012\u0011WAZ\u0003k\u000b9,!/\u0002<\u0006u\u0016qXAa\u0003\u0007\f)\rE\u0002\t\u0003\u0007Baa[AW\u0001\u0004!\u0007bBA2\u0003[\u0003\rA\u0013\u0005\b\u0003[\ni\u000b1\u0001K\u0011%\t)(!,\u0011\u0002\u0003\u0007!\nC\u0005\u0002~\u00055\u0006\u0013!a\u0001\u000b\"A\u0011qQAW\u0001\u0004\tY\tC\u0005\u0002\u0018\u00065\u0006\u0013!a\u0001\u0015\"I\u0011qTAW!\u0003\u0005\rA\u0013\u0005\u000b\u0003O\u000bi\u000b%AA\u0002\u0005e\u0002\"CAV\u0003[\u0003\n\u00111\u0001K\u0011)\tI-a\u0011C\u0002\u0013%\u00111Z\u0001\u0005Y>\u001c7.F\u0001\r\u0011!\ty-a\u0011!\u0002\u0013a\u0011!\u00027pG.\u0004\u0003BCAj\u0003\u0007\u0012\r\u0011\"\u0003\u0002V\u0006IQO\u001c4mkNDW\rZ\u000b\u0003\u0003/\u0004B!!7\u0002h6\u0011\u00111\u001c\u0006\u0005\u0003;\fy.\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003C\f\u0019/\u0001\u0006d_:\u001cWO\u001d:f]RT1!!:\u0011\u0003\u0011)H/\u001b7\n\t\u0005%\u00181\u001c\u0002\u000e\u0003R|W.[2J]R,w-\u001a:\t\u0013\u00055\u00181\tQ\u0001\n\u0005]\u0017AC;oM2,8\u000f[3eA!Q\u0011\u0011_A\"\u0005\u0004%I!a=\u0002\u001f1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016,\"!!>\u0011\t\u0005e\u0017q_\u0005\u0005\u0003s\fYN\u0001\u0006Bi>l\u0017n\u0019'p]\u001eD\u0011\"!@\u0002D\u0001\u0006I!!>\u0002!1\f7\u000f\u001e4mkNDW\r\u001a+j[\u0016\u0004\u0003b\u0003B\u0001\u0003\u0007\u0012\r\u0011\"\u0001\u0003\u0005\u0007\t\u0001b]3h[\u0016tGo]\u000b\u0003\u0005\u000b\u0001R\u0001\u0003B\u0004\u0005\u0017I1A!\u0003\u0003\u0005-\u0019VmZ7f]Rd\u0015n\u001d;\u0011\u0007!\u0011i!C\u0002\u0003\u0010\t\u0011!\u0002T8h'\u0016<W.\u001a8u\u0011%\u0011\u0019\"a\u0011!\u0002\u0013\u0011)!A\u0005tK\u001elWM\u001c;tA!Q!qCA\"\u0001\u0004%I!a=\u0002\u00159,\u0007\u0010^(gMN,G\u000f\u0003\u0006\u0003\u001c\u0005\r\u0003\u0019!C\u0005\u0005;\taB\\3yi>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u0003 \t\u0015\u0002cA\u000b\u0003\"%\u0019!1\u0005\f\u0003\tUs\u0017\u000e\u001e\u0005\u000b\u0005O\u0011I\"!AA\u0002\u0005U\u0018a\u0001=%c!I!1FA\"A\u0003&\u0011Q_\u0001\f]\u0016DHo\u00144gg\u0016$\b\u0005C\u0004\u00030\u0005\rC\u0011A\u0010\u0002\t9\fW.\u001a\u0005\t\u0005g\t\u0019\u0005\"\u0003\u00036\u0005aAn\\1e'\u0016<W.\u001a8ugR\u0011!Q\u0001\u0005\t\u0005s\t\u0019\u0005\"\u0003\u0003<\u0005q!/Z2pm\u0016\u00148+Z4nK:$H\u0003\u0002B\u0010\u0005{A\u0001Ba\u0010\u00038\u0001\u0007!1B\u0001\bg\u0016<W.\u001a8u\u0011!\u0011\u0019%a\u0011\u0005\u0002\u0005\u0015\u0014\u0001\u00058v[\n,'o\u00144TK\u001elWM\u001c;t\u0011!\u00119%a\u0011\u0005\u0002\t%\u0013!B2m_N,GC\u0001B\u0010\u0011!\u0011i%a\u0011\u0005\u0002\t=\u0013AB1qa\u0016tG\r\u0006\u0004\u0003R\t]#q\r\t\u0006+\tMS)R\u0005\u0004\u0005+2\"A\u0002+va2,'\u0007\u0003\u0005\u0003Z\t-\u0003\u0019\u0001B.\u0003!iWm]:bO\u0016\u001c\b\u0003\u0002B/\u0005Gj!Aa\u0018\u000b\u0007\t\u0005D!A\u0004nKN\u001c\u0018mZ3\n\t\t\u0015$q\f\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u0015\t%$1\nI\u0001\u0002\u0004\tY)A\u0007bgNLwM\\(gMN,Go\u001d\u0004\b\u0005[\n\u0019\u0005\u0011B8\u0005QiUm]:bO\u0016\u001cV\r^!qa\u0016tG-\u00138g_NA!1\u000e\u0007\u0015\u0005c\u00129\bE\u0002\u0016\u0005gJ1A!\u001e\u0017\u0005\u001d\u0001&o\u001c3vGR\u00042!\u0006B=\u0013\r\u0011YH\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\f\u0005\u007f\u0012YG!f\u0001\n\u0003\ty(A\u0006gSJ\u001cHo\u00144gg\u0016$\bB\u0003BB\u0005W\u0012\t\u0012)A\u0005\u000b\u0006aa-\u001b:ti>3gm]3uA!Y!q\u0011B6\u0005+\u0007I\u0011AA@\u0003)a\u0017m\u001d;PM\u001a\u001cX\r\u001e\u0005\u000b\u0005\u0017\u0013YG!E!\u0002\u0013)\u0015a\u00037bgR|eMZ:fi\u0002B1Ba$\u0003l\tU\r\u0011\"\u0001\u0003\u0012\u0006)1m\u001c3fGV\u0011!1\u0013\t\u0005\u0005;\u0012)*\u0003\u0003\u0003\u0018\n}#\u0001E\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\u0011-\u0011YJa\u001b\u0003\u0012\u0003\u0006IAa%\u0002\r\r|G-Z2!\u0011-\u0011yJa\u001b\u0003\u0016\u0004%\t!!\u001a\u0002\u000b\r|WO\u001c;\t\u0015\t\r&1\u000eB\tB\u0003%!*\u0001\u0004d_VtG\u000f\t\u0005\f\u0005O\u0013YG!f\u0001\n\u0003\tI)\u0001\tpM\u001a\u001cX\r^:N_:|Go\u001c8jG\"Y!1\u0016B6\u0005#\u0005\u000b\u0011BAF\u0003EygMZ:fiNluN\\8u_:L7\r\t\u0005\b7\t-D\u0011\u0001BX)1\u0011\tL!.\u00038\ne&1\u0018B_!\u0011\u0011\u0019La\u001b\u000e\u0005\u0005\r\u0003b\u0002B@\u0005[\u0003\r!\u0012\u0005\b\u0005\u000f\u0013i\u000b1\u0001F\u0011!\u0011yI!,A\u0002\tM\u0005b\u0002BP\u0005[\u0003\rA\u0013\u0005\t\u0005O\u0013i\u000b1\u0001\u0002\f\"Q!\u0011\u0019B6\u0003\u0003%\tAa1\u0002\t\r|\u0007/\u001f\u000b\r\u0005c\u0013)Ma2\u0003J\n-'Q\u001a\u0005\n\u0005\u007f\u0012y\f%AA\u0002\u0015C\u0011Ba\"\u0003@B\u0005\t\u0019A#\t\u0015\t=%q\u0018I\u0001\u0002\u0004\u0011\u0019\nC\u0005\u0003 \n}\u0006\u0013!a\u0001\u0015\"Q!q\u0015B`!\u0003\u0005\r!a#\t\u0015\tE'1NI\u0001\n\u0003\t)#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\t\u0015\tU'1NI\u0001\n\u0003\t)#\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\t\u0015\te'1NI\u0001\n\u0003\u0011Y.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tu'\u0006\u0002BJ\u0003\u001fA!B!9\u0003lE\u0005I\u0011AA\u0006\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQB!B!:\u0003lE\u0005I\u0011\u0001Bt\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU*\"A!;+\t\u0005-\u0015q\u0002\u0005\t\u0005[\u0014Y\u0007\"\u0011\u0003p\u0006A\u0001.Y:i\u0007>$W\rF\u0001K\u0011!\u0011\u0019Pa\u001b\u0005B\tU\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003eC\u0001B!?\u0003l\u0011\u0005#1`\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-%Q \u0005\u000b\u0005O\u001190!AA\u0002\t}\bcA\u000b\u0004\u0002%\u001911\u0001\f\u0003\u0007\u0005s\u0017\u0010C\u0004\u0004\b\t-D\u0011I\u0010\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011!\u0019YAa\u001b\u0005B\u0005\u0015\u0014\u0001\u00049s_\u0012,8\r^!sSRL\b\u0002CB\b\u0005W\"\te!\u0005\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q`B\n\u0011%\u00119c!\u0004\u0002\u0002\u0003\u0007!\n\u0003\u0005\u0004\u0018\t-D\u0011IB\r\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAF\u00077A!Ba\n\u0004\u0016\u0005\u0005\t\u0019\u0001B\u0000\u000f)\u0019y\"a\u0011\u0002\u0002#\u00151\u0011E\u0001\u0015\u001b\u0016\u001c8/Y4f'\u0016$\u0018\t\u001d9f]\u0012LeNZ8\u0011\t\tM61\u0005\u0004\u000b\u0005[\n\u0019%!A\t\u0006\r\u00152cBB\u0012\u0007O!\"q\u000f\t\u000e\u0007S\u0019y#R#\u0003\u0014*\u000bYI!-\u000e\u0005\r-\"bAB\u0017-\u00059!/\u001e8uS6,\u0017\u0002BB\u0019\u0007W\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86\u0011\u001dY21\u0005C\u0001\u0007k!\"a!\t\t\u0011\tM81\u0005C#\u0007s!\u0012\u0001\t\u0005\u000b\u0007{\u0019\u0019#!A\u0005\u0002\u000e}\u0012!B1qa2LH\u0003\u0004BY\u0007\u0003\u001a\u0019e!\u0012\u0004H\r%\u0003b\u0002B@\u0007w\u0001\r!\u0012\u0005\b\u0005\u000f\u001bY\u00041\u0001F\u0011!\u0011yia\u000fA\u0002\tM\u0005b\u0002BP\u0007w\u0001\rA\u0013\u0005\t\u0005O\u001bY\u00041\u0001\u0002\f\"Q1QJB\u0012\u0003\u0003%\tia\u0014\u0002\u000fUt\u0017\r\u001d9msR!1\u0011KB-!\u0011)bfa\u0015\u0011\u0015U\u0019)&R#\u0003\u0014*\u000bY)C\u0002\u0004XY\u0011a\u0001V;qY\u0016,\u0004\u0002CB.\u0007\u0017\u0002\rA!-\u0002\u0007a$\u0003\u0007\u0003\u0005\u0004`\u0005\rC\u0011BB1\u0003q\tg.\u00197zu\u0016\fe\u000e\u001a,bY&$\u0017\r^3NKN\u001c\u0018mZ3TKR$BA!-\u0004d!A!\u0011LB/\u0001\u0004\u0011Y\u0006\u0003\u0005\u0004h\u0005\rC\u0011BB5\u0003A!(/[7J]Z\fG.\u001b3CsR,7\u000f\u0006\u0003\u0003\\\r-\u0004\u0002\u0003B-\u0007K\u0002\rAa\u0017\t\u0011\r=\u00141\tC\u0001\u0007c\nAA]3bIRA11OB=\u0007{\u001a\t\t\u0005\u0003\u0003^\rU\u0014\u0002BB<\u0005?\u0012!\"T3tg\u0006<WmU3u\u0011\u001d\u0019Yh!\u001cA\u0002\u0015\u000b1b\u001d;beR|eMZ:fi\"91qPB7\u0001\u0004Q\u0015!C7bq2+gn\u001a;i\u0011)\u0019\u0019i!\u001c\u0011\u0002\u0003\u00071QQ\u0001\n[\u0006DxJ\u001a4tKR\u00042!\u0006\u0018F\u0011!\u0019I)a\u0011\u0005\u0002\r-\u0015\u0001E7be.$U\r\\3uK\u0012<\u0006.\u001b7f)\u0011\u0019iia$\u0011\tYt(1\u0002\u0005\t\u0007#\u001b9\t1\u0001\u0004\u0014\u0006I\u0001O]3eS\u000e\fG/\u001a\t\b+\rU%1BAF\u0013\r\u00199J\u0006\u0002\n\rVt7\r^5p]FB\u0001ba'\u0002D\u0011\u0005\u0011qP\u0001\u0005g&TX\r\u0003\u0005\u0004 \u0006\rC\u0011AA@\u00031awnZ#oI>3gm]3u\u0011!\u0019\u0019+a\u0011\u0005\n\r\u0015\u0016!C7bs\n,'k\u001c7m)\u0011\u0011Yaa*\t\u0011\t}2\u0011\u0015a\u0001\u0005\u0017A\u0001ba+\u0002D\u0011\u00051QV\u0001\u0005e>dG\u000e\u0006\u0002\u0003\f!A1\u0011WA\"\t\u0013\u0019\u0019,\u0001\u0007s_2dGk\\(gMN,G\u000f\u0006\u0003\u0003\f\rU\u0006bBB\\\u0007_\u0003\r!R\u0001\n]\u0016<xJ\u001a4tKRD\u0001ba/\u0002D\u0011%1QX\u0001\u000b[\u0006L(-\u001a$mkNDG\u0003\u0002B\u0010\u0007\u007fCqa!1\u0004:\u0002\u0007!*\u0001\tok6\u0014WM](g\u001b\u0016\u001c8/Y4fg\"A1QYA\"\t\u0003\u0011I%A\u0003gYV\u001c\b\u000e\u0003\u0005\u0004J\u0006\rC\u0011ABf\u0003A9W\r^(gMN,Go\u001d\"fM>\u0014X\rF\u0003v\u0007\u001b\u001cy\rC\u0004\u0002\u0006\r\u001d\u0007\u0019A#\t\u000f\rE7q\u0019a\u0001\u0015\u0006iQ.\u0019=Ok6|eMZ:fiND\u0001b!6\u0002D\u0011\u0005!\u0011J\u0001\u0007I\u0016dW\r^3\t\u0011\re\u00171\tC\u0001\u00077\fa\u0002Z3mKR,7+Z4nK:$8\u000fF\u0002K\u0007;D\u0001B!\u0001\u0004X\u0002\u00071Q\u0012\u0005\t\u0007C\f\u0019\u0005\"\u0001\u0004d\u0006QAO];oG\u0006$X\rV8\u0015\t\t}1Q\u001d\u0005\b\u0007O\u001cy\u000e1\u0001F\u00031!\u0018M]4fi>3gm]3u\u0011!\u0019Y/a\u0011\u0005\u0002\r5\u0018!\b;sk:\u001c\u0017\r^3B]\u0012\u001cF/\u0019:u/&$\bNT3x\u001f\u001a47/\u001a;\u0015\t\t}1q\u001e\u0005\b\u0007o\u001bI\u000f1\u0001F\u0011!\u0019\u00190a\u0011\u0005\u0002\tU\u0018!\u0003;pa&\u001cg*Y7f\u0011!\u001990a\u0011\u0005\u0002\re\u0018AE4fi2\u000b7\u000f\u001e$mkNDW\r\u001a+j[\u0016$\u0012!\u0012\u0005\t\u0005g\f\u0019\u0005\"\u0011\u0004:!Q1q`A\"#\u0003%\tAa:\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003C\u0002\u0003\u0007\n\n\u0011\"\u0001\u0005\u0006\u0005q!/Z1eI\u0011,g-Y;mi\u0012\u001aTC\u0001C\u0004U\u0011\u0019))a\u0004)\t\u0005\rC1\u0002\t\u0004s\u00115\u0011b\u0001C\bu\tQA\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class Log
implements KafkaMetricsGroup {
    private final File dir;
    private final int maxLogFileSize;
    private final int maxMessageSize;
    private final int flushInterval;
    private final long rollIntervalMs;
    private final boolean needsRecovery;
    private final int maxIndexSize;
    private final int indexIntervalBytes;
    public final Time kafka$log$Log$$time;
    private final Object lock;
    private final AtomicInteger unflushed;
    private final AtomicLong lastflushedTime;
    private final SegmentList<LogSegment> segments;
    private AtomicLong kafka$log$Log$$nextOffset;
    private volatile Log$MessageSetAppendInfo$ MessageSetAppendInfo$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    public static final int init$default$10() {
        return Log$.MODULE$.init$default$10();
    }

    public static final Time init$default$9() {
        return Log$.MODULE$.init$default$9();
    }

    public static final int init$default$8() {
        return Log$.MODULE$.init$default$8();
    }

    public static final int init$default$7() {
        return Log$.MODULE$.init$default$7();
    }

    public static final long init$default$5() {
        return Log$.MODULE$.init$default$5();
    }

    public static final int init$default$4() {
        return Log$.MODULE$.init$default$4();
    }

    public static final Seq<Object> getEmptyOffsets(long l) {
        return Log$.MODULE$.getEmptyOffsets(l);
    }

    public static final File indexFilename(File file, long l) {
        return Log$.MODULE$.indexFilename(file, l);
    }

    public static final File logFilename(File file, long l) {
        return Log$.MODULE$.logFilename(file, l);
    }

    public static final String filenamePrefixFromOffset(long l) {
        return Log$.MODULE$.filenamePrefixFromOffset(l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return Log$.MODULE$.findRange((Range[])TArray, l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        return Log$.MODULE$.findRange((Range[])TArray, l, n);
    }

    public static final String IndexFileSuffix() {
        return Log$.MODULE$.IndexFileSuffix();
    }

    public static final String LogFileSuffix() {
        return Log$.MODULE$.LogFileSuffix();
    }

    @Override
    public <T> Gauge<T> newGauge(String string, Gauge<T> gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Log log = this;
        synchronized (log) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public File dir() {
        return this.dir;
    }

    public int maxLogFileSize() {
        return this.maxLogFileSize;
    }

    public int maxMessageSize() {
        return this.maxMessageSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public long rollIntervalMs() {
        return this.rollIntervalMs;
    }

    public boolean needsRecovery() {
        return this.needsRecovery;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public int indexIntervalBytes() {
        return this.indexIntervalBytes;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicInteger unflushed() {
        return this.unflushed;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public SegmentList<LogSegment> segments() {
        return this.segments;
    }

    public final AtomicLong kafka$log$Log$$nextOffset() {
        return this.kafka$log$Log$$nextOffset;
    }

    private void kafka$log$Log$$nextOffset_$eq(AtomicLong atomicLong) {
        this.kafka$log$Log$$nextOffset = atomicLong;
    }

    public String name() {
        return this.dir().getName();
    }

    private SegmentList<LogSegment> loadSegments() {
        Boolean bl;
        ArrayList<LogSegment> arrayList = new ArrayList<LogSegment>();
        File[] fileArray = this.dir().listFiles();
        if (fileArray != null) {
            Predef$.MODULE$.refArrayOps((Object[])fileArray).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    return file.isFile();
                }
            }).foreach((Function1)new Serializable(this, arrayList){
                public static final long serialVersionUID;
                private final Log $outer;
                private final ArrayList logSegments$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object apply(File file) {
                    Object object;
                    String string = file.getName();
                    if (!file.canRead()) throw new IOException(new StringBuilder().append((Object)"Could not read file ").append((Object)file).toString());
                    if (string.endsWith(Log$.MODULE$.IndexFileSuffix())) {
                        File file2 = new File(file.getAbsolutePath().replace(Log$.MODULE$.IndexFileSuffix(), Log$.MODULE$.LogFileSuffix()));
                        if (file2.exists()) {
                            object = BoxedUnit.UNIT;
                            return object;
                        } else {
                            this.$outer.warn((Function0<String>)new Serializable(this, file){
                                public static final long serialVersionUID;
                                private final File file$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Found an orphaned index file, %s, with no corresponding log file.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getAbsolutePath()}));
                                }
                                {
                                    this.file$1 = file;
                                }
                            });
                            object = BoxesRunTime.boxToBoolean((boolean)file.delete());
                        }
                        return object;
                    } else if (string.endsWith(Log$.MODULE$.LogFileSuffix())) {
                        long l = Predef$.MODULE$.augmentString(string.substring(0, string.length() - Log$.MODULE$.LogFileSuffix().length())).toLong();
                        if (!Log$.MODULE$.indexFilename(this.$outer.dir(), l).exists()) throw new IllegalStateException("Found log file with no corresponding index file.");
                        object = BoxesRunTime.boxToBoolean((boolean)this.logSegments$1.add(new LogSegment(this.$outer.dir(), l, this.$outer.indexIntervalBytes(), this.$outer.maxIndexSize())));
                        return object;
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return object;
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                    this.logSegments$1 = arrayList;
                }
            });
        }
        if (arrayList.size() == 0) {
            bl = BoxesRunTime.boxToBoolean((boolean)arrayList.add(new LogSegment(this.dir(), 0L, this.indexIntervalBytes(), this.maxIndexSize())));
        } else {
            Collections.sort(arrayList, new Comparator<LogSegment>(this){

                public int compare(LogSegment logSegment, LogSegment logSegment2) {
                    return logSegment.start() == logSegment2.start() ? 0 : (logSegment.start() < logSegment2.start() ? -1 : 1);
                }
            });
            ((LogSegment)arrayList.get(arrayList.size() - 1)).index().resize(this.maxIndexSize());
            if (this.needsRecovery()) {
                LogSegment logSegment = (LogSegment)arrayList.get(arrayList.size() - 1);
                try {
                    this.recoverSegment(logSegment);
                }
                catch (InvalidOffsetException invalidOffsetException) {
                    long l = logSegment.start();
                    this.warn((Function0<String>)new Serializable(this, l){
                        public static final long serialVersionUID;
                        private final Log $outer;
                        private final long startOffset$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Found invalid offset during recovery of the active segment for topic partition ").append((Object)this.$outer.dir().getName()).append((Object)". Deleting the segment and ").append((Object)"creating an empty one with starting offset ").append((Object)BoxesRunTime.boxToLong((long)this.startOffset$1)).toString();
                        }
                        {
                            if (log == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = log;
                            this.startOffset$1 = l;
                        }
                    });
                    logSegment.truncateTo(l);
                }
            }
            bl = BoxedUnit.UNIT;
        }
        LogSegment[] logSegmentArray = (LogSegment[])arrayList.toArray((Object[])new LogSegment[arrayList.size()]);
        Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment logSegment) {
                Predef$.MODULE$.require(logSegment.index().entries() == 0 || logSegment.index().lastOffset() > logSegment.index().baseOffset(), (Function0)new Serializable(this, logSegment){
                    public static final long serialVersionUID;
                    private final LogSegment s$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Corrupt index found, index file (%s) has non-zero size but the last offset is %d and the base offset is %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.s$1.index().file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.s$1.index().lastOffset()), BoxesRunTime.boxToLong((long)this.s$1.index().baseOffset())}));
                    }
                    {
                        this.s$1 = logSegment;
                    }
                });
            }
        });
        return new SegmentList<LogSegment>((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])logSegmentArray), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
    }

    private void recoverSegment(LogSegment logSegment) {
        int n;
        this.info((Function0<String>)new Serializable(this, logSegment){
            public static final long serialVersionUID;
            private final LogSegment segment$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Recovering log segment %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.segment$1.messageSet().file().getAbsolutePath()}));
            }
            {
                this.segment$1 = logSegment;
            }
        });
        logSegment.index().truncate();
        int n2 = 0;
        int n3 = 0;
        Iterator<MessageAndOffset> iterator = logSegment.messageSet().iterator();
        try {
            while (iterator.hasNext()) {
                MessageAndOffset messageAndOffset = (MessageAndOffset)iterator.next();
                messageAndOffset.message().ensureValid();
                if (n2 - n3 > this.indexIntervalBytes()) {
                    CompressionCodec compressionCodec = messageAndOffset.message().compressionCodec();
                    NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                    CompressionCodec compressionCodec2 = compressionCodec;
                    long l = !(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null) ? messageAndOffset.offset() : ((MessageAndOffset)ByteBufferMessageSet$.MODULE$.decompress(messageAndOffset.message()).head()).offset();
                    logSegment.index().append(l, n2);
                    n3 = n2;
                }
                n2 += MessageSet$.MODULE$.entrySize(messageAndOffset.message());
            }
        }
        catch (InvalidMessageException invalidMessageException) {
            this.logger().warn((Object)new StringBuilder().append((Object)"Found invalid messages in log ").append((Object)this.name()).toString());
        }
        if ((n = logSegment.messageSet().sizeInBytes() - n2) > 0) {
            this.warn((Function0<String>)new Serializable(this, n){
                public static final long serialVersionUID;
                private final Log $outer;
                private final int truncated$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Truncated ").append((Object)BoxesRunTime.boxToInteger((int)this.truncated$1)).append((Object)" invalid bytes from the log ").append((Object)this.$outer.name()).append((Object)".").toString();
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                    this.truncated$1 = n;
                }
            });
        }
        logSegment.messageSet().truncateTo(n2);
    }

    public int numberOfSegments() {
        return ((LogSegment[])this.segments().view()).length;
    }

    public void close() {
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final Log $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Closing log ").append((Object)this.$outer.name()).toString();
            }
            {
                if (log == null) {
                    throw new NullPointerException();
                }
                this.$outer = log;
            }
        });
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment logSegment) {
                    logSegment.close();
                }
            });
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Object, Object> append(ByteBufferMessageSet byteBufferMessageSet, boolean bl) {
        Tuple2.mcJJ.sp sp2;
        MessageSetAppendInfo messageSetAppendInfo = this.analyzeAndValidateMessageSet(byteBufferMessageSet);
        if (messageSetAppendInfo.count() == 0) {
            sp2 = new Tuple2.mcJJ.sp(-1L, -1L);
            return sp2;
        }
        ObjectRef objectRef = new ObjectRef((Object)this.trimInvalidBytes(byteBufferMessageSet));
        Tuple2 tuple2 = null;
        try {
            Tuple2.mcJJ.sp sp3;
            Object object = this.lock();
            synchronized (object) {
                long l;
                long l2 = this.kafka$log$Log$$nextOffset().get();
                LogSegment logSegment = this.maybeRoll((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last());
                if (bl) {
                    AtomicLong atomicLong = new AtomicLong(this.kafka$log$Log$$nextOffset().get());
                    this.liftedTree1$1(messageSetAppendInfo, objectRef, atomicLong);
                    long l3 = atomicLong.get() - 1L;
                    long l4 = l3 - l2 + 1L;
                    BrokerTopicStats$.MODULE$.getBrokerTopicStats(this.topicName()).messagesInRate().mark(l4);
                    BrokerTopicStats$.MODULE$.getBrokerAllTopicsStats().messagesInRate().mark(l4);
                    l = l3;
                } else {
                    Predef$.MODULE$.require(messageSetAppendInfo.offsetsMonotonic(), (Function0)new Serializable(this, byteBufferMessageSet){
                        public static final long serialVersionUID;
                        private final ByteBufferMessageSet messages$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Out of order offsets found in ").append((Object)this.messages$1).toString();
                        }
                        {
                            this.messages$1 = byteBufferMessageSet;
                        }
                    });
                    Predef$.MODULE$.require(messageSetAppendInfo.firstOffset() >= this.kafka$log$Log$$nextOffset().get(), (Function0)new Serializable(this, messageSetAppendInfo){
                        public static final long serialVersionUID;
                        private final Log $outer;
                        private final MessageSetAppendInfo messageSetInfo$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Attempt to append a message set beginning with offset %d to a log with log end offset %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.messageSetInfo$1.firstOffset()), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$Log$$nextOffset().get())}));
                        }
                        {
                            if (log == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = log;
                            this.messageSetInfo$1 = messageSetAppendInfo;
                        }
                    });
                    l = messageSetAppendInfo.lastOffset();
                }
                long l5 = l;
                ((ByteBufferMessageSet)objectRef.elem).shallowIterator().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID;
                    private final Log $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(MessageAndOffset messageAndOffset) {
                        if (MessageSet$.MODULE$.entrySize(messageAndOffset.message()) > this.$outer.maxMessageSize()) {
                            throw new MessageSizeTooLargeException(Predef$.MODULE$.augmentString("Message size is %d bytes which exceeds the maximum configured message size of %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)MessageSet$.MODULE$.entrySize(messageAndOffset.message())), BoxesRunTime.boxToInteger((int)this.$outer.maxMessageSize())})));
                        }
                    }
                    {
                        if (log == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = log;
                    }
                });
                logSegment.append(l2, (ByteBufferMessageSet)objectRef.elem);
                this.kafka$log$Log$$nextOffset().set(l5 + 1L);
                this.trace((Function0<String>)new Serializable(this, objectRef, l2){
                    public static final long serialVersionUID;
                    private final Log $outer;
                    private final ObjectRef validMessages$1;
                    private final long firstOffset$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Appended message set to log %s with first offset: %d, next offset: %d, and messages: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.firstOffset$2), BoxesRunTime.boxToLong((long)this.$outer.kafka$log$Log$$nextOffset().get()), (ByteBufferMessageSet)this.validMessages$1.elem}));
                    }
                    {
                        if (log == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = log;
                        this.validMessages$1 = objectRef;
                        this.firstOffset$2 = l;
                    }
                });
                sp3 = new Tuple2.mcJJ.sp(l2, l5);
            }
            Tuple2 tuple22 = (Tuple2)sp3;
            int n = (int)(tuple22._2$mcJ$sp() - tuple22._1$mcJ$sp() + 1L);
            this.maybeFlush(n);
            tuple2 = tuple22;
            sp2 = tuple2;
            return sp2;
        }
        catch (IOException iOException) {
            throw new KafkaStorageException(Predef$.MODULE$.augmentString("I/O exception in append to log '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public boolean append$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Log$MessageSetAppendInfo$ MessageSetAppendInfo() {
        if (this.MessageSetAppendInfo$module != null) return this.MessageSetAppendInfo$module;
        Log log = this;
        synchronized (log) {
            if (this.MessageSetAppendInfo$module == null) {
                this.MessageSetAppendInfo$module = new Log$MessageSetAppendInfo$(this);
            }
            return this.MessageSetAppendInfo$module;
        }
    }

    private MessageSetAppendInfo analyzeAndValidateMessageSet(ByteBufferMessageSet byteBufferMessageSet) {
        IntRef intRef = new IntRef(0);
        LongRef longRef = new LongRef(-1L);
        LongRef longRef2 = new LongRef(-1L);
        ObjectRef objectRef = new ObjectRef((Object)NoCompressionCodec$.MODULE$);
        BooleanRef booleanRef = new BooleanRef(true);
        byteBufferMessageSet.shallowIterator().foreach((Function1)new Serializable(this, intRef, longRef, longRef2, objectRef, booleanRef){
            public static final long serialVersionUID;
            private final IntRef messageCount$1;
            private final LongRef firstOffset$3;
            private final LongRef lastOffset$2;
            private final ObjectRef codec$2;
            private final BooleanRef monotonic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MessageAndOffset messageAndOffset) {
                CompressionCodec compressionCodec;
                if (this.firstOffset$3.elem < 0L) {
                    this.firstOffset$3.elem = messageAndOffset.offset();
                }
                if (this.lastOffset$2.elem >= messageAndOffset.offset()) {
                    this.monotonic$1.elem = false;
                }
                this.lastOffset$2.elem = messageAndOffset.offset();
                Message message = messageAndOffset.message();
                message.ensureValid();
                ++this.messageCount$1.elem;
                CompressionCodec compressionCodec2 = compressionCodec = message.compressionCodec();
                NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                if (compressionCodec2 == null ? noCompressionCodec$ != null : !compressionCodec2.equals(noCompressionCodec$)) {
                    this.codec$2.elem = compressionCodec;
                }
            }
            {
                this.messageCount$1 = intRef;
                this.firstOffset$3 = longRef;
                this.lastOffset$2 = longRef2;
                this.codec$2 = objectRef;
                this.monotonic$1 = booleanRef;
            }
        });
        return new MessageSetAppendInfo(this, longRef.elem, longRef2.elem, (CompressionCodec)objectRef.elem, intRef.elem, booleanRef.elem);
    }

    private ByteBufferMessageSet trimInvalidBytes(ByteBufferMessageSet byteBufferMessageSet) {
        ByteBufferMessageSet byteBufferMessageSet2;
        int n = byteBufferMessageSet.validBytes();
        if (n < 0) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Illegal length of message set ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        if (n == byteBufferMessageSet.sizeInBytes()) {
            byteBufferMessageSet2 = byteBufferMessageSet;
        } else {
            ByteBuffer byteBuffer = byteBufferMessageSet.buffer().duplicate();
            byteBuffer.limit(n);
            byteBufferMessageSet2 = new ByteBufferMessageSet(byteBuffer);
        }
        return byteBufferMessageSet2;
    }

    public MessageSet read(long l, int n, Option<Object> option) {
        this.trace((Function0<String>)new Serializable(this, l, n){
            public static final long serialVersionUID;
            private final Log $outer;
            private final long startOffset$2;
            private final int maxLength$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Reading %d bytes from offset %d in log %s of length %d bytes").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxLength$1), BoxesRunTime.boxToLong((long)this.startOffset$2), this.$outer.name(), BoxesRunTime.boxToLong((long)this.$outer.size())}));
            }
            {
                if (log == null) {
                    throw new NullPointerException();
                }
                this.$outer = log;
                this.startOffset$2 = l;
                this.maxLength$1 = n;
            }
        });
        LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
        long l2 = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).head()).start();
        long l3 = this.kafka$log$Log$$nextOffset().get();
        if (l == l3) {
            return MessageSet$.MODULE$.Empty();
        }
        if (l > l3 || l < l2) {
            throw new OffsetOutOfRangeException(Predef$.MODULE$.augmentString("Request for offset %d but we only have log segments in the range %d to %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l), BoxesRunTime.boxToLong((long)l2), BoxesRunTime.boxToLong((long)l3)})));
        }
        Option option2 = Log$.MODULE$.findRange(logSegmentArray, l, logSegmentArray.length);
        None$ none$ = None$.MODULE$;
        Option option3 = option2;
        if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
            throw new OffsetOutOfRangeException("Offset is earlier than the earliest offset");
        }
        if (option2 instanceof Some) {
            return ((LogSegment)((Some)option2).x()).read(l, n, option);
        }
        throw new MatchError((Object)option2);
    }

    public Option read$default$3() {
        return None$.MODULE$;
    }

    public Seq<LogSegment> markDeletedWhile(Function1<LogSegment, Object> function1) {
        Object object = this.lock();
        synchronized (object) {
            Object object2;
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Garbage collecting log..";
                }
            });
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Segments of log %s : %s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), Predef$.MODULE$.refArrayOps((Object[])this.$outer.segments().view()).mkString(",")}));
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                }
            });
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Index files for log %s: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.segments().view()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(LogSegment logSegment) {
                            return logSegment.index().file().exists();
                        }
                    }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Boolean()))).mkString(",")}));
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                }
            });
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Data files for log %s: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.refArrayOps((Object[])this.$outer.segments().view()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(LogSegment logSegment) {
                            return logSegment.messageSet().file().exists();
                        }
                    }, Array$.MODULE$.canBuildFrom((ClassManifest)Manifest$.MODULE$.Boolean()))).mkString(",")}));
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                }
            });
            LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
            LogSegment[] logSegmentArray2 = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).takeWhile(function1);
            Predef$.MODULE$.refArrayOps((Object[])logSegmentArray2).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment logSegment) {
                    logSegment.deleted_$eq(true);
                }
            });
            int n = Predef$.MODULE$.refArrayOps((Object[])logSegmentArray2).size();
            if (n == Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).size()) {
                if (logSegmentArray[n - 1].size() > 0L) {
                    object2 = this.roll();
                } else {
                    logSegmentArray[n - 1].messageSet().file().setLastModified(this.kafka$log$Log$$time.milliseconds());
                    --n;
                    object2 = BoxedUnit.UNIT;
                }
            } else {
                object2 = BoxedUnit.UNIT;
            }
            Seq<LogSegment> seq = this.segments().trunc(n);
            return seq;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(long l, LogSegment logSegment) {
                return l + logSegment.size();
            }
        }));
    }

    public long logEndOffset() {
        return this.kafka$log$Log$$nextOffset().get();
    }

    private LogSegment maybeRoll(LogSegment logSegment) {
        LogSegment logSegment2;
        if (logSegment.messageSet().sizeInBytes() > this.maxLogFileSize()) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Rolling %s due to full data log").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name()}));
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                }
            });
            logSegment2 = this.roll();
        } else if (logSegment.firstAppendTime().isDefined() && this.kafka$log$Log$$time.milliseconds() - BoxesRunTime.unboxToLong((Object)logSegment.firstAppendTime().get()) > this.rollIntervalMs()) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Rolling %s due to time based rolling").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name()}));
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                }
            });
            logSegment2 = this.roll();
        } else if (logSegment.index().isFull()) {
            this.info((Function0<String>)new Serializable(this, logSegment){
                public static final long serialVersionUID;
                private final Log $outer;
                private final LogSegment segment$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Rolling %s due to full index maxIndexSize = %d, entries = %d, maxEntries = %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToInteger((int)this.segment$2.index().maxIndexSize()), BoxesRunTime.boxToInteger((int)this.segment$2.index().entries()), BoxesRunTime.boxToInteger((int)this.segment$2.index().maxEntries())}));
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                    this.segment$2 = logSegment;
                }
            });
            logSegment2 = this.roll();
        } else {
            logSegment2 = logSegment;
        }
        return logSegment2;
    }

    public LogSegment roll() {
        Object object = this.lock();
        synchronized (object) {
            this.flush();
            LogSegment logSegment = this.rollToOffset(this.logEndOffset());
            return logSegment;
        }
    }

    private LogSegment rollToOffset(long l) {
        Option option;
        block6: {
            block5: {
                block4: {
                    File file = Log$.MODULE$.logFilename(this.dir(), l);
                    File file2 = Log$.MODULE$.indexFilename(this.dir(), l);
                    List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{file, file2})).withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(File file) {
                            return file.exists();
                        }
                    }).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final Log $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(File file) {
                            this.$outer.warn((Function0<String>)new Serializable(this, file){
                                public static final long serialVersionUID;
                                private final File file$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Newly rolled segment file ").append((Object)this.file$2.getAbsolutePath()).append((Object)" already exists; deleting it first").toString();
                                }
                                {
                                    this.file$2 = file;
                                }
                            });
                            return file.delete();
                        }
                        {
                            if (log == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = log;
                        }
                    });
                    this.info((Function0<String>)new Serializable(this, file, file2){
                        public static final long serialVersionUID;
                        private final Log $outer;
                        private final File logFile$1;
                        private final File indexFile$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Rolling log '").append((Object)this.$outer.name()).append((Object)"' to ").append((Object)this.logFile$1.getAbsolutePath()).append((Object)" and ").append((Object)this.indexFile$1.getAbsolutePath()).toString();
                        }
                        {
                            if (log == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = log;
                            this.logFile$1 = file;
                            this.indexFile$1 = file2;
                        }
                    });
                    option = Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).lastOption();
                    if (!(option instanceof Some)) break block4;
                    ((LogSegment)((Some)option).x()).index().trimToValidSize();
                    break block5;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
            }
            LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
            if (Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).size() > 0 && ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).last()).start() == l) {
                throw new KafkaException(Predef$.MODULE$.augmentString("Trying to roll a new log segment for topic partition %s with start offset %d while it already exists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.dir().getName(), BoxesRunTime.boxToLong((long)l)})));
            }
            LogSegment logSegment = new LogSegment(this.dir(), l, this.indexIntervalBytes(), this.maxIndexSize());
            this.segments().append((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            return logSegment;
        }
        throw new MatchError((Object)option);
    }

    private void maybeFlush(int n) {
        if (this.unflushed().addAndGet(n) >= this.flushInterval()) {
            this.flush();
        }
    }

    public void flush() {
        if (this.unflushed().get() == 0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Flushing log '").append((Object)this.$outer.name()).append((Object)"' last flushed: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.getLastFlushedTime())).append((Object)" current time: ").append((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$log$Log$$time.milliseconds())).toString();
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                }
            });
            ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).flush();
            this.unflushed().set(0);
            this.lastflushedTime().set(this.kafka$log$Log$$time.milliseconds());
            return;
        }
    }

    public Seq<Object> getOffsetsBefore(long l, int n) {
        LogSegment[] logSegmentArray = (LogSegment[])this.segments().view();
        ObjectRef objectRef = new ObjectRef(null);
        objectRef.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).last()).size() > 0L ? new Tuple2[logSegmentArray.length + 1] : new Tuple2[logSegmentArray.length];
        Predef$.MODULE$.intWrapper(0).until(logSegmentArray.length).foreach$mVc$sp((Function1)new Serializable(this, logSegmentArray, objectRef){
            public static final long serialVersionUID;
            private final LogSegment[] segsArray$1;
            private final ObjectRef offsetTimeArray$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                ((Tuple2[])this.offsetTimeArray$1.elem)[n] = new Tuple2.mcJJ.sp(this.segsArray$1[n].start(), this.segsArray$1[n].messageSet().file().lastModified());
            }
            {
                this.segsArray$1 = logSegmentArray;
                this.offsetTimeArray$1 = objectRef;
            }
        });
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).last()).size() > 0L) {
            ((Tuple2[])objectRef.elem)[logSegmentArray.length] = new Tuple2.mcJJ.sp(this.logEndOffset(), this.kafka$log$Log$$time.milliseconds());
        }
        IntRef intRef = new IntRef(-1);
        long l2 = l;
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)OffsetRequest$.MODULE$.LatestTime()), (Object)BoxesRunTime.boxToLong((long)l2))) {
            intRef.elem = ((Tuple2[])objectRef.elem).length - 1;
        } else if (BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)OffsetRequest$.MODULE$.EarliestTime()), (Object)BoxesRunTime.boxToLong((long)l2))) {
            intRef.elem = 0;
        } else {
            boolean bl = false;
            this.debug((Function0<String>)new Serializable(this, objectRef){
                public static final long serialVersionUID;
                private final ObjectRef offsetTimeArray$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    StringBuilder stringBuilder = new StringBuilder().append((Object)"Offset time array = ");
                    Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])this.offsetTimeArray$1.elem)).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply(Tuple2<Object, Object> tuple2) {
                            return Predef$.MODULE$.augmentString("%d, %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)tuple2._1$mcJ$sp()), BoxesRunTime.boxToLong((long)tuple2._2$mcJ$sp())}));
                        }
                    });
                    return stringBuilder.append((Object)BoxedUnit.UNIT).toString();
                }
                {
                    this.offsetTimeArray$1 = objectRef;
                }
            });
            intRef.elem = ((Tuple2[])objectRef.elem).length - 1;
            while (intRef.elem >= 0 && !bl) {
                if (((Tuple2[])objectRef.elem)[intRef.elem]._2$mcJ$sp() <= l) {
                    bl = true;
                    continue;
                }
                --intRef.elem;
            }
        }
        int n2 = Predef$.MODULE$.intWrapper(n).min(intRef.elem + 1);
        long[] lArray = new long[n2];
        Predef$.MODULE$.intWrapper(0).until(n2).foreach$mVc$sp((Function1)new Serializable(this, objectRef, intRef, lArray){
            public static final long serialVersionUID;
            private final ObjectRef offsetTimeArray$1;
            private final IntRef startIndex$1;
            private final long[] ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int n) {
                this.apply$mcVI$sp(n);
            }

            public void apply$mcVI$sp(int n) {
                this.ret$1[n] = ((Tuple2[])this.offsetTimeArray$1.elem)[this.startIndex$1.elem]._1$mcJ$sp();
                --this.startIndex$1.elem;
            }
            {
                this.offsetTimeArray$1 = objectRef;
                this.startIndex$1 = intRef;
                this.ret$1 = lArray;
            }
        });
        return (Seq)Predef$.MODULE$.longArrayOps(lArray).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(long l) {
                return this.apply$mcJJ$sp(l);
            }

            public long apply$mcJJ$sp(long l) {
                return -l;
            }
        }, (Ordering)Ordering.Long$.MODULE$);
    }

    public void delete() {
        this.deleteSegments((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])this.segments().contents().get()));
        Utils$.MODULE$.rm(this.dir());
    }

    public int deleteSegments(Seq<LogSegment> seq) {
        IntRef intRef = new IntRef(0);
        seq.foreach((Function1)new Serializable(this, intRef){
            public static final long serialVersionUID;
            private final Log $outer;
            private final IntRef total$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment logSegment) {
                this.$outer.info((Function0<String>)new Serializable(this, logSegment){
                    public static final long serialVersionUID;
                    private final $anonfun$deleteSegments$1 $outer;
                    private final LogSegment segment$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Deleting log segment ").append((Object)BoxesRunTime.boxToLong((long)this.segment$3.start())).append((Object)" from ").append((Object)this.$outer.kafka$log$Log$$anonfun$$$outer().name()).toString();
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                        this.segment$3 = logSegment;
                    }
                });
                boolean bl = logSegment.messageSet().delete();
                boolean bl2 = logSegment.index().delete();
                if (bl2 && bl) {
                    ++this.total$1.elem;
                    if (logSegment.messageSet().file().exists()) {
                        this.$outer.error((Function0<String>)new Serializable(this, logSegment){
                            public static final long serialVersionUID;
                            private final LogSegment segment$3;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Data log file %s still exists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.segment$3.messageSet().file().getAbsolutePath()}));
                            }
                            {
                                this.segment$3 = logSegment;
                            }
                        });
                    }
                    if (logSegment.index().file().exists()) {
                        this.$outer.error((Function0<String>)new Serializable(this, logSegment){
                            public static final long serialVersionUID;
                            private final LogSegment segment$3;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Index file %s still exists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.segment$3.index().file().getAbsolutePath()}));
                            }
                            {
                                this.segment$3 = logSegment;
                            }
                        });
                    }
                    return;
                }
                throw new KafkaStorageException(new StringBuilder().append((Object)"Deleting log segment ").append((Object)BoxesRunTime.boxToLong((long)logSegment.start())).append((Object)" failed.").toString());
            }

            public Log kafka$log$Log$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (log == null) {
                    throw new NullPointerException();
                }
                this.$outer = log;
                this.total$1 = intRef;
            }
        });
        return intRef.elem;
    }

    public void truncateTo(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(Predef$.MODULE$.augmentString("Cannot truncate to a negative offset (%d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)l)})));
        }
        Object object = this.lock();
        synchronized (object) {
            Option option;
            block12: {
                block9: {
                    BoxedUnit boxedUnit;
                    block11: {
                        LogSegment logSegment;
                        block10: {
                            block8: {
                                LogSegment[] logSegmentArray = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).filter((Function1)new Serializable(this, l){
                                    public static final long serialVersionUID;
                                    private final long targetOffset$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final boolean apply(LogSegment logSegment) {
                                        return logSegment.start() > this.targetOffset$1;
                                    }
                                    {
                                        this.targetOffset$1 = l;
                                    }
                                });
                                int n = Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).size();
                                int n2 = this.deleteSegments((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])logSegmentArray));
                                if (n2 != Predef$.MODULE$.refArrayOps((Object[])logSegmentArray).size()) {
                                    this.error((Function0<String>)new Serializable(this, l){
                                        public static final long serialVersionUID;
                                        private final long targetOffset$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Failed to delete some segments when attempting to truncate to offset ").append((Object)BoxesRunTime.boxToLong((long)this.targetOffset$1)).append((Object)")").toString();
                                        }
                                        {
                                            this.targetOffset$1 = l;
                                        }
                                    });
                                }
                                if (n2 != n) break block8;
                                this.segments().trunc(Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).size());
                                this.rollToOffset(l);
                                this.kafka$log$Log$$nextOffset().set(l);
                                boxedUnit = BoxedUnit.UNIT;
                                break block9;
                            }
                            if (l <= this.logEndOffset()) break block10;
                            this.error((Function0<String>)new Serializable(this, l){
                                public static final long serialVersionUID;
                                private final Log $outer;
                                private final long targetOffset$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Target offset %d cannot be greater than the last message offset %d in the log %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.targetOffset$1), BoxesRunTime.boxToLong((long)this.$outer.logEndOffset()), ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.$outer.segments().view()).last()).messageSet().file().getAbsolutePath()}));
                                }
                                {
                                    if (log == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = log;
                                    this.targetOffset$1 = l;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        Option option2 = Log$.MODULE$.findRange((Range[])this.segments().view(), l);
                        option = option2;
                        if (!(option instanceof Some)) break block11;
                        Some some = (Some)option;
                        LogSegment logSegment2 = logSegment = (LogSegment)some.x();
                        int n = Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).indexOf((Object)logSegment2);
                        this.segments().truncLast(n);
                        logSegment2.truncateTo(l);
                        this.kafka$log$Log$$nextOffset().set(l);
                        this.info((Function0<String>)new Serializable(this, l){
                            public static final long serialVersionUID;
                            private final Log $outer;
                            private final long targetOffset$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Truncated log segment %s to target offset %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.$outer.segments().view()).last()).messageSet().file().getAbsolutePath(), BoxesRunTime.boxToLong((long)this.targetOffset$1)}));
                            }
                            {
                                if (log == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = log;
                                this.targetOffset$1 = l;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block12;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public void truncateAndStartWithNewOffset(long l) {
        Object object = this.lock();
        synchronized (object) {
            Seq<LogSegment> seq = this.segments().trunc(Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).size());
            this.info((Function0<String>)new Serializable(this, l){
                public static final long serialVersionUID;
                private final Log $outer;
                private final long newOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Truncate and start log '").append((Object)this.$outer.name()).append((Object)"' to ").append((Object)BoxesRunTime.boxToLong((long)this.newOffset$1)).toString();
                }
                {
                    if (log == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = log;
                    this.newOffset$1 = l;
                }
            });
            this.deleteSegments(seq);
            this.segments().append((Seq<LogSegment>)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{new LogSegment(this.dir(), l, this.indexIntervalBytes(), this.maxIndexSize())}), (ClassManifest<LogSegment>)ClassManifest$.MODULE$.classType(LogSegment.class));
            this.kafka$log$Log$$nextOffset().set(l);
            return;
        }
    }

    public String topicName() {
        return this.name().substring(0, this.name().lastIndexOf("-"));
    }

    public long getLastFlushedTime() {
        return this.lastflushedTime().get();
    }

    public String toString() {
        return new StringBuilder().append((Object)"Log(").append((Object)this.dir()).append((Object)")").toString();
    }

    private final void liftedTree1$1(MessageSetAppendInfo messageSetAppendInfo, ObjectRef objectRef, AtomicLong atomicLong) {
        try {
            objectRef.elem = ((ByteBufferMessageSet)objectRef.elem).assignOffsets(atomicLong, messageSetAppendInfo.codec());
            return;
        }
        catch (IOException iOException) {
            throw new KafkaException(Predef$.MODULE$.augmentString("Error in validating messages while appending to log '%s'").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name()})), iOException);
        }
    }

    public Log(File file, int n, int n2, int n3, long l, boolean bl, int n4, int n5, Time time, int n6) {
        this.dir = file;
        this.maxLogFileSize = n;
        this.maxMessageSize = n2;
        this.flushInterval = n3;
        this.rollIntervalMs = l;
        this.needsRecovery = bl;
        this.maxIndexSize = n4;
        this.indexIntervalBytes = n5;
        this.kafka$log$Log$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Kafka Log on Broker ").append((Object)BoxesRunTime.boxToInteger((int)n6)).append((Object)"], ").toString());
        this.lock = new Object();
        this.unflushed = new AtomicInteger(0);
        this.lastflushedTime = new AtomicLong(System.currentTimeMillis());
        this.segments = this.loadSegments();
        this.kafka$log$Log$$nextOffset = new AtomicLong(((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).nextOffset());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final Log $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Completed load of log %s with log end offset %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.name(), BoxesRunTime.boxToLong((long)this.$outer.logEndOffset())}));
            }
            {
                if (log == null) {
                    throw new NullPointerException();
                }
                this.$outer = log;
            }
        });
        this.newGauge(new StringBuilder().append((Object)this.name()).append((Object)"-").append((Object)"NumLogSegments").toString(), new Gauge<Object>(this){
            private final Log $outer;

            public int value() {
                return this.$outer.numberOfSegments();
            }
            {
                if (log == null) {
                    throw new NullPointerException();
                }
                this.$outer = log;
            }
        });
        this.newGauge(new StringBuilder().append((Object)this.name()).append((Object)"-").append((Object)"LogEndOffset").toString(), new Gauge<Object>(this){
            private final Log $outer;

            public long value() {
                return this.$outer.logEndOffset();
            }
            {
                if (log == null) {
                    throw new NullPointerException();
                }
                this.$outer = log;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MessageSetAppendInfo
    implements Product,
    Serializable {
        private final long firstOffset;
        private final long lastOffset;
        private final CompressionCodec codec;
        private final int count;
        private final boolean offsetsMonotonic;
        public final Log $outer;

        public Iterator<Object> productIterator() {
            return Product.class.productIterator((Product)this);
        }

        public Iterator<Object> productElements() {
            return Product.class.productElements((Product)this);
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public long lastOffset() {
            return this.lastOffset;
        }

        public CompressionCodec codec() {
            return this.codec;
        }

        public int count() {
            return this.count;
        }

        public boolean offsetsMonotonic() {
            return this.offsetsMonotonic;
        }

        public MessageSetAppendInfo copy(long l, long l2, CompressionCodec compressionCodec, int n, boolean bl) {
            return new MessageSetAppendInfo(this.kafka$log$Log$MessageSetAppendInfo$$$outer(), l, l2, compressionCodec, n, bl);
        }

        public boolean copy$default$5() {
            return this.offsetsMonotonic();
        }

        public int copy$default$4() {
            return this.count();
        }

        public CompressionCodec copy$default$3() {
            return this.codec();
        }

        public long copy$default$2() {
            return this.lastOffset();
        }

        public long copy$default$1() {
            return this.firstOffset();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl;
            boolean bl2;
            int n;
            int n2;
            CompressionCodec compressionCodec;
            CompressionCodec compressionCodec2;
            long l;
            long l2;
            if (this == object) return true;
            Object object2 = object;
            if (!(object2 instanceof MessageSetAppendInfo)) return false;
            if (((MessageSetAppendInfo)object2).kafka$log$Log$MessageSetAppendInfo$$$outer() != this.kafka$log$Log$MessageSetAppendInfo$$$outer()) return false;
            MessageSetAppendInfo messageSetAppendInfo = (MessageSetAppendInfo)object2;
            long l3 = messageSetAppendInfo.firstOffset();
            long l4 = l3;
            if (!this.gd1$1(l4, l2 = (l = messageSetAppendInfo.lastOffset()), compressionCodec2 = (compressionCodec = messageSetAppendInfo.codec()), n2 = (n = messageSetAppendInfo.count()), bl2 = (bl = messageSetAppendInfo.offsetsMonotonic()))) return false;
            boolean bl3 = ((MessageSetAppendInfo)object).canEqual(this);
            if (!bl3) return false;
            return true;
        }

        public String productPrefix() {
            return "MessageSetAppendInfo";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                }
                case 4: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.offsetsMonotonic());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this.count());
                    break;
                }
                case 2: {
                    object = this.codec();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.lastOffset());
                    break;
                }
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.firstOffset());
                }
            }
            return object;
        }

        public boolean canEqual(Object object) {
            return object instanceof MessageSetAppendInfo;
        }

        public Log kafka$log$Log$MessageSetAppendInfo$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean gd1$1(long l, long l2, CompressionCodec compressionCodec, int n, boolean bl) {
            if (l != this.firstOffset()) return false;
            if (l2 != this.lastOffset()) return false;
            CompressionCodec compressionCodec2 = compressionCodec;
            CompressionCodec compressionCodec3 = this.codec();
            if (compressionCodec2 == null) {
                if (compressionCodec3 != null) {
                    return false;
                }
            } else if (!compressionCodec2.equals(compressionCodec3)) return false;
            if (n != this.count()) return false;
            if (bl != this.offsetsMonotonic()) return false;
            return true;
        }

        public MessageSetAppendInfo(Log log, long l, long l2, CompressionCodec compressionCodec, int n, boolean bl) {
            this.firstOffset = l;
            this.lastOffset = l2;
            this.codec = compressionCodec;
            this.count = n;
            this.offsetsMonotonic = bl;
            if (log == null) {
                throw new NullPointerException();
            }
            this.$outer = log;
            Product.class.$init$((Product)this);
        }
    }
}

