/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.LeaderAndIsr;
import kafka.api.RequestOrResponse;
import kafka.common.LeaderElectionNotNeededException;
import kafka.common.NoReplicaOnlineException;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewPartition$;
import kafka.controller.NoOpLeaderSelector;
import kafka.controller.NonExistentPartition$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OnlinePartition$;
import kafka.controller.PartitionLeaderSelector;
import kafka.controller.PartitionState;
import kafka.controller.PartitionStateMachine$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5c\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tWM\u0003\u0002\u0004\t\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A1\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u00111bU2bY\u0006|%M[3di\"A1\u0001\u0001B\u0001B\u0003%Q\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ty1*\u00194lC\u000e{g\u000e\u001e:pY2,'\u000fC\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"A\b\u0001\t\u000b\r\t\u0003\u0019A\u000f\t\u000f\u001d\u0002!\u0019!C\u0005Q\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003%\u0002\"A\b\u0016\n\u0005-\u0012!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"1Q\u0006\u0001Q\u0001\n%\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!9q\u0006\u0001b\u0001\n\u0013\u0001\u0014\u0001D2p]R\u0014x\u000e\u001c7fe&#W#A\u0019\u0011\u0005]\u0011\u0014BA\u001a\u0019\u0005\rIe\u000e\u001e\u0005\u0007k\u0001\u0001\u000b\u0011B\u0019\u0002\u001b\r|g\u000e\u001e:pY2,'/\u00133!\u0011\u001d9\u0004A1A\u0005\na\n\u0001B_6DY&,g\u000e^\u000b\u0002sA\u0011!(Q\u0007\u0002w)\u0011A(P\u0001\tu.\u001cG.[3oi*\u0011ahP\u0001\u0007\u0013BJE/Z2\u000b\u0003\u0001\u000b1a\u001c:h\u0013\t\u00115H\u0001\u0005[W\u000ec\u0017.\u001a8u\u0011\u0019!\u0005\u0001)A\u0005s\u0005I!p[\"mS\u0016tG\u000f\t\u0005\b\r\u0002\u0001\r\u0011\"\u0001H\u00039\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016,\u0012\u0001\u0013\t\u0005\u0013:\u0003f+D\u0001K\u0015\tYE*A\u0004nkR\f'\r\\3\u000b\u00055C\u0012AC2pY2,7\r^5p]&\u0011qJ\u0013\u0002\u0004\u001b\u0006\u0004\bCA)U\u001b\u0005\u0011&BA*\u0005\u0003\u0019\u0019w.\\7p]&\u0011QK\u0015\u0002\u0012)>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007C\u0001\u0010X\u0013\tA&A\u0001\bQCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000fi\u0003\u0001\u0019!C\u00017\u0006\u0011\u0002/\u0019:uSRLwN\\*uCR,w\fJ3r)\tav\f\u0005\u0002\u0018;&\u0011a\f\u0007\u0002\u0005+:LG\u000fC\u0004a3\u0006\u0005\t\u0019\u0001%\u0002\u0007a$\u0013\u0007\u0003\u0004c\u0001\u0001\u0006K\u0001S\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fA!9A\r\u0001b\u0001\n\u0003)\u0017A\u00052s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012A\u001a\t\u0003=\u001dL!\u0001\u001b\u0002\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\"1!\u000e\u0001Q\u0001\n\u0019\f1C\u0019:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0002Bq\u0001\u001c\u0001C\u0002\u0013%Q.\u0001\u0006iCN\u001cF/\u0019:uK\u0012,\u0012A\u001c\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\fa!\u0019;p[&\u001c'BA:u\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003k2\tA!\u001e;jY&\u0011q\u000f\u001d\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\re\u0004\u0001\u0015!\u0003o\u0003-A\u0017m]*uCJ$X\r\u001a\u0011\t\u000fm\u0004!\u0019!C\u0005y\u0006Ybn\\(q!\u0006\u0014H/\u001b;j_:dU-\u00193feN+G.Z2u_J,\u0012! \t\u0003=yL!a \u0002\u0003%9{w\n\u001d'fC\u0012,'oU3mK\u000e$xN\u001d\u0005\b\u0003\u0007\u0001\u0001\u0015!\u0003~\u0003qqwn\u00149QCJ$\u0018\u000e^5p]2+\u0017\rZ3s'\u0016dWm\u0019;pe\u0002B\u0011\"a\u0002\u0001\u0005\u0004%I!!\u0003\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/\u0006\u0002\u0002\fA!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011!\u00027pORR'bAA\u000b\u007f\u00051\u0011\r]1dQ\u0016LA!!\u0007\u0002\u0010\t1Aj\\4hKJD\u0001\"!\b\u0001A\u0003%\u00111B\u0001\u0013gR\fG/Z\"iC:<W\rT8hO\u0016\u0014\b\u0005C\u0004\u0002\"\u0001!\t!a\t\u0002\u000fM$\u0018M\u001d;vaR\tA\fC\u0004\u0002(\u0001!\t!a\t\u0002#I,w-[:uKJd\u0015n\u001d;f]\u0016\u00148\u000fC\u0004\u0002,\u0001!\t!a\t\u0002\u0011MDW\u000f\u001e3po:Dq!a\f\u0001\t\u0003\t\u0019#A\u0011ue&<w-\u001a:P]2Lg.\u001a)beRLG/[8o'R\fG/Z\"iC:<W\rC\u0004\u00024\u0001!\t!!\u000e\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\b9\u0006]\u00121IA$\u0011!\tI$!\rA\u0002\u0005m\u0012A\u00039beRLG/[8ogB)\u0011QHA !6\tA*C\u0002\u0002B1\u00131aU3u\u0011\u001d\t)%!\rA\u0002Y\u000b1\u0002^1sO\u0016$8\u000b^1uK\"Q\u0011\u0011JA\u0019!\u0003\u0005\r!a\u0013\u0002\u001d1,\u0017\rZ3s'\u0016dWm\u0019;peB\u0019a$!\u0014\n\u0007\u0005=#AA\fQCJ$\u0018\u000e^5p]2+\u0017\rZ3s'\u0016dWm\u0019;pe\"9\u00111\u000b\u0001\u0005\n\u0005U\u0013!\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKRIA,a\u0016\u0002j\u00055\u0014q\u000e\u0005\t\u00033\n\t\u00061\u0001\u0002\\\u0005)Ao\u001c9jGB!\u0011QLA2\u001d\r9\u0012qL\u0005\u0004\u0003CB\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002f\u0005\u001d$AB*ue&twMC\u0002\u0002baAq!a\u001b\u0002R\u0001\u0007\u0011'A\u0005qCJ$\u0018\u000e^5p]\"9\u0011QIA)\u0001\u00041\u0006\u0002CA%\u0003#\u0002\r!a\u0013\t\u000f\u0005M\u0004\u0001\"\u0003\u0002$\u0005A\u0012N\\5uS\u0006d\u0017N_3QCJ$\u0018\u000e^5p]N#\u0018\r^3\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\u0005I\u0012m]:feR4\u0016\r\\5e!J,g/[8vgN#\u0018\r^3t)\u001da\u00161PA@\u0003\u0013Cq!! \u0002v\u0001\u0007\u0001+A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:D\u0001\"!!\u0002v\u0001\u0007\u00111Q\u0001\u000bMJ|Wn\u0015;bi\u0016\u001c\b#BA\u001f\u0003\u000b3\u0016bAAD\u0019\n\u00191+Z9\t\u000f\u0005\u0015\u0013Q\u000fa\u0001-\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0015AG1tg&<gNU3qY&\u001c\u0017m\u001d+p!\u0006\u0014H/\u001b;j_:\u001cH#\u0002/\u0002\u0012\u0006M\u0005\u0002CA-\u0003\u0017\u0003\r!a\u0017\t\u000f\u0005-\u00141\u0012a\u0001c!9\u0011q\u0013\u0001\u0005\n\u0005e\u0015AI5oSRL\u0017\r\\5{K2+\u0017\rZ3s\u0003:$\u0017j\u001d:G_J\u0004\u0016M\u001d;ji&|g\u000eF\u0002]\u00037Cq!! \u0002\u0016\u0002\u0007\u0001\u000bC\u0004\u0002 \u0002!\t!!)\u0002/\u0015dWm\u0019;MK\u0006$WM\u001d$peB\u000b'\u000f^5uS>tGc\u0002/\u0002$\u0006\u0015\u0016q\u0015\u0005\t\u00033\ni\n1\u0001\u0002\\!9\u00111NAO\u0001\u0004\t\u0004\u0002CA%\u0003;\u0003\r!a\u0013\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\u0006Y\"/Z4jgR,'\u000fV8qS\u000e\u001c\u0005.\u00198hK2K7\u000f^3oKJ$\"!a,\u0011\r\u0005E\u00161WA\\\u001b\u0005!\u0018bAA[i\n!A*[:u!\rI\u0011\u0011X\u0005\u0004\u0003KR\u0001bBA_\u0001\u0011\u0005\u0011qX\u0001 e\u0016<\u0017n\u001d;feB\u000b'\u000f^5uS>t7\t[1oO\u0016d\u0015n\u001d;f]\u0016\u0014H\u0003BAX\u0003\u0003D\u0001\"!\u0017\u0002<\u0002\u0007\u00111\f\u0005\b\u0003\u000b\u0004A\u0011BAd\u0003\u0011:W\r\u001e'fC\u0012,'/S:s\u0003:$W\t]8dQ>\u0013H\u000b\u001b:po\u0016C8-\u001a9uS>tGCBAe\u0003\u001f\f\t\u000eE\u0002\u001f\u0003\u0017L1!!4\u0003\u0005maU-\u00193fe&\u001b(/\u00118e\u0007>tGO]8mY\u0016\u0014X\t]8dQ\"A\u0011\u0011LAb\u0001\u0004\tY\u0006C\u0004\u0002l\u0005\r\u0007\u0019A\u0019\u0007\r\u0005U\u0007\u0001AAl\u0005M!v\u000e]5d\u0007\"\fgnZ3MSN$XM\\3s'\u001d\t\u0019\u000eCAm!Y\u00012AOAn\u0013\r\tin\u000f\u0002\u0011\u0013j[7\t[5mI2K7\u000f^3oKJDqAIAj\t\u0003\t\t\u000f\u0006\u0002\u0002dB!\u0011Q]Aj\u001b\u0005\u0001\u0001\u0002CAu\u0003'$\t!a;\u0002#!\fg\u000e\u001a7f\u0007\"LG\u000eZ\"iC:<W\rF\u0003]\u0003[\f\t\u0010\u0003\u0005\u0002p\u0006\u001d\b\u0019AA.\u0003)\u0001\u0018M]3oiB\u000bG\u000f\u001b\u0005\t\u0003g\f9\u000f1\u0001\u0002v\u0006A1\r[5mIJ,g\u000e\u0005\u0004\u00022\u0006M\u00161\f\u0015\u0007\u0003O\fI0a@\u0011\u0007]\tY0C\u0002\u0002~b\u0011a\u0001\u001e5s_^\u001c8E\u0001B\u0001!\u0011\u0011\u0019Aa\u0005\u000f\t\t\u0015!q\u0002\b\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1\u0002\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012b\u0001B\t1\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002B\u000b\u0005/\u0011\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\tE\u0001D\u0002\u0004\u0003\u001c\u0001\u0001!Q\u0004\u0002\u0018!\u0006\u0014H/\u001b;j_:\u001c\u0005.\u00198hK2K7\u000f^3oKJ\u001crA!\u0007\t\u00033\u0004b\u0003C\u0006\u0002Z\te!\u0011!Q\u0001\n\u0005m\u0003b\u0002\u0012\u0003\u001a\u0011\u0005!1\u0005\u000b\u0005\u0005K\u00119\u0003\u0005\u0003\u0002f\ne\u0001\u0002CA-\u0005C\u0001\r!a\u0017\t\u0011\u0005%(\u0011\u0004C\u0001\u0005W!R\u0001\u0018B\u0017\u0005_A\u0001\"a<\u0003*\u0001\u0007\u00111\f\u0005\t\u0003g\u0014I\u00031\u0001\u0002v\"2!\u0011FA}\u0003\u007fD\u0011B!\u000e\u0001#\u0003%\tAa\u000e\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!\u0011\b\u0016\u0005\u0003\u0017\u0012Yd\u000b\u0002\u0003>A!!q\bB%\u001b\t\u0011\tE\u0003\u0003\u0003D\t\u0015\u0013!C;oG\",7m[3e\u0015\r\u00119\u0005G\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B&\u0005\u0003\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class PartitionStateMachine
implements Logging {
    public final KafkaController kafka$controller$PartitionStateMachine$$controller;
    private final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$PartitionStateMachine$$zkClient;
    private Map<TopicAndPartition, PartitionState> partitionState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted;
    private final NoOpLeaderSelector noOpPartitionLeaderSelector;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PartitionStateMachine partitionStateMachine = this;
        synchronized (partitionStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public final ControllerContext kafka$controller$PartitionStateMachine$$controllerContext() {
        return this.kafka$controller$PartitionStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$PartitionStateMachine$$zkClient() {
        return this.kafka$controller$PartitionStateMachine$$zkClient;
    }

    public Map<TopicAndPartition, PartitionState> partitionState() {
        return this.partitionState;
    }

    public void partitionState_$eq(Map<TopicAndPartition, PartitionState> map) {
        this.partitionState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$PartitionStateMachine$$hasStarted() {
        return this.kafka$controller$PartitionStateMachine$$hasStarted;
    }

    private NoOpLeaderSelector noOpPartitionLeaderSelector() {
        return this.noOpPartitionLeaderSelector;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializePartitionState();
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(true);
        this.triggerOnlinePartitionStateChange();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Started partition state machine with initial state -> ").append((Object)this.$outer.partitionState().toString()).toString();
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
    }

    public void registerListeners() {
        this.registerTopicChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$PartitionStateMachine$$hasStarted().set(false);
        this.partitionState().clear();
    }

    public void triggerOnlinePartitionStateChange() {
        try {
            this.brokerRequestBatch().newBatch();
            ((IterableLike)this.partitionState().filter((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    return tuple22 != null;
                }
            })).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Tuple2<TopicAndPartition, PartitionState> tuple2) {
                    Tuple2<TopicAndPartition, PartitionState> tuple22 = tuple2;
                    if (tuple22 != null) {
                        TopicAndPartition topicAndPartition = (TopicAndPartition)tuple22._1();
                        PartitionState partitionState = (PartitionState)tuple22._2();
                        TopicAndPartition topicAndPartition2 = topicAndPartition;
                        PartitionState partitionState2 = partitionState;
                        if (partitionState2.equals(OfflinePartition$.MODULE$) || partitionState2.equals(NewPartition$.MODULE$)) {
                            this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition2.topic(), topicAndPartition2.partition(), OnlinePartition$.MODULE$, this.$outer.kafka$controller$PartitionStateMachine$$controller.offlinePartitionSelector());
                        }
                        return;
                    }
                    throw new MatchError(tuple22);
                }
                {
                    if (partitionStateMachine == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partitionStateMachine;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement(), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokers());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error while moving some partitions to the online state";
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            });
        }
    }

    public void handleStateChanges(Set<TopicAndPartition> set, PartitionState partitionState, PartitionLeaderSelector partitionLeaderSelector) {
        this.info((Function0<String>)new Serializable(this, set, partitionState){
            public static final long serialVersionUID;
            private final Set partitions$1;
            private final PartitionState targetState$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Invoking state change to %s for partitions %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.partitions$1.mkString(",")}));
            }
            {
                this.partitions$1 = set;
                this.targetState$1 = partitionState;
            }
        });
        try {
            this.brokerRequestBatch().newBatch();
            set.foreach((Function1)new Serializable(this, partitionState, partitionLeaderSelector){
                public static final long serialVersionUID;
                private final PartitionStateMachine $outer;
                private final PartitionState targetState$1;
                private final PartitionLeaderSelector leaderSelector$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(TopicAndPartition topicAndPartition) {
                    this.$outer.kafka$controller$PartitionStateMachine$$handleStateChange(topicAndPartition.topic(), topicAndPartition.partition(), this.targetState$1, this.leaderSelector$1);
                }
                {
                    if (partitionStateMachine == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partitionStateMachine;
                    this.targetState$1 = partitionState;
                    this.leaderSelector$1 = partitionLeaderSelector;
                }
            });
            this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$PartitionStateMachine$$controller.epoch(), this.kafka$controller$PartitionStateMachine$$controllerContext().correlationId().getAndIncrement(), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokers());
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this, partitionState){
                public static final long serialVersionUID;
                private final PartitionState targetState$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Error while moving some partitions to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                }
                {
                    this.targetState$1 = partitionState;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = throwable;
                }
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void kafka$controller$PartitionStateMachine$$handleStateChange(String string, int n, PartitionState partitionState, PartitionLeaderSelector partitionLeaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        if (!this.kafka$controller$PartitionStateMachine$$hasStarted().get()) throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s to %s failed because the partition state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, partitionState})));
        PartitionState partitionState2 = (PartitionState)this.partitionState().getOrElseUpdate((Object)topicAndPartition, (Function0)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final NonExistentPartition$ apply() {
                return NonExistentPartition$.MODULE$;
            }
        });
        try {
            PartitionState partitionState3 = partitionState;
            NewPartition$ newPartition$ = NewPartition$.MODULE$;
            PartitionState partitionState4 = partitionState3;
            if (!(newPartition$ != null ? !newPartition$.equals(partitionState4) : partitionState4 != null)) {
                this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentPartition$[]{NonExistentPartition$.MODULE$})), NewPartition$.MODULE$);
                this.assignReplicasToPartitions(string, n);
                this.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                String string2 = ((TraversableOnce)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition)).mkString(",");
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from NotExists to New with assigned replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, string2})));
                return;
            } else {
                OnlinePartition$ onlinePartition$ = OnlinePartition$.MODULE$;
                PartitionState partitionState5 = partitionState3;
                if (!(onlinePartition$ != null ? !onlinePartition$.equals(partitionState5) : partitionState5 != null)) {
                    this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$, OfflinePartition$.MODULE$})), OnlinePartition$.MODULE$);
                    PartitionState partitionState6 = (PartitionState)this.partitionState().apply((Object)topicAndPartition);
                    NewPartition$ newPartition$2 = NewPartition$.MODULE$;
                    PartitionState partitionState7 = partitionState6;
                    if (!(newPartition$2 != null ? !newPartition$2.equals(partitionState7) : partitionState7 != null)) {
                        this.initializeLeaderAndIsrForPartition(topicAndPartition);
                    } else {
                        OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                        PartitionState partitionState8 = partitionState6;
                        if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState8) : partitionState8 != null)) {
                            this.electLeaderForPartition(string, n, partitionLeaderSelector);
                        } else {
                            OnlinePartition$ onlinePartition$2 = OnlinePartition$.MODULE$;
                            PartitionState partitionState9 = partitionState6;
                            if (!(onlinePartition$2 != null ? !onlinePartition$2.equals(partitionState9) : partitionState9 != null)) {
                                this.electLeaderForPartition(string, n, partitionLeaderSelector);
                            }
                        }
                    }
                    this.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                    int n2 = ((LeaderIsrAndControllerEpoch)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().apply((Object)topicAndPartition)).leaderAndIsr().leader();
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s from %s to OnlinePartition with leader %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, this.partitionState().apply((Object)topicAndPartition), BoxesRunTime.boxToInteger((int)n2)})));
                    return;
                } else {
                    OfflinePartition$ offlinePartition$ = OfflinePartition$.MODULE$;
                    PartitionState partitionState10 = partitionState3;
                    if (!(offlinePartition$ != null ? !offlinePartition$.equals(partitionState10) : partitionState10 != null)) {
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewPartition$.MODULE$, OnlinePartition$.MODULE$})), OfflinePartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from Online to Offline").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
                        this.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                        return;
                    } else {
                        NonExistentPartition$ nonExistentPartition$ = NonExistentPartition$.MODULE$;
                        PartitionState partitionState11 = partitionState3;
                        if (nonExistentPartition$ != null ? !nonExistentPartition$.equals(partitionState11) : partitionState11 != null) throw new MatchError((Object)partitionState3);
                        this.assertValidPreviousStates(topicAndPartition, (Seq<PartitionState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflinePartition$[]{OfflinePartition$.MODULE$})), NonExistentPartition$.MODULE$);
                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed partition %s state from Offline to NotExists").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
                        this.partitionState().put((Object)topicAndPartition, (Object)NonExistentPartition$.MODULE$);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change for partition %s from %s to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition, partitionState2, partitionState})), throwable);
        }
    }

    public PartitionLeaderSelector handleStateChanges$default$3() {
        return this.noOpPartitionLeaderSelector();
    }

    private void initializePartitionState() {
        ((IterableLike)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<PartitionState> apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22;
                block2: {
                    Option option;
                    block7: {
                        Option option2;
                        block5: {
                            TopicAndPartition topicAndPartition;
                            block3: {
                                boolean bl;
                                block6: {
                                    block4: {
                                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                                        TopicAndPartition topicAndPartition2;
                                        tuple22 = tuple2;
                                        if (tuple22 == null) break block2;
                                        topicAndPartition = topicAndPartition2 = (TopicAndPartition)tuple22._1();
                                        option = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                        if (!(option instanceof Some)) break block3;
                                        Some some = (Some)option;
                                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                        bl = this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch2.leaderAndIsr().leader()));
                                        if (!bl) break block4;
                                        option2 = this.$outer.partitionState().put((Object)topicAndPartition, (Object)OnlinePartition$.MODULE$);
                                        break block5;
                                    }
                                    if (bl) break block6;
                                    option2 = this.$outer.partitionState().put((Object)topicAndPartition, (Object)OfflinePartition$.MODULE$);
                                    break block5;
                                }
                                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                            }
                            None$ none$ = None$.MODULE$;
                            Option option3 = option;
                            if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                            option2 = this.$outer.partitionState().put((Object)topicAndPartition, (Object)NewPartition$.MODULE$);
                        }
                        return option2;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple22);
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
    }

    private void assertValidPreviousStates(TopicAndPartition topicAndPartition, Seq<PartitionState> seq, PartitionState partitionState) {
        if (seq.contains(this.partitionState().apply((Object)topicAndPartition))) {
            return;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Partition %s should be in the %s states before moving to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, seq.mkString(","), partitionState}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionState().apply((Object)topicAndPartition)}))).toString());
    }

    private void assignReplicasToPartitions(String string, int n) {
        Seq<Object> seq = ZkUtils$.MODULE$.getReplicasForPartition(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), string, n);
        this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$eq(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition(string, n)).$minus$greater(seq));
    }

    private void initializeLeaderAndIsrForPartition(TopicAndPartition topicAndPartition) {
        Seq seq = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
        Seq seq2 = (Seq)seq.filter((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(int n) {
                return this.apply$mcZI$sp(n);
            }

            public boolean apply$mcZI$sp(int n) {
                return this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)n));
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
        int n = seq2.size();
        if (n == 0) {
            String string = Predef$.MODULE$.augmentString("encountered error during state change of partition %s from New to Online, assigned replicas are [%s], live brokers are [%s]. No assigned replica is alive.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, seq.mkString(","), this.kafka$controller$PartitionStateMachine$$controllerContext().liveBrokerIds()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string).toString());
            throw new StateChangeFailedException(string);
        }
        this.debug((Function0<String>)new Serializable(this, topicAndPartition, seq2){
            public static final long serialVersionUID;
            private final TopicAndPartition topicAndPartition$1;
            private final Seq liveAssignedReplicas$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Live assigned replicas for partition %s are: [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.liveAssignedReplicas$1}));
            }
            {
                this.topicAndPartition$1 = topicAndPartition;
                this.liveAssignedReplicas$1 = seq;
            }
        });
        int n2 = BoxesRunTime.unboxToInt((Object)seq2.head());
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(new LeaderAndIsr(n2, (List<Object>)seq2.toList()), this.kafka$controller$PartitionStateMachine$$controller.epoch());
        this.debug((Function0<String>)new Serializable(this, topicAndPartition, leaderIsrAndControllerEpoch){
            public static final long serialVersionUID;
            private final TopicAndPartition topicAndPartition$1;
            private final LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Initializing leader and isr for partition %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicAndPartition$1, this.leaderIsrAndControllerEpoch$1}));
            }
            {
                this.topicAndPartition$1 = topicAndPartition;
                this.leaderIsrAndControllerEpoch$1 = leaderIsrAndControllerEpoch;
            }
        });
        try {
            ZkUtils$.MODULE$.createPersistentPath(this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topicAndPartition.topic(), topicAndPartition.partition()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderIsrAndControllerEpoch.leaderAndIsr(), this.kafka$controller$PartitionStateMachine$$controller.epoch()));
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)topicAndPartition, (Object)leaderIsrAndControllerEpoch);
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)seq2, topicAndPartition.topic(), topicAndPartition.partition(), leaderIsrAndControllerEpoch, (Seq<Object>)seq);
            return;
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = (LeaderIsrAndControllerEpoch)ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), topicAndPartition.topic(), topicAndPartition.partition()).get();
            String string = Predef$.MODULE$.augmentString("encountered error while changing partition %s's state from New to Online since LeaderAndIsr path already exists with value %s and controller epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, leaderIsrAndControllerEpoch2.leaderAndIsr().toString(), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch2.controllerEpoch())}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string).toString());
            throw new StateChangeFailedException(string);
        }
    }

    public void electLeaderForPartition(String string, int n, PartitionLeaderSelector partitionLeaderSelector) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d started leader election for partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), topicAndPartition})));
        try {
            Seq seq;
            LeaderAndIsr leaderAndIsr;
            block6: {
                Tuple2<LeaderAndIsr, Seq<Object>> tuple2;
                block7: {
                    Tuple2<Object, Object> tuple22;
                    boolean bl = false;
                    leaderAndIsr = null;
                    seq = (Seq)Seq$.MODULE$.empty();
                    while (true) {
                        if (bl) break block6;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = this.getLeaderIsrAndEpochOrThrowException(string, n);
                        LeaderAndIsr leaderAndIsr2 = leaderIsrAndControllerEpoch.leaderAndIsr();
                        int n2 = leaderIsrAndControllerEpoch.controllerEpoch();
                        if (n2 > this.kafka$controller$PartitionStateMachine$$controller.epoch()) {
                            String string2 = Predef$.MODULE$.augmentString("aborted leader election for partition [%s,%d] since the LeaderAndIsr path was already written by another controller. This probably means that the current controller %d went through a soft failure and another controller was elected with epoch %d.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)n2)}));
                            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string2).toString());
                            throw new StateChangeFailedException(string2);
                        }
                        tuple2 = partitionLeaderSelector.selectLeader(topicAndPartition, leaderAndIsr2);
                        if (tuple2 == null) break block7;
                        Tuple2 tuple23 = new Tuple2(tuple2._1(), tuple2._2());
                        LeaderAndIsr leaderAndIsr3 = (LeaderAndIsr)tuple23._1();
                        Seq seq2 = (Seq)tuple23._2();
                        tuple22 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.kafka$controller$PartitionStateMachine$$zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(string, n), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr3, this.kafka$controller$PartitionStateMachine$$controller.epoch()), leaderAndIsr2.zkVersion());
                        if (tuple22 == null) break;
                        Tuple2 tuple24 = new Tuple2(tuple22._1(), tuple22._2());
                        boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple24._1());
                        int n3 = tuple24._2$mcI$sp();
                        leaderAndIsr = leaderAndIsr3;
                        leaderAndIsr.zkVersion_$eq(n3);
                        bl = bl2;
                        seq = seq2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.kafka$controller$PartitionStateMachine$$controller.epoch());
            this.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().put((Object)new TopicAndPartition(string, n), (Object)leaderIsrAndControllerEpoch);
            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d elected leader %d for Offline partition %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leader()), topicAndPartition})));
            Seq seq3 = (Seq)this.kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)new TopicAndPartition(string, n));
            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)seq, string, n, leaderIsrAndControllerEpoch, (Seq<Object>)seq3);
        }
        catch (Throwable throwable) {
            String string3 = Predef$.MODULE$.augmentString("encountered error while electing leader for partition %s due to: %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, throwable.getMessage()}));
            this.stateChangeLogger().error((Object)new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$PartitionStateMachine$$controller.epoch())}))).append((Object)string3).toString());
            throw new StateChangeFailedException(string3, throwable);
        }
        catch (NoReplicaOnlineException noReplicaOnlineException) {
            throw noReplicaOnlineException;
        }
        catch (LeaderElectionNotNeededException leaderElectionNotNeededException) {
            // empty catch block
        }
        this.debug((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final PartitionStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("After leader election, leader cache is updated to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$PartitionStateMachine$$controllerContext().partitionLeadershipInfo().map((Function1)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> apply(Tuple2<TopicAndPartition, LeaderIsrAndControllerEpoch> tuple2) {
                        return new Tuple2(tuple2._1(), tuple2._2());
                    }
                }, Map$.MODULE$.canBuildFrom())}));
            }
            {
                if (partitionStateMachine == null) {
                    throw new NullPointerException();
                }
                this.$outer = partitionStateMachine;
            }
        });
    }

    private java.util.List<String> registerTopicChangeListener() {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerTopicsPath(), (IZkChildListener)new TopicChangeListener(this));
    }

    public java.util.List<String> registerPartitionChangeListener(String string) {
        return this.kafka$controller$PartitionStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.getTopicPath(string), (IZkChildListener)new PartitionChangeListener(this, string));
    }

    private LeaderIsrAndControllerEpoch getLeaderIsrAndEpochOrThrowException(String string, int n) {
        TopicAndPartition topicAndPartition = new TopicAndPartition(string, n);
        Option<LeaderIsrAndControllerEpoch> option = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$PartitionStateMachine$$zkClient(), string, n);
        if (option instanceof Some) {
            return (LeaderIsrAndControllerEpoch)((Some)option).x();
        }
        None$ none$ = None$.MODULE$;
        Option<LeaderIsrAndControllerEpoch> option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            String string2 = Predef$.MODULE$.augmentString("LeaderAndIsr information doesn't exist for partition %s in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicAndPartition, this.partitionState().apply((Object)topicAndPartition)}));
            throw new StateChangeFailedException(string2);
        }
        throw new MatchError(option);
    }

    public PartitionStateMachine(KafkaController kafkaController) {
        this.kafka$controller$PartitionStateMachine$$controller = kafkaController;
        Logging$class.$init$(this);
        this.kafka$controller$PartitionStateMachine$$controllerContext = kafkaController.controllerContext();
        this.controllerId = kafkaController.config().brokerId();
        this.kafka$controller$PartitionStateMachine$$zkClient = this.kafka$controller$PartitionStateMachine$$controllerContext().zkClient();
        this.partitionState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(kafkaController.controllerContext(), (Function3<Object, RequestOrResponse, Function1<RequestOrResponse, BoxedUnit>, BoxedUnit>)new $anonfun$2(this), this.controllerId(), kafkaController.clientId());
        this.kafka$controller$PartitionStateMachine$$hasStarted = new AtomicBoolean(false);
        this.noOpPartitionLeaderSelector = new NoOpLeaderSelector(this.kafka$controller$PartitionStateMachine$$controllerContext());
        this.logIdent_$eq(new StringBuilder().append((Object)"[Partition state machine on Controller ").append((Object)BoxesRunTime.boxToInteger((int)this.controllerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class TopicChangeListener
    implements IZkChildListener,
    Logging {
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            TopicChangeListener topicChangeListener = this;
            synchronized (topicChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> function0) {
            Logging$class.trace(this, function0);
        }

        @Override
        public Object trace(Function0<Throwable> function0) {
            return Logging$class.trace(this, function0);
        }

        @Override
        public void trace(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.trace(this, function0, function02);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> function0) {
            Logging$class.swallowTrace(this, function0);
        }

        @Override
        public void debug(Function0<String> function0) {
            Logging$class.debug(this, function0);
        }

        @Override
        public Object debug(Function0<Throwable> function0) {
            return Logging$class.debug(this, function0);
        }

        @Override
        public void debug(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.debug(this, function0, function02);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> function0) {
            Logging$class.swallowDebug(this, function0);
        }

        @Override
        public void info(Function0<String> function0) {
            Logging$class.info(this, function0);
        }

        @Override
        public Object info(Function0<Throwable> function0) {
            return Logging$class.info(this, function0);
        }

        @Override
        public void info(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.info(this, function0, function02);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> function0) {
            Logging$class.swallowInfo(this, function0);
        }

        @Override
        public void warn(Function0<String> function0) {
            Logging$class.warn(this, function0);
        }

        @Override
        public Object warn(Function0<Throwable> function0) {
            return Logging$class.warn(this, function0);
        }

        @Override
        public void warn(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.warn(this, function0, function02);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> function0) {
            Logging$class.swallowWarn(this, function0);
        }

        @Override
        public void swallow(Function0<BoxedUnit> function0) {
            Logging$class.swallow(this, function0);
        }

        @Override
        public void error(Function0<String> function0) {
            Logging$class.error(this, function0);
        }

        @Override
        public Object error(Function0<Throwable> function0) {
            return Logging$class.error(this, function0);
        }

        @Override
        public void error(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.error(this, function0, function02);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> function0) {
            Logging$class.swallowError(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0) {
            Logging$class.fatal(this, function0);
        }

        @Override
        public Object fatal(Function0<Throwable> function0) {
            return Logging$class.fatal(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, java.util.List<String> list) throws Exception {
            Object object = this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                BoxedUnit boxedUnit;
                if (this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$hasStarted().get()) {
                    this.liftedTree1$1(string, list);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer() {
            return this.$outer;
        }

        private final void liftedTree1$1(String string, java.util.List list) {
            try {
                this.debug((Function0<String>)new Serializable(this, string, list){
                    public static final long serialVersionUID;
                    private final String parentPath$1;
                    private final java.util.List children$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Topic change listener fired for path %s with children %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.children$1).mkString(",")}));
                    }
                    {
                        this.parentPath$1 = string;
                        this.children$1 = list;
                    }
                });
                scala.collection.immutable.Set set = JavaConversions$.MODULE$.asBuffer(list).toSet();
                scala.collection.immutable.Set set2 = (scala.collection.immutable.Set)set.$minus$minus(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics());
                scala.collection.immutable.Set set3 = (scala.collection.immutable.Set)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics().$minus$minus((GenTraversableOnce)set);
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().allTopics_$eq((scala.collection.immutable.Set<String>)set);
                Map<TopicAndPartition, Seq<Object>> map = ZkUtils$.MODULE$.getReplicaAssignmentForTopics(this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$zkClient(), (Seq<String>)set2.toSeq());
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment_$eq((Map<TopicAndPartition, Seq<Object>>)((Map)this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, set3){
                    public static final long serialVersionUID;
                    private final scala.collection.immutable.Set deletedTopics$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                        return !this.deletedTopics$1.contains((Object)((TopicAndPartition)tuple2._1()).topic());
                    }
                    {
                        this.deletedTopics$1 = set;
                    }
                })));
                this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().partitionReplicaAssignment().$plus$plus$eq(map);
                this.info((Function0<String>)new Serializable(this, set2, set3, map){
                    public static final long serialVersionUID;
                    private final scala.collection.immutable.Set newTopics$1;
                    private final scala.collection.immutable.Set deletedTopics$1;
                    private final Map addedPartitionReplicaAssignment$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("New topics: [%s], deleted topics: [%s], new partition replica assignment [%s]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopics$1, this.deletedTopics$1, this.addedPartitionReplicaAssignment$1}));
                    }
                    {
                        this.newTopics$1 = set;
                        this.deletedTopics$1 = set2;
                        this.addedPartitionReplicaAssignment$1 = map;
                    }
                });
                if (set2.size() > 0) {
                    this.kafka$controller$PartitionStateMachine$TopicChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controller.onNewTopicCreation((scala.collection.immutable.Set<String>)set2, (scala.collection.immutable.Set<TopicAndPartition>)map.keySet().toSet());
                }
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Error while handling new topic";
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID;
                    private final Throwable e$3;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = throwable;
                    }
                });
            }
        }

        public TopicChangeListener(PartitionStateMachine partitionStateMachine) {
            if (partitionStateMachine == null) {
                throw new NullPointerException();
            }
            this.$outer = partitionStateMachine;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[TopicChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)partitionStateMachine.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class PartitionChangeListener
    implements IZkChildListener,
    Logging {
        public final PartitionStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            PartitionChangeListener partitionChangeListener = this;
            synchronized (partitionChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> function0) {
            Logging$class.trace(this, function0);
        }

        @Override
        public Object trace(Function0<Throwable> function0) {
            return Logging$class.trace(this, function0);
        }

        @Override
        public void trace(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.trace(this, function0, function02);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> function0) {
            Logging$class.swallowTrace(this, function0);
        }

        @Override
        public void debug(Function0<String> function0) {
            Logging$class.debug(this, function0);
        }

        @Override
        public Object debug(Function0<Throwable> function0) {
            return Logging$class.debug(this, function0);
        }

        @Override
        public void debug(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.debug(this, function0, function02);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> function0) {
            Logging$class.swallowDebug(this, function0);
        }

        @Override
        public void info(Function0<String> function0) {
            Logging$class.info(this, function0);
        }

        @Override
        public Object info(Function0<Throwable> function0) {
            return Logging$class.info(this, function0);
        }

        @Override
        public void info(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.info(this, function0, function02);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> function0) {
            Logging$class.swallowInfo(this, function0);
        }

        @Override
        public void warn(Function0<String> function0) {
            Logging$class.warn(this, function0);
        }

        @Override
        public Object warn(Function0<Throwable> function0) {
            return Logging$class.warn(this, function0);
        }

        @Override
        public void warn(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.warn(this, function0, function02);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> function0) {
            Logging$class.swallowWarn(this, function0);
        }

        @Override
        public void swallow(Function0<BoxedUnit> function0) {
            Logging$class.swallow(this, function0);
        }

        @Override
        public void error(Function0<String> function0) {
            Logging$class.error(this, function0);
        }

        @Override
        public Object error(Function0<Throwable> function0) {
            return Logging$class.error(this, function0);
        }

        @Override
        public void error(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.error(this, function0, function02);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> function0) {
            Logging$class.swallowError(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0) {
            Logging$class.fatal(this, function0);
        }

        @Override
        public Object fatal(Function0<Throwable> function0) {
            return Logging$class.fatal(this, function0);
        }

        @Override
        public void fatal(Function0<String> function0, Function0<Throwable> function02) {
            Logging$class.fatal(this, function0, function02);
        }

        public void handleChildChange(String string, java.util.List<String> list) throws Exception {
            Object object = this.kafka$controller$PartitionStateMachine$PartitionChangeListener$$$outer().kafka$controller$PartitionStateMachine$$controllerContext().controllerLock();
            synchronized (object) {
                return;
            }
        }

        public PartitionStateMachine kafka$controller$PartitionStateMachine$PartitionChangeListener$$$outer() {
            return this.$outer;
        }

        public PartitionChangeListener(PartitionStateMachine partitionStateMachine, String string) {
            if (partitionStateMachine == null) {
                throw new NullPointerException();
            }
            this.$outer = partitionStateMachine;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[Controller ").append((Object)BoxesRunTime.boxToInteger((int)partitionStateMachine.kafka$controller$PartitionStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

