/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.IOException;
import kafka.api.FetchRequest;
import kafka.api.FetchResponse;
import kafka.api.FetchResponse$;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.OffsetResponse;
import kafka.api.OffsetResponse$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig$;
import kafka.consumer.FetchRequestAndResponseStats;
import kafka.consumer.FetchRequestAndResponseStatsRegistry$;
import kafka.consumer.SimpleConsumer$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.Receive;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011abU5na2,7i\u001c8tk6,'O\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u0011-A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\b\u0019><w-\u001b8h!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011u\u0001!Q1A\u0005\u0002y\tA\u0001[8tiV\tq\u0004\u0005\u0002!G9\u0011q#I\u0005\u0003Ea\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0013&\u0005\u0019\u0019FO]5oO*\u0011!\u0005\u0007\u0005\tO\u0001\u0011\t\u0011)A\u0005?\u0005)\u0001n\\:uA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0003q_J$X#A\u0016\u0011\u0005]a\u0013BA\u0017\u0019\u0005\rIe\u000e\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005W\u0005)\u0001o\u001c:uA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!&A\u0005t_RKW.Z8vi\"A1\u0007\u0001B\u0001B\u0003%1&\u0001\u0006t_RKW.Z8vi\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAK\u0001\u000bEV4g-\u001a:TSj,\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0017\t,hMZ3s'&TX\r\t\u0005\ts\u0001\u0011)\u0019!C\u0001=\u0005A1\r\\5f]RLE\r\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003 \u0003%\u0019G.[3oi&#\u0007\u0005C\u0003>\u0001\u0011\u0005a(\u0001\u0004=S:LGO\u0010\u000b\u0007\u007f\u0005\u00135\tR#\u0011\u0005\u0001\u0003Q\"\u0001\u0002\t\u000bua\u0004\u0019A\u0010\t\u000b%b\u0004\u0019A\u0016\t\u000bEb\u0004\u0019A\u0016\t\u000bUb\u0004\u0019A\u0016\t\u000beb\u0004\u0019A\u0010\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\u0006!An\\2l+\u0005A\u0001B\u0002&\u0001A\u0003%\u0001\"A\u0003m_\u000e\\\u0007\u0005C\u0004M\u0001\t\u0007I\u0011B'\u0002\u001f\tdwnY6j]\u001e\u001c\u0005.\u00198oK2,\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#\u0012\tqA\\3uo>\u00148.\u0003\u0002T!\ny!\t\\8dW&twm\u00115b]:,G\u000e\u0003\u0004V\u0001\u0001\u0006IAT\u0001\u0011E2|7m[5oO\u000eC\u0017M\u001c8fY\u0002Bqa\u0016\u0001C\u0002\u0013\u0005a$\u0001\u0006ce>\\WM]%oM>Da!\u0017\u0001!\u0002\u0013y\u0012a\u00032s_.,'/\u00138g_\u0002Bqa\u0017\u0001C\u0002\u0013%A,\u0001\u000fgKR\u001c\u0007NU3rk\u0016\u001cH/\u00118e%\u0016\u001c\bo\u001c8tKN#\u0018\r^:\u0016\u0003u\u0003\"\u0001\u00110\n\u0005}\u0013!\u0001\b$fi\u000eD'+Z9vKN$\u0018I\u001c3SKN\u0004xN\\:f'R\fGo\u001d\u0005\u0007C\u0002\u0001\u000b\u0011B/\u0002;\u0019,Go\u00195SKF,Xm\u001d;B]\u0012\u0014Vm\u001d9p]N,7\u000b^1ug\u0002BQa\u0019\u0001\u0005\n\u0011\fqaY8o]\u0016\u001cG\u000fF\u0001O\u0011\u00151\u0007\u0001\"\u0003h\u0003)!\u0017n]2p]:,7\r\u001e\u000b\u0002QB\u0011q#[\u0005\u0003Ub\u0011A!\u00168ji\")A\u000e\u0001C\u0005O\u0006I!/Z2p]:,7\r\u001e\u0005\u0006]\u0002!\taZ\u0001\u0006G2|7/\u001a\u0005\u0006a\u0002!I!]\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0002skB\u0011qj]\u0005\u0003iB\u0013qAU3dK&4X\rC\u0003w_\u0002\u0007q/A\u0004sKF,Xm\u001d;\u0011\u0005a\\X\"A=\u000b\u0005i$\u0011aA1qS&\u0011A0\u001f\u0002\u0012%\u0016\fX/Z:u\u001fJ\u0014Vm\u001d9p]N,\u0007\"\u0002@\u0001\t\u0003y\u0018\u0001B:f]\u0012$B!!\u0001\u0002\bA\u0019\u00010a\u0001\n\u0007\u0005\u0015\u0011PA\u000bU_BL7-T3uC\u0012\fG/\u0019*fgB|gn]3\t\rYl\b\u0019AA\u0005!\rA\u00181B\u0005\u0004\u0003\u001bI(\u0001\u0006+pa&\u001cW*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\u000b\u0019,Go\u00195\u0015\t\u0005U\u00111\u0004\t\u0004q\u0006]\u0011bAA\rs\nia)\u001a;dQJ+7\u000f]8og\u0016DqA^A\b\u0001\u0004\ti\u0002E\u0002y\u0003?I1!!\tz\u000511U\r^2i%\u0016\fX/Z:u\u0011\u001d\t)\u0003\u0001C\u0001\u0003O\t\u0001cZ3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3\u0015\t\u0005%\u0012q\u0006\t\u0004q\u0006-\u0012bAA\u0017s\nqqJ\u001a4tKR\u0014Vm\u001d9p]N,\u0007b\u0002<\u0002$\u0001\u0007\u0011\u0011\u0007\t\u0004q\u0006M\u0012bAA\u001bs\niqJ\u001a4tKR\u0014V-];fgRDa!!\u000f\u0001\t\u00139\u0017aE4fi>\u0013X*Y6f\u0007>tg.Z2uS>t\u0007bBA\u001f\u0001\u0011\u0005\u0011qH\u0001\u0017K\u0006\u0014H.[3ti>\u0013H*\u0019;fgR|eMZ:fiRA\u0011\u0011IA$\u0003/\nY\u0006E\u0002\u0018\u0003\u0007J1!!\u0012\u0019\u0005\u0011auN\\4\t\u0011\u0005%\u00131\ba\u0001\u0003\u0017\n\u0011\u0003^8qS\u000e\fe\u000e\u001a)beRLG/[8o!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)\t\u000511m\\7n_:LA!!\u0016\u0002P\t\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005e\u00131\ba\u0001\u0003\u0003\n\u0001#Z1sY&,7\u000f^(s\u0019\u0006$Xm\u001d;\t\u000f\u0005u\u00131\ba\u0001W\u0005Q1m\u001c8tk6,'/\u00133)\u0007\u0001\t\t\u0007E\u0002\u0012\u0003GJ1!!\u001a\u0013\u0005)!\bN]3bIN\fg-\u001a")
public class SimpleConsumer
implements Logging {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private final String clientId;
    private final Object lock;
    private final BlockingChannel blockingChannel;
    private final String brokerInfo;
    private final FetchRequestAndResponseStats fetchRequestAndResponseStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public String clientId() {
        return this.clientId;
    }

    private Object lock() {
        return this.lock;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public String brokerInfo() {
        return this.brokerInfo;
    }

    private FetchRequestAndResponseStats fetchRequestAndResponseStats() {
        return this.fetchRequestAndResponseStats;
    }

    private BlockingChannel connect() {
        this.close();
        this.blockingChannel().connect();
        return this.blockingChannel();
    }

    private void disconnect() {
        if (this.blockingChannel().isConnected()) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final SimpleConsumer $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Disconnecting from ").append((Object)this.$outer.host()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.port())).toString();
                }
                {
                    if (simpleConsumer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = simpleConsumer;
                }
            });
            this.blockingChannel().disconnect();
        }
    }

    private void reconnect() {
        this.disconnect();
        this.connect();
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            return;
        }
    }

    public final Receive kafka$consumer$SimpleConsumer$$sendRequest(RequestOrResponse requestOrResponse) {
        Object object = this.lock();
        synchronized (object) {
            this.getOrMakeConnection();
            ObjectRef objectRef = new ObjectRef(null);
            this.liftedTree1$1(requestOrResponse, objectRef);
            Receive receive = (Receive)objectRef.elem;
            return receive;
        }
    }

    public TopicMetadataResponse send(TopicMetadataRequest topicMetadataRequest) {
        Receive receive = this.kafka$consumer$SimpleConsumer$$sendRequest(topicMetadataRequest);
        return TopicMetadataResponse$.MODULE$.readFrom(receive.buffer());
    }

    public FetchResponse fetch(FetchRequest fetchRequest) {
        ObjectRef objectRef = new ObjectRef(null);
        KafkaTimer kafkaTimer = this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.brokerInfo()).requestTimer();
        KafkaTimer kafkaTimer2 = this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestTimer();
        kafkaTimer2.time(new Serializable(this, fetchRequest, objectRef, kafkaTimer){
            public static final long serialVersionUID;
            private final SimpleConsumer $outer;
            public final FetchRequest request$2;
            public final ObjectRef response$2;
            private final KafkaTimer specificTimer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.specificTimer$1.time(new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$fetch$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.response$2.elem = this.$outer.kafka$consumer$SimpleConsumer$$anonfun$$$outer().kafka$consumer$SimpleConsumer$$sendRequest(this.$outer.request$2);
                    }
                    {
                        if (var1_1 == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = var1_1;
                    }
                });
            }

            public SimpleConsumer kafka$consumer$SimpleConsumer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if (simpleConsumer == null) {
                    throw new NullPointerException();
                }
                this.$outer = simpleConsumer;
                this.request$2 = fetchRequest;
                this.response$2 = objectRef;
                this.specificTimer$1 = kafkaTimer;
            }
        });
        FetchResponse fetchResponse = FetchResponse$.MODULE$.readFrom(((Receive)objectRef.elem).buffer());
        int n = fetchResponse.sizeInBytes();
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseStats(this.brokerInfo()).requestSizeHist().update(n);
        this.fetchRequestAndResponseStats().getFetchRequestAndResponseAllBrokersStats().requestSizeHist().update(n);
        return fetchResponse;
    }

    public OffsetResponse getOffsetsBefore(OffsetRequest offsetRequest) {
        return OffsetResponse$.MODULE$.readFrom(this.kafka$consumer$SimpleConsumer$$sendRequest(offsetRequest).buffer());
    }

    private void getOrMakeConnection() {
        if (!this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    public long earliestOrLatestOffset(TopicAndPartition topicAndPartition, long l, int n) {
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc((Object)topicAndPartition).$minus$greater((Object)new PartitionOffsetRequestInfo(l, 1))}));
        String string = this.clientId();
        int n2 = n;
        short s = OffsetRequest$.MODULE$.apply$default$2();
        int n3 = OffsetRequest$.MODULE$.apply$default$3();
        OffsetRequest offsetRequest = new OffsetRequest((Map<TopicAndPartition, PartitionOffsetRequestInfo>)map, s, n3, string, n2);
        PartitionOffsetsResponse partitionOffsetsResponse = (PartitionOffsetsResponse)this.getOffsetsBefore(offsetRequest).partitionErrorAndOffsets().apply((Object)topicAndPartition);
        short s2 = partitionOffsetsResponse.error();
        if (BoxesRunTime.equals((Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()), (Object)BoxesRunTime.boxToShort((short)s2))) {
            long l2 = BoxesRunTime.unboxToLong((Object)partitionOffsetsResponse.offsets().head());
            return l2;
        }
        throw ErrorMapping$.MODULE$.exceptionFor(partitionOffsetsResponse.error());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(RequestOrResponse requestOrResponse, ObjectRef objectRef) {
        try {
            this.blockingChannel().send(requestOrResponse);
            objectRef.elem = this.blockingChannel().receive();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Reconnect due to socket error: ";
                }
            }, (Function0<Throwable>)new Serializable(this, iOException){
                public static final long serialVersionUID;
                private final IOException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = iOException;
                }
            });
            try {
                this.reconnect();
                this.blockingChannel().send(requestOrResponse);
                objectRef.elem = this.blockingChannel().receive();
                return;
            }
            catch (IOException iOException2) {
                this.disconnect();
                throw iOException2;
            }
        }
    }

    public SimpleConsumer(String string, int n, int n2, int n3, String string2) {
        this.host = string;
        this.port = n;
        this.soTimeout = n2;
        this.bufferSize = n3;
        this.clientId = string2;
        Logging$class.$init$(this);
        ConsumerConfig$.MODULE$.validateClientId(string2);
        this.lock = new Object();
        this.blockingChannel = new BlockingChannel(string, n, n3, BlockingChannel$.MODULE$.UseDefaultBufferSize(), n2);
        this.brokerInfo = Predef$.MODULE$.augmentString("host_%s-port_%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n)}));
        this.fetchRequestAndResponseStats = FetchRequestAndResponseStatsRegistry$.MODULE$.getFetchRequestAndResponseStats(string2);
    }
}

