/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotLeaderForPartitionException;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.HighwaterMarkCheckpoint;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tEg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011#\u0002\u0001\t!Ya\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0003\u0002\u000f5,GO]5dg&\u00111\u0004\u0007\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\bCA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"aC*dC2\fwJ\u00196fGRD\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001J\u0001\u0006i>\u0004\u0018nY\u000b\u0002KA\u0011a%\u000b\b\u0003;\u001dJ!\u0001\u000b\u0010\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QyA\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u0011=\u0002!Q1A\u0005\u0002A\n1\u0002]1si&$\u0018n\u001c8JIV\t\u0011\u0007\u0005\u0002\u001ee%\u00111G\b\u0002\u0004\u0013:$\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0011]\u0002!\u00111A\u0005\u0002A\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011!I\u0004A!a\u0001\n\u0003Q\u0014!\u0006:fa2L7-\u0019;j_:4\u0015m\u0019;pe~#S-\u001d\u000b\u0003wy\u0002\"!\b\u001f\n\u0005ur\"\u0001B+oSRDqa\u0010\u001d\u0002\u0002\u0003\u0007\u0011'A\u0002yIEB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006K!M\u0001\u0013e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\u0005\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0003\u0011!\u0018.\\3\u0011\u0005E)\u0015B\u0001$\u0013\u0005\u0011!\u0016.\\3\t\u0011!\u0003!Q1A\u0005\u0002%\u000baB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001K!\tYe*D\u0001M\u0015\tiE!\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003K\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\"B*\u0001\t\u0003!\u0016A\u0002\u001fj]&$h\b\u0006\u0004V/bK&l\u0017\t\u0003-\u0002i\u0011A\u0001\u0005\u0006GI\u0003\r!\n\u0005\u0006_I\u0003\r!\r\u0005\u0006oI\u0003\r!\r\u0005\u0006\u0007J\u0003\r\u0001\u0012\u0005\u0006\u0011J\u0003\rA\u0013\u0005\b;\u0002\u0011\r\u0011\"\u00031\u00035awnY1m\u0005J|7.\u001a:JI\"1q\f\u0001Q\u0001\nE\na\u0002\\8dC2\u0014%o\\6fe&#\u0007\u0005C\u0004b\u0001\t\u0007I\u0011\u00022\u0002\u00151|w-T1oC\u001e,'/F\u0001d!\t!w-D\u0001f\u0015\t1G!A\u0002m_\u001eL!\u0001[3\u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0004k\u0001\u0001\u0006IaY\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0004m\u0001\t\u0007I\u0011B7\u0002+I,\u0007\u000f\\5dC\u001a+Go\u00195fe6\u000bg.Y4feV\ta\u000e\u0005\u0002L_&\u0011\u0001\u000f\u0014\u0002\u0016%\u0016\u0004H.[2b\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s\u0011\u0019\u0011\b\u0001)A\u0005]\u00061\"/\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0004u\u0001\t\u0007I\u0011B;\u0002\u0011i\\7\t\\5f]R,\u0012A\u001e\t\u0003ozl\u0011\u0001\u001f\u0006\u0003sj\f\u0001B_6dY&,g\u000e\u001e\u0006\u0003wr\fa!\u0013\u0019Ji\u0016\u001c'\"A?\u0002\u0007=\u0014x-\u0003\u0002\u0000q\nA!l[\"mS\u0016tG\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011\u0002<\u0002\u0013i\\7\t\\5f]R\u0004\u0003\"CA\u0004\u0001\u0001\u0007I\u0011AA\u0005\u0003IaW-\u00193feJ+\u0007\u000f\\5dC&#w\n\u001d;\u0016\u0005\u0005-\u0001\u0003B\u000f\u0002\u000eEJ1!a\u0004\u001f\u0005\u0019y\u0005\u000f^5p]\"I\u00111\u0003\u0001A\u0002\u0013\u0005\u0011QC\u0001\u0017Y\u0016\fG-\u001a:SKBd\u0017nY1JI>\u0003Ho\u0018\u0013fcR\u00191(a\u0006\t\u0013}\n\t\"!AA\u0002\u0005-\u0001\u0002CA\u000e\u0001\u0001\u0006K!a\u0003\u0002'1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u0012|\u0005\u000f\u001e\u0011\t\u0013\u0005}\u0001\u00011A\u0005\u0002\u0005\u0005\u0012AD5o'ft7MU3qY&\u001c\u0017m]\u000b\u0003\u0003G\u0001b!!\n\u0002,\u0005=RBAA\u0014\u0015\r\tICH\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0017\u0003O\u00111aU3u!\r1\u0016\u0011G\u0005\u0004\u0003g\u0011!a\u0002*fa2L7-\u0019\u0005\n\u0003o\u0001\u0001\u0019!C\u0001\u0003s\t!#\u001b8Ts:\u001c'+\u001a9mS\u000e\f7o\u0018\u0013fcR\u00191(a\u000f\t\u0013}\n)$!AA\u0002\u0005\r\u0002\u0002CA \u0001\u0001\u0006K!a\t\u0002\u001f%t7+\u001f8d%\u0016\u0004H.[2bg\u0002B\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\u0002%\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006l\u0015\r]\u000b\u0003\u0003\u000f\u0002b!EA%c\u0005=\u0012bAA&%\t!\u0001k\\8m\u0011!\ty\u0005\u0001Q\u0001\n\u0005\u001d\u0013aE1tg&<g.\u001a3SKBd\u0017nY1NCB\u0004\u0003\"CA*\u0001\t\u0007I\u0011BA+\u0003MaW-\u00193fe&\u001b(/\u00169eCR,Gj\\2l+\u0005A\u0001bBA-\u0001\u0001\u0006I\u0001C\u0001\u0015Y\u0016\fG-\u001a:JgJ,\u0006\u000fZ1uK2{7m\u001b\u0011\t\u0011\u0005u\u0003\u00011A\u0005\nA\n\u0011B_6WKJ\u001c\u0018n\u001c8\t\u0013\u0005\u0005\u0004\u00011A\u0005\n\u0005\r\u0014!\u0004>l-\u0016\u00148/[8o?\u0012*\u0017\u000fF\u0002<\u0003KB\u0001bPA0\u0003\u0003\u0005\r!\r\u0005\b\u0003S\u0002\u0001\u0015)\u00032\u0003)Q8NV3sg&|g\u000e\t\u0005\t\u0003[\u0002\u0001\u0019!C\u0005a\u0005YA.Z1eKJ,\u0005o\\2i\u0011%\t\t\b\u0001a\u0001\n\u0013\t\u0019(A\bmK\u0006$WM]#q_\u000eDw\fJ3r)\rY\u0014Q\u000f\u0005\t\u007f\u0005=\u0014\u0011!a\u0001c!9\u0011\u0011\u0010\u0001!B\u0013\t\u0014\u0001\u00047fC\u0012,'/\u00129pG\"\u0004\u0003\u0002CA?\u0001\u0001\u0007I\u0011\u0002\u0019\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"D\u0011\"!!\u0001\u0001\u0004%I!a!\u0002'\r|g\u000e\u001e:pY2,'/\u00129pG\"|F%Z9\u0015\u0007m\n)\t\u0003\u0005@\u0003\u007f\n\t\u00111\u00012\u0011\u001d\tI\t\u0001Q!\nE\n\u0001cY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u0011\t\u0013\u00055\u0005A1A\u0005\n\u0005=\u0015!E:uCR,7\t[1oO\u0016dunZ4feV\u0011\u0011\u0011\u0013\t\u0005\u0003'\u000bi*\u0004\u0002\u0002\u0016*!\u0011qSAM\u0003\u0015awn\u001a\u001bk\u0015\r\tY\n`\u0001\u0007CB\f7\r[3\n\t\u0005}\u0015Q\u0013\u0002\u0007\u0019><w-\u001a:\t\u0011\u0005\r\u0006\u0001)A\u0005\u0003#\u000b!c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3sA!9\u0011q\u0015\u0001\u0005\n\u0005%\u0016AD5t%\u0016\u0004H.[2b\u0019>\u001c\u0017\r\u001c\u000b\u0005\u0003W\u000b\t\fE\u0002\u001e\u0003[K1!a,\u001f\u0005\u001d\u0011un\u001c7fC:Dq!a-\u0002&\u0002\u0007\u0011'A\u0005sKBd\u0017nY1JI\"9\u0011q\u0017\u0001\u0005\u0002\u0005e\u0016!E5t+:$WM\u001d*fa2L7-\u0019;fIR\u0011\u00111\u0016\u0005\b\u0003{\u0003A\u0011AA`\u0003I9W\r^(s\u0007J,\u0017\r^3SKBd\u0017nY1\u0015\t\u0005=\u0012\u0011\u0019\u0005\n\u0003g\u000bY\f%AA\u0002EBq!!2\u0001\t\u0003\t9-\u0001\u0006hKR\u0014V\r\u001d7jG\u0006$B!!3\u0002LB)Q$!\u0004\u00020!I\u00111WAb!\u0003\u0005\r!\r\u0005\b\u0003\u001f\u0004A\u0011AAi\u0003QaW-\u00193feJ+\u0007\u000f\\5dC&3Gj\\2bYR\u0011\u0011\u0011\u001a\u0005\b\u0003+\u0004A\u0011AAl\u0003U\tG\r\u001a*fa2L7-Y%g\u001d>$X\t_5tiN$B!a\f\u0002Z\"A\u00111\\Aj\u0001\u0004\ty#A\u0004sKBd\u0017nY1\t\u000f\u0005}\u0007\u0001\"\u0001\u0002b\u0006\u0001\u0012m]:jO:,GMU3qY&\u001c\u0017m\u001d\u000b\u0003\u0003GAq!!:\u0001\t\u0003\t9/\u0001\u0006nC.,G*Z1eKJ$B\"a+\u0002j\u00065\u0018q^Ay\u0005\u0003Aq!a;\u0002d\u0002\u0007\u0011'\u0001\u0007d_:$(o\u001c7mKJLE\r\u0003\u0004$\u0003G\u0004\r!\n\u0005\u0007_\u0005\r\b\u0019A\u0019\t\u0011\u0005M\u00181\u001da\u0001\u0003k\f1\u0004\\3bI\u0016\u0014\u0018j\u001d:B]\u0012\u001cuN\u001c;s_2dWM]#q_\u000eD\u0007\u0003BA|\u0003{l!!!?\u000b\u0007\u0005mH!\u0001\u0006d_:$(o\u001c7mKJLA!a@\u0002z\nYB*Z1eKJL5O]!oI\u000e{g\u000e\u001e:pY2,'/\u00129pG\"DqAa\u0001\u0002d\u0002\u0007\u0011'A\u0007d_J\u0014X\r\\1uS>t\u0017\n\u001a\u0005\b\u0005\u000f\u0001A\u0011\u0001B\u0005\u00031i\u0017m[3G_2dwn^3s)9\tYKa\u0003\u0003\u000e\t=!\u0011\u0003B\n\u0005?Aq!a;\u0003\u0006\u0001\u0007\u0011\u0007\u0003\u0004$\u0005\u000b\u0001\r!\n\u0005\u0007_\t\u0015\u0001\u0019A\u0019\t\u0011\u0005M(Q\u0001a\u0001\u0003kD\u0001B!\u0006\u0003\u0006\u0001\u0007!qC\u0001\rC2Lg/\u001a'fC\u0012,'o\u001d\t\u0007\u0003K\tYC!\u0007\u0011\u0007Y\u0013Y\"C\u0002\u0003\u001e\t\u0011aA\u0011:pW\u0016\u0014\bb\u0002B\u0002\u0005\u000b\u0001\r!\r\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u0003})\b\u000fZ1uK2+\u0017\rZ3s\u0011^\u000be\u000eZ'bs\n,W\t\u001f9b]\u0012L5O\u001d\u000b\u0006w\t\u001d\"\u0011\u0006\u0005\b\u0003g\u0013\t\u00031\u00012\u0011!\u0011YC!\tA\u0002\t5\u0012AB8gMN,G\u000fE\u0002\u001e\u0005_I1A!\r\u001f\u0005\u0011auN\\4\t\u000f\tU\u0002\u0001\"\u0001\u00038\u0005q2\r[3dW\u0016sw.^4i%\u0016\u0004H.[2bgJ+\u0017m\u00195PM\u001a\u001cX\r\u001e\u000b\u0007\u0005s\u0011)E!\u0013\u0011\u000fu\u0011Y$a+\u0003@%\u0019!Q\b\u0010\u0003\rQ+\b\u000f\\33!\ri\"\u0011I\u0005\u0004\u0005\u0007r\"!B*i_J$\b\u0002\u0003B$\u0005g\u0001\rA!\f\u0002\u001dI,\u0017/^5sK\u0012|eMZ:fi\"9!1\nB\u001a\u0001\u0004\t\u0014\u0001\u0004:fcVL'/\u001a3BG.\u001c\bb\u0002B(\u0001\u0011%!\u0011K\u0001\u0017[\u0006L(-Z%oGJ,W.\u001a8u\u0019\u0016\fG-\u001a:I/R\u00191Ha\u0015\t\u0011\tU#Q\na\u0001\u0003_\tQ\u0002\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0007b\u0002B-\u0001\u0011\u0005!1L\u0001\u000f[\u0006L(-Z*ie&t7.S:s)\u0015Y$Q\fB1\u0011!\u0011yFa\u0016A\u0002\t5\u0012a\u0005:fa2L7-Y'bq2\u000bw\rV5nK6\u001b\b\u0002\u0003B2\u0005/\u0002\rA!\f\u0002+I,\u0007\u000f\\5dC6\u000b\u0007\u0010T1h\u001b\u0016\u001c8/Y4fg\"9!q\r\u0001\u0005\u0002\t%\u0014\u0001F4fi>+Ho\u00144Ts:\u001c'+\u001a9mS\u000e\f7\u000f\u0006\u0005\u0002$\t-$Q\u000eB9\u0011!\u0011)F!\u001aA\u0002\u0005=\u0002\u0002\u0003B8\u0005K\u0002\rA!\f\u0002!-,W\r]%o'ft7\rV5nK6\u001b\b\u0002\u0003B:\u0005K\u0002\rA!\f\u0002%-,W\r]%o'ft7-T3tg\u0006<Wm\u001d\u0005\b\u0005o\u0002A\u0011\u0001B=\u0003Y\t\u0007\u000f]3oI6+7o]1hKN$v\u000eT3bI\u0016\u0014H\u0003\u0002B>\u0005{\u0002r!\bB\u001e\u0005[\u0011i\u0003\u0003\u0005\u0003\u0000\tU\u0004\u0019\u0001BA\u0003!iWm]:bO\u0016\u001c\b\u0003\u0002BB\u0005\u0013k!A!\"\u000b\u0007\t\u001dE!A\u0004nKN\u001c\u0018mZ3\n\t\t-%Q\u0011\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u000f\t=\u0005\u0001\"\u0003\u0003\u0012\u0006IQ\u000f\u001d3bi\u0016L5O\u001d\u000b\u0004w\tM\u0005\u0002\u0003BK\u0005\u001b\u0003\r!a\t\u0002\r9,w/S:s\u0011\u001d\u0011I\n\u0001C!\u00057\u000ba!Z9vC2\u001cH\u0003BAV\u0005;C\u0001Ba(\u0003\u0018\u0002\u0007!\u0011U\u0001\u0005i\"\fG\u000fE\u0002\u001e\u0005GK1A!*\u001f\u0005\r\te.\u001f\u0005\b\u0005S\u0003A\u0011\tBV\u0003!A\u0017m\u001d5D_\u0012,G#A\u0019\t\u000f\t=\u0006\u0001\"\u0011\u00032\u0006AAo\\*ue&tw\rF\u0001&\u0011%\u0011)\fAI\u0001\n\u0003\u00119,\u0001\u000fhKR|%o\u0011:fCR,'+\u001a9mS\u000e\fG\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te&fA\u0019\u0003<.\u0012!Q\u0018\t\u0005\u0005\u007f\u0013I-\u0004\u0002\u0003B*!!1\u0019Bc\u0003%)hn\u00195fG.,GMC\u0002\u0003Hz\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011YM!1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0003P\u0002\t\n\u0011\"\u0001\u00038\u0006!r-\u001a;SKBd\u0017nY1%I\u00164\u0017-\u001e7uIE\u0002")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private int replicationFactor;
    public final Time kafka$cluster$Partition$$time;
    private final ReplicaManager replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager logManager;
    private final ReplicaFetcherManager replicaFetcherManager;
    private final ZkClient zkClient;
    private Option<Object> leaderReplicaIdOpt;
    private Set<Replica> inSyncReplicas;
    private final Pool<Object, Replica> assignedReplicaMap;
    private final Object leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private int leaderEpoch;
    private int controllerEpoch;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String string, Gauge<T> gauge) {
        return KafkaMetricsGroup$class.newGauge(this, string, gauge);
    }

    @Override
    public Meter newMeter(String string, String string2, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, string, string2, timeUnit);
    }

    @Override
    public Histogram newHistogram(String string, boolean bl) {
        return KafkaMetricsGroup$class.newHistogram(this, string, bl);
    }

    @Override
    public Timer newTimer(String string, TimeUnit timeUnit, TimeUnit timeUnit2) {
        return KafkaMetricsGroup$class.newTimer(this, string, timeUnit, timeUnit2);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Partition partition = this;
        synchronized (partition) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> function0) {
        Logging$class.trace(this, function0);
    }

    @Override
    public Object trace(Function0<Throwable> function0) {
        return Logging$class.trace(this, function0);
    }

    @Override
    public void trace(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.trace(this, function0, function02);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> function0) {
        Logging$class.swallowTrace(this, function0);
    }

    @Override
    public void debug(Function0<String> function0) {
        Logging$class.debug(this, function0);
    }

    @Override
    public Object debug(Function0<Throwable> function0) {
        return Logging$class.debug(this, function0);
    }

    @Override
    public void debug(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.debug(this, function0, function02);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> function0) {
        Logging$class.swallowDebug(this, function0);
    }

    @Override
    public void info(Function0<String> function0) {
        Logging$class.info(this, function0);
    }

    @Override
    public Object info(Function0<Throwable> function0) {
        return Logging$class.info(this, function0);
    }

    @Override
    public void info(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.info(this, function0, function02);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> function0) {
        Logging$class.swallowInfo(this, function0);
    }

    @Override
    public void warn(Function0<String> function0) {
        Logging$class.warn(this, function0);
    }

    @Override
    public Object warn(Function0<Throwable> function0) {
        return Logging$class.warn(this, function0);
    }

    @Override
    public void warn(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.warn(this, function0, function02);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> function0) {
        Logging$class.swallowWarn(this, function0);
    }

    @Override
    public void swallow(Function0<BoxedUnit> function0) {
        Logging$class.swallow(this, function0);
    }

    @Override
    public void error(Function0<String> function0) {
        Logging$class.error(this, function0);
    }

    @Override
    public Object error(Function0<Throwable> function0) {
        return Logging$class.error(this, function0);
    }

    @Override
    public void error(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.error(this, function0, function02);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> function0) {
        Logging$class.swallowError(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0) {
        Logging$class.fatal(this, function0);
    }

    @Override
    public Object fatal(Function0<Throwable> function0) {
        return Logging$class.fatal(this, function0);
    }

    @Override
    public void fatal(Function0<String> function0, Function0<Throwable> function02) {
        Logging$class.fatal(this, function0, function02);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int n) {
        this.replicationFactor = n;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public final int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ReplicaFetcherManager replicaFetcherManager() {
        return this.replicaFetcherManager;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> option) {
        this.leaderReplicaIdOpt = option;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> set) {
        this.inSyncReplicas = set;
    }

    private Pool<Object, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private Object leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public final int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    private void kafka$cluster$Partition$$zkVersion_$eq(int n) {
        this.kafka$cluster$Partition$$zkVersion = n;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int n) {
        this.leaderEpoch = n;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private boolean isReplicaLocal(int n) {
        return n == this.kafka$cluster$Partition$$localBrokerId();
    }

    public boolean isUnderReplicated() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Boolean bl = BoxesRunTime.boxToBoolean((this.inSyncReplicas().size() < this.replicationFactor() ? 1 : 0) != 0);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public Replica getOrCreateReplica(int n) {
        Option<Replica> option;
        block7: {
            Replica replica;
            block6: {
                Replica replica2;
                block5: {
                    Option<Replica> option2 = this.getReplica(n);
                    option = option2;
                    if (!(option instanceof Some)) break block5;
                    replica = (Replica)((Some)option).x();
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option3 = option;
                if (none$ != null ? !none$.equals(option3) : option3 != null) break block7;
                if (this.isReplicaLocal(n)) {
                    Log log = this.logManager().getOrCreateLog(this.topic(), this.partitionId());
                    long l = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(((HighwaterMarkCheckpoint)this.replicaManager().highWatermarkCheckpoints().apply((Object)log.dir().getParent())).read(this.topic(), this.partitionId())).min((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())));
                    Replica replica3 = new Replica(n, this, this.kafka$cluster$Partition$$time, l, (Option<Log>)new Some((Object)log));
                    replica2 = this.addReplicaIfNotExists(replica3);
                } else {
                    Replica replica4 = new Replica(n, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.init$default$4(), (Option<Log>)Replica$.MODULE$.init$default$5());
                    replica2 = this.addReplicaIfNotExists(replica4);
                }
                replica = (Replica)this.getReplica(n).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> getReplica(int n) {
        Replica replica = this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)n));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Object> option;
            block6: {
                Option<Replica> option2;
                option = this.leaderReplicaIdOpt();
                if (option instanceof Some) {
                    option2 = BoxesRunTime.unboxToInt((Object)((Some)option).x()) == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                    option2 = None$.MODULE$;
                }
                Option<Replica> option4 = option2;
                return option4;
            }
            throw new MatchError(option);
        }
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    public boolean makeLeader(int n, String string, int n2, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, int n3) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            if (this.leaderEpoch() >= leaderAndIsr.leaderEpoch()) {
                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d discarded the become-leader request with correlation id %d from controller %d epoch %d for partition [%s,%d] since current leader epoch %d is >= the request's leader epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), string, BoxesRunTime.boxToInteger((int)n2), BoxesRunTime.boxToInteger((int)this.leaderEpoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())})));
                return false;
            }
            this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
            this.replicaFetcherManager().removeFetcher(string, n2);
            scala.collection.immutable.Set set = ((TraversableOnce)leaderAndIsr.isr().map((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Replica apply(int n) {
                    return this.$outer.getOrCreateReplica(n);
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                }
            }, List$.MODULE$.canBuildFrom())).toSet();
            this.assignedReplicas().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Replica replica) {
                    if (replica.brokerId() != this.$outer.kafka$cluster$Partition$$localBrokerId()) {
                        replica.logEndOffset_$eq(ReplicaManager$.MODULE$.UnknownLogEndOffset());
                    }
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                }
            });
            this.inSyncReplicas_$eq((Set<Replica>)set);
            this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
            this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
            this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())));
            this.maybeIncrementLeaderHW((Replica)this.getReplica(this.getReplica$default$1()).get());
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean makeFollower(int n, String string, int n2, LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch, Set<Broker> set, int n3) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option option;
            block9: {
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                if (this.leaderEpoch() >= leaderAndIsr.leaderEpoch()) {
                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Broker %d discarded the become-follower request with correlation id %d from controller %d epoch %d for partition [%s,%d] since current leader epoch %d is >= the request's leader epoch %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), string, BoxesRunTime.boxToInteger((int)n2), BoxesRunTime.boxToInteger((int)this.leaderEpoch()), BoxesRunTime.boxToInteger((int)leaderAndIsr.leaderEpoch())})));
                    return false;
                }
                this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                Replica replica = this.getOrCreateReplica(this.getOrCreateReplica$default$1());
                int n4 = leaderAndIsr.leader();
                option = set.find((Function1)new Serializable(this, n4){
                    public static final long serialVersionUID;
                    private final int newLeaderBrokerId$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Broker broker) {
                        return broker.id() == this.newLeaderBrokerId$1;
                    }
                    {
                        this.newLeaderBrokerId$1 = n;
                    }
                });
                if (option instanceof Some) {
                    this.replicaFetcherManager().removeFetcher(string, n2);
                    ((Log)replica.log().get()).truncateTo(replica.highWatermark());
                    this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
                    this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                    this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)n4)));
                    if (this.replicaManager().isShuttingDown().get()) {
                        this.stateChangeLogger().trace((Object)new StringBuilder().append((Object)"Broker %d ignored the become-follower state change with correlation id %d from ").append((Object)Predef$.MODULE$.augmentString(" controller %d epoch %d since it is shutting down").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch())}))).toString());
                    } else {
                        this.replicaFetcherManager().addFetcher(string, n2, replica.logEndOffset(), (Broker)((Some)option).x());
                    }
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                    this.stateChangeLogger().trace((Object)new StringBuilder().append((Object)"Broker %d aborted the become-follower state change with correlation id %d from ").append((Object)Predef$.MODULE$.augmentString(" controller %d epoch %d since leader %d for partition [%s,%d] is unavailable during the state change operation").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)n3), BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), BoxesRunTime.boxToInteger((int)n4), string, BoxesRunTime.boxToInteger((int)n2)}))).toString());
                }
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
            throw new MatchError((Object)option);
        }
    }

    public void updateLeaderHWAndMaybeExpandIsr(int n, long l) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block9: {
                block8: {
                    BoxedUnit boxedUnit;
                    block7: {
                        Replica replica;
                        this.debug((Function0<String>)new Serializable(this, n, l){
                            public static final long serialVersionUID;
                            private final Partition $outer;
                            private final int replicaId$1;
                            private final long offset$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("Recording follower %d position %d for partition [%s,%d].").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), BoxesRunTime.boxToLong((long)this.offset$1), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                            }
                            {
                                if (partition == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = partition;
                                this.replicaId$1 = n;
                                this.offset$1 = l;
                            }
                        });
                        Replica replica2 = this.getOrCreateReplica(n);
                        replica2.logEndOffset_$eq(l);
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block7;
                        Some some = (Some)option;
                        Replica replica3 = replica = (Replica)some.x();
                        Replica replica4 = (Replica)this.getReplica(n).get();
                        long l2 = replica3.highWatermark();
                        if (!this.inSyncReplicas().contains((Object)replica4) && replica4.logEndOffset() >= l2) {
                            Set set = this.inSyncReplicas().$plus((Object)replica4);
                            this.info((Function0<String>)new Serializable(this, set){
                                public static final long serialVersionUID;
                                private final Partition $outer;
                                private final Set newInSyncReplicas$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Expanding ISR for partition [%s,%d] from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.$outer.inSyncReplicas().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Replica replica) {
                                            return replica.brokerId();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Replica replica) {
                                            return replica.brokerId();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                }
                                {
                                    if (partition == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = partition;
                                    this.newInSyncReplicas$1 = set;
                                }
                            });
                            this.updateIsr((Set<Replica>)set);
                            this.replicaManager().isrExpandRate().mark();
                        }
                        this.maybeIncrementLeaderHW(replica3);
                        boxedUnit = BoxedUnit.UNIT;
                        break block8;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block9;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Tuple2<Object, Object> checkEnoughReplicasReachOffset(long l, int n) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Tuple2 tuple2;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    int n2 = this.inSyncReplicas().count((Function1)new Serializable(this, l){
                        public static final long serialVersionUID;
                        private final long requiredOffset$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Replica replica) {
                            return replica.isLocal() ? true : replica.logEndOffset() >= this.requiredOffset$1;
                        }
                        {
                            this.requiredOffset$1 = l;
                        }
                    });
                    this.trace((Function0<String>)new Serializable(this, n, n2){
                        public static final long serialVersionUID;
                        private final Partition $outer;
                        private final int requiredAcks$1;
                        private final int numAcks$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("%d/%d acks satisfied for %s-%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1), BoxesRunTime.boxToInteger((int)this.requiredAcks$1), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                        }
                        {
                            if (partition == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = partition;
                            this.requiredAcks$1 = n;
                            this.numAcks$1 = n2;
                        }
                    });
                    tuple2 = n < 0 && n2 >= this.inSyncReplicas().size() || n > 0 && n2 >= n ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError())) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
                }
                Tuple2 tuple22 = tuple2;
                return tuple22;
            }
            throw new MatchError(option);
        }
    }

    private void maybeIncrementLeaderHW(Replica replica) {
        long l;
        Set set = (Set)this.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(Replica replica) {
                return replica.logEndOffset();
            }
        }, Set$.MODULE$.canBuildFrom());
        long l2 = BoxesRunTime.unboxToLong((Object)set.min((Ordering)Ordering.Long$.MODULE$));
        if (l2 > (l = replica.highWatermark())) {
            replica.highWatermark_$eq(l2);
            this.debug((Function0<String>)new Serializable(this, l2){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final long newHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Highwatermark for partition [%s,%d] updated to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToLong((long)this.newHighWatermark$1)}));
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                    this.newHighWatermark$1 = l;
                }
            });
        } else {
            this.debug((Function0<String>)new Serializable(this, set, l2, l){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set allLogEndOffsets$1;
                private final long newHighWatermark$1;
                private final long oldHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Old hw for partition [%s,%d] is %d. New hw is %d. All leo's are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToLong((long)this.oldHighWatermark$1), BoxesRunTime.boxToLong((long)this.newHighWatermark$1), this.allLogEndOffsets$1.mkString(",")}));
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                    this.allLogEndOffsets$1 = set;
                    this.newHighWatermark$1 = l;
                    this.oldHighWatermark$1 = l2;
                }
            });
        }
    }

    public void maybeShrinkIsr(long l, long l2) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block10: {
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        Replica replica = (Replica)some.x();
                        Replica replica2 = replica;
                        Set<Replica> set = this.getOutOfSyncReplicas(replica2, l, l2);
                        if (set.size() > 0) {
                            Set set2 = (Set)this.inSyncReplicas().$minus$minus(set);
                            Predef$.MODULE$.assert(set2.size() > 0);
                            this.info((Function0<String>)new Serializable(this, set2){
                                public static final long serialVersionUID;
                                private final Partition $outer;
                                private final Set newInSyncReplicas$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Shrinking ISR for partition [%s,%d] from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.$outer.inSyncReplicas().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Replica replica) {
                                            return replica.brokerId();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$2.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Replica replica) {
                                            return replica.brokerId();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                }
                                {
                                    if (partition == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = partition;
                                    this.newInSyncReplicas$2 = set;
                                }
                            });
                            this.updateIsr((Set<Replica>)set2);
                            this.maybeIncrementLeaderHW(replica2);
                            this.replicaManager().isrShrinkRate().mark();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica replica, long l, long l2) {
        Set set;
        Set set2;
        long l3 = replica.logEndOffset();
        Set set3 = this.inSyncReplicas().$minus((Object)replica);
        Set set4 = (Set)set3.filter((Function1)new Serializable(this, l3){
            public static final long serialVersionUID;
            private final long leaderLogEndOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.logEndOffset() < this.leaderLogEndOffset$1;
            }
            {
                this.leaderLogEndOffset$1 = l;
            }
        });
        if (set4.size() > 0) {
            this.debug((Function0<String>)new Serializable(this, set4){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set possiblyStuckReplicas$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Possibly stuck replicas for partition [%s,%d] are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.possiblyStuckReplicas$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                    this.possiblyStuckReplicas$1 = set;
                }
            });
        }
        if ((set2 = (Set)set4.filter((Function1)new Serializable(this, l){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final long keepInSyncTimeMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.logEndOffsetUpdateTimeMs() < this.$outer.kafka$cluster$Partition$$time.milliseconds() - this.keepInSyncTimeMs$1;
            }
            {
                if (partition == null) {
                    throw new NullPointerException();
                }
                this.$outer = partition;
                this.keepInSyncTimeMs$1 = l;
            }
        })).size() > 0) {
            this.debug((Function0<String>)new Serializable(this, set2){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set stuckReplicas$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Stuck replicas for partition [%s,%d] are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.stuckReplicas$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                    this.stuckReplicas$1 = set;
                }
            });
        }
        if ((set = (Set)set3.filter((Function1)new Serializable(this, l2, l3){
            public static final long serialVersionUID;
            private final long keepInSyncMessages$1;
            private final long leaderLogEndOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica replica) {
                return replica.logEndOffset() >= 0L && this.leaderLogEndOffset$1 - replica.logEndOffset() > this.keepInSyncMessages$1;
            }
            {
                this.keepInSyncMessages$1 = l;
                this.leaderLogEndOffset$1 = l2;
            }
        })).size() > 0) {
            this.debug((Function0<String>)new Serializable(this, set){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set slowReplicas$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Slow replicas for partition [%s,%d] are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.slowReplicas$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if (partition == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = partition;
                    this.slowReplicas$1 = set;
                }
            });
        }
        return set2.$plus$plus((GenTraversableOnce)set);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Tuple2<Object, Object> appendMessagesToLeader(ByteBufferMessageSet byteBufferMessageSet) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            Option<Replica> option2 = option = this.leaderReplicaIfLocal();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Replica replica = (Replica)some.x();
                Replica replica2 = replica;
                Log log = (Log)replica2.log().get();
                Tuple2<Object, Object> tuple2 = log.append(byteBufferMessageSet, true);
                if (tuple2 == null) throw new MatchError(tuple2);
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(BoxesRunTime.unboxToLong((Object)tuple2._1()), BoxesRunTime.unboxToLong((Object)tuple2._2()));
                long l = sp2._1$mcJ$sp();
                long l2 = sp2._2$mcJ$sp();
                this.maybeIncrementLeaderHW(replica2);
                Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(l, l2);
                return (Tuple2)sp3;
            }
            {
                None$ none$ = None$.MODULE$;
                Option<Replica> option3 = option2;
                if (none$ == null) {
                    if (option3 == null) throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
                    throw new MatchError(option2);
                } else if (!none$.equals(option3)) throw new MatchError(option2);
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
            }
        }
    }

    private void updateIsr(Set<Replica> set) {
        this.debug((Function0<String>)new Serializable(this, set){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final Set newIsr$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Updated ISR for partition [%s,%d] to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), this.newIsr$1.mkString(",")}));
            }
            {
                if (partition == null) {
                    throw new NullPointerException();
                }
                this.$outer = partition;
                this.newIsr$1 = set;
            }
        });
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)set.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Replica replica) {
                return replica.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Object, Object> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic(), this.partitionId()), ZkUtils$.MODULE$.leaderAndIsrZkData(leaderAndIsr, this.controllerEpoch()), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            int n = tuple22._2$mcI$sp();
            if (bl) {
                this.inSyncReplicas_$eq(set);
                this.kafka$cluster$Partition$$zkVersion_$eq(n);
                this.trace((Function0<String>)new Serializable(this, set){
                    public static final long serialVersionUID;
                    private final Partition $outer;
                    private final Set newIsr$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newIsr$1.mkString(","), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if (partition == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = partition;
                        this.newIsr$1 = set;
                    }
                });
            } else {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final Partition $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if (partition == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = partition;
                    }
                });
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean equals(Object object) {
        if (object instanceof Partition) {
            Partition partition = (Partition)object;
            return this.topic().equals(partition.topic()) && this.partitionId() == partition.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.assignedReplicaMap().keys().mkString(",")).toString());
            stringBuilder.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Replica replica) {
                    return replica.brokerId();
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
            String string = stringBuilder.toString();
            return string;
        }
    }

    public Partition(String string, int n, int n2, Time time, ReplicaManager replicaManager) {
        this.topic = string;
        this.partitionId = n;
        this.replicationFactor = n2;
        this.kafka$cluster$Partition$$time = time;
        this.replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.replicaFetcherManager = replicaManager.replicaFetcherManager();
        this.zkClient = replicaManager.zkClient();
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.init$default$1());
        this.leaderIsrUpdateLock = new Object();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string, BoxesRunTime.boxToInteger((int)n), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge(new StringBuilder().append((Object)string).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)"-UnderReplicated").toString(), new Gauge<Object>(this){
            private final Partition $outer;

            public int value() {
                return this.$outer.isUnderReplicated() ? 1 : 0;
            }
            {
                if (partition == null) {
                    throw new NullPointerException();
                }
                this.$outer = partition;
            }
        });
    }
}

