/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ApiUtils$
implements ScalaObject {
    public static final ApiUtils$ MODULE$;
    private final String ProtocolEncoding;

    static {
        new ApiUtils$();
    }

    public String ProtocolEncoding() {
        return this.ProtocolEncoding;
    }

    public String readShortString(ByteBuffer byteBuffer) {
        short s = byteBuffer.getShort();
        if (s < 0) {
            return null;
        }
        byte[] byArray = new byte[s];
        byteBuffer.get(byArray);
        return new String(byArray, this.ProtocolEncoding());
    }

    public void writeShortString(ByteBuffer byteBuffer, String string) {
        if (string == null) {
            byteBuffer.putShort((short)-1);
        } else {
            byte[] byArray = string.getBytes(this.ProtocolEncoding());
            if (byArray.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            byteBuffer.putShort((short)byArray.length);
            byteBuffer.put(byArray);
        }
    }

    public int shortStringLength(String string) {
        int n;
        if (string == null) {
            n = 2;
        } else {
            byte[] byArray = string.getBytes(this.ProtocolEncoding());
            if (byArray.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append((Object)BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            n = 2 + byArray.length;
        }
        return n;
    }

    public int readIntInRange(ByteBuffer byteBuffer, String string, Tuple2<Object, Object> tuple2) {
        int n = byteBuffer.getInt();
        if (n < tuple2._1$mcI$sp() || n > tuple2._2$mcI$sp()) {
            throw new KafkaException(new StringBuilder().append((Object)string).append((Object)" has value ").append((Object)BoxesRunTime.boxToInteger((int)n)).append((Object)" which is not in the range ").append(tuple2).append((Object)".").toString());
        }
        return n;
    }

    public short readShortInRange(ByteBuffer byteBuffer, String string, Tuple2<Object, Object> tuple2) {
        short s = byteBuffer.getShort();
        if (s < BoxesRunTime.unboxToShort((Object)tuple2._1()) || s > BoxesRunTime.unboxToShort((Object)tuple2._2())) {
            throw new KafkaException(new StringBuilder().append((Object)string).append((Object)" has value ").append((Object)BoxesRunTime.boxToShort((short)s)).append((Object)" which is not in the range ").append(tuple2).append((Object)".").toString());
        }
        return s;
    }

    public long readLongInRange(ByteBuffer byteBuffer, String string, Tuple2<Object, Object> tuple2) {
        long l = byteBuffer.getLong();
        if (l < tuple2._1$mcJ$sp() || l > tuple2._2$mcJ$sp()) {
            throw new KafkaException(new StringBuilder().append((Object)string).append((Object)" has value ").append((Object)BoxesRunTime.boxToLong((long)l)).append((Object)" which is not in the range ").append(tuple2).append((Object)".").toString());
        }
        return l;
    }

    private ApiUtils$() {
        MODULE$ = this;
        this.ProtocolEncoding = "UTF-8";
    }
}

