(ns com.uncrafted.bloguito)

(use 'compojure.route
     'markdown.core
     'me.shenfeng.mustache
     'compojure.handler
     'compojure.core
     'org.httpkit.server)

(deftemplate tmpl-fn (slurp "templates/sample.tpl"))

(def data {:title "mustache.clj"
           :desc "Logic-less {{mustache}} templates for Clojure"
           :tags [{:tag "Clojure"}
                  {:tag "Mustache"}
                  {:tag "Performance"}]})

(defroutes all-routes
  (GET "/" [] {:status  200
               :headers {"Content-Type" "text/html"}
               :body    (tmpl-fn data)})
  (GET "/md" [] {:status  200
               :headers {"Content-Type" "text/html"}
               :body    (md-to-html-string (slurp "markdown/article01.md"))}))

(defn -main [& args]
  (run-server (site #'all-routes) {:port 8080}))
