<pre>
_/\/\____/\/\____/\/\/\/\____/\/\/\/\/\________/\/\_____
_/\/\____/\/\__/\/\____/\/\__/\/\____/\/\____/\/\/\/\___
___/\/\/\/\____/\/\____/\/\__/\/\/\/\/\____/\/\____/\/\_
_____/\/\______/\/\____/\/\__/\/\__________/\/\/\/\/\/\_
_____/\/\________/\/\/\/\____/\/\__________/\/\____/\/\_
________________________________________________________
</pre>

_YOPA is Your Own Personal AWS_

It allows developers to code without being connected to the net.

# Features

- Full-fledged SQS implementation (courtesy of https://github.com/adamw/elasticmq).
- SNS stub with support for pre-defined (raw or wrapped) SQS, HTTP and HTTPS subscriptions.
  Note that the SNS stub does not confirm HTTP/S subscriptions nor retry HTTP/S failed deliveries.


## Build and run

Run the integration tests:

    lein test

Run with the example config:

    lein trampoline run --config yopa-config-example.yml


## Usage

Run `lein run` to get help.

The following examples assume all the default configuration parameters are used.


### AWS CLI

    aws --endpoint-url http://localhost:47196 sns list-topics


### Ruby

    AWS.config(:access_key_id => 'x',
               :secret_access_key => 'x',
               :region => 'yopa-local',
               :use_ssl => false,
               :sqs_endpoint => 'localhost',
               :sqs_port => 47195,
               :sns_endpoint => 'localhost',
               :sns_port => 47196)


### JVM

You can either set the endpoints explicitly, like with:

    AmazonSNS snsClient = new AmazonSNSClient(awsCredentials);
    snsClient.setEndpoint("http://localhost:47196");


Or you can configure the SDK to load the regions override configuration generated by Yopa and get the `yopa-local` region:

    System.setProperty(SDKGlobalConfiguration.REGIONS_FILE_OVERRIDE_SYSTEM_PROPERTY, "/tmp/aws-regions-override.xml");
    Region region = RegionUtils.getRegion("yopa-local");

and then either set the region on the client, while forcing the client to use HTTP:

    AmazonSNS snsClient = new AmazonSNSClient(awsCredentials, new ClientConfiguration().withProtocol(Protocol.HTTP));
    snsClient.setRegion(region);

or derive the endpoint from the region:

    AmazonSNS snsClient = new AmazonSNSClient(awsCredentials);
    snsClient.setEndpoint("http://" + region.getServiceEndpoint("sns"));

