(ns freebie.util
  (:require [clojure.core.match :refer [match]]
            [schema.core :as s]))

(defn split-signatures-from-args [args]
  (loop [acc     {:args [] :arg-types {}}
         current args]
    (match [current]

           ;;
           [([arg (_ :guard #(= % ':-)) ty & rest] :seq)]
           (recur (-> acc
                      (update-in [:args] conj arg)
                      (assoc-in [:arg-types arg] ty))
                  rest)

           ;;
           [([arg & rest] :seq)]
           (recur (-> acc
                      (update-in [:args] conj arg)
                      (assoc-in [:arg-types arg] s/Any))
                  rest)

           ;;
           [_] acc)))
