(ns freebie.types
  (:require [monads.core :refer :all]
            [clojure.algo.generic.functor :refer [fmap]]))

(defrecord Free [type functor-value])

(defn pure [val]
  (map->Free {:type :pure
              :functor-value val}))

(defn free [val]
  (map->Free {:type :free
              :functor-value val}))

(defmethod fmap Free [f free-val]
  (condp = (:type free-val)
    :pure (pure (f (:functor-value free-val)))
    :free (free (fmap f (:functor-value free-val)))))

(defn lift-f [command]
  (free (fmap pure command)))

(defmonad free-m
  (mreturn [self val] (pure val))
  (bind [self ma fb]
        (condp = (:type ma)
          :pure (fb (:functor-value ma))
          :free (free
                 (fmap (fn -free-m-bind [lower-ma]
                         (run-monad self (>>= lower-ma fb)))
                       (:functor-value ma))))))
(defn eval-instr
  ([program]
   (if (instance? Free program)
     program
     (run-monad free-m program))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(defrecord F [free-fn])

(defmethod fmap F [f f-val]
  (->F (fn [kp kf]
         ((:free-fn f-val) (comp kp f) kf))))

(defn f-free-m-return [self val]
  (->F (fn f-free-return [kp _]
         (kp val))))

(defn f-free-m-wrap [self f]
  (->F (fn f-free-wrap [kp kf]
         (kf (fmap (fn [{:keys [free-fn]}]
                     (free-fn kp kf))
                   f)))))

(defmonad f-free-m
  (mreturn [self val] (f-free-m-return self val))
  (bind [self ma fb]
        (->F (fn f-free-bind [kp kf]
               ((:free-fn ma)
                  (fn [b]
                    (run-monad self ((:free-fn (fb b)) kp kf)))
                  kf)))))

(defn to-f
  [free-val0]
  (letfn [(to-f-helper [kp kf free-val0]
            (let [{:keys [functor-value] :as free-val} (eval-instr free-val0)]
              (condp = (:type free-val)
                :pure (kp functor-value)
                :free
                (do
                  (kf (fmap #(to-f-helper kp kf %) functor-value)))

                (assert false
                        (str "Unexpected type " (pr-str (type free-val))
                             "; expecting Free value")))))]
    (->F (fn [kp kf] (to-f-helper kp kf free-val0)))))

(defn from-f
  [f-val]
  ((:free-fn f-val) pure free))

(defn improve
  [program0]
  (let [program (eval-instr program0)]
    (assert (instance? Free program)
            (str "Expecting variable of type "
                 (pr-str (type program0))
                 " to be instance of Free, but wasn't"))
    (from-f (to-f program))))
