/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.util;

import com.twilight.h264.util.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    public PushbackInputStream(InputStream is) {
        super(is);
        this.buf = is == null ? null : new byte[1];
        this.pos = 1;
    }

    public PushbackInputStream(InputStream is, int size) {
        super(is);
        this.buf = is == null ? null : new byte[size];
        this.pos = size;
    }

    @Override
    public int available() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        return this.buf.length - this.pos + this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
            this.buf = null;
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        int copiedBytes = 0;
        int copyLength = 0;
        int newOffset = offset;
        if (this.pos < this.buf.length) {
            copyLength = this.buf.length - this.pos >= len ? len : this.buf.length - this.pos;
            System.arraycopy(this.buf, this.pos, buffer, newOffset, copyLength);
            newOffset += copyLength;
            copiedBytes += copyLength;
            this.pos += copyLength;
        }
        if (copyLength == len) {
            return len;
        }
        int inCopied = this.inputStream.read(buffer, newOffset, len - copiedBytes);
        if (inCopied > 0) {
            return inCopied + copiedBytes;
        }
        if (copiedBytes == 0) {
            return inCopied;
        }
        return copiedBytes;
    }

    @Override
    public long skip(long count) throws IOException {
        if (this.inputStream == null) {
            throw new IOException();
        }
        if (count <= 0L) {
            return 0L;
        }
        int numSkipped = 0;
        if (this.pos < this.buf.length) {
            numSkipped = (int)((long)numSkipped + (count < (long)(this.buf.length - this.pos) ? count : (long)(this.buf.length - this.pos)));
            this.pos += numSkipped;
        }
        if ((long)numSkipped < count) {
            numSkipped = (int)((long)numSkipped + this.inputStream.skip(count - (long)numSkipped));
        }
        return numSkipped;
    }

    public void unread(byte[] buffer) throws IOException {
        this.unread(buffer, 0, buffer.length);
    }

    public void unread(byte[] buffer, int offset, int length) throws IOException {
        if (length > this.pos) {
            throw new IOException();
        }
        System.arraycopy(buffer, offset, this.buf, this.pos - length, length);
        this.pos -= length;
    }

    public void unread(int oneByte) throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        this.buf[--this.pos] = (byte)oneByte;
    }

    @Override
    public void mark(int limit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }
}

